/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.bestsolution;

import org.drools.planner.core.event.SolverEventSupport;
import org.drools.planner.core.phase.AbstractSolverPhaseScope;
import org.drools.planner.core.phase.event.SolverPhaseLifecycleListenerAdapter;
import org.drools.planner.core.phase.step.AbstractStepScope;
import org.drools.planner.core.score.Score;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.core.solver.scope.DefaultSolverScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BestSolutionRecaller
extends SolverPhaseLifecycleListenerAdapter {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected boolean assertBestScoreIsUnmodified = false;
    protected SolverEventSupport solverEventSupport;

    public void setAssertBestScoreIsUnmodified(boolean assertBestScoreIsUnmodified) {
        this.assertBestScoreIsUnmodified = assertBestScoreIsUnmodified;
    }

    public void setSolverEventSupport(SolverEventSupport solverEventSupport) {
        this.solverEventSupport = solverEventSupport;
    }

    @Override
    public void solvingStarted(DefaultSolverScope solverScope) {
        boolean workingSolutionInitialized = solverScope.isWorkingSolutionInitialized();
        Score startingInitializedScore = workingSolutionInitialized ? solverScope.calculateScore() : null;
        solverScope.setStartingInitializedScore(startingInitializedScore);
        solverScope.setBestScore(startingInitializedScore);
        solverScope.getBestSolution().setScore(startingInitializedScore);
    }

    @Override
    public void stepEnded(AbstractStepScope stepScope) {
        boolean bestScoreImproved;
        if (!stepScope.isSolutionInitialized()) {
            return;
        }
        AbstractSolverPhaseScope phaseScope = stepScope.getPhaseScope();
        DefaultSolverScope solverScope = phaseScope.getSolverScope();
        Score newScore = stepScope.getScore();
        Score bestScore = solverScope.getBestScore();
        if (bestScore == null) {
            bestScoreImproved = true;
            solverScope.setStartingInitializedScore(newScore);
        } else {
            bestScoreImproved = newScore.compareTo(bestScore) > 0;
        }
        stepScope.setBestScoreImproved(bestScoreImproved);
        if (bestScoreImproved) {
            phaseScope.setBestSolutionStepIndex(stepScope.getStepIndex());
            Solution newBestSolution = stepScope.createOrGetClonedSolution();
            this.updateBestSolution(solverScope, newBestSolution);
        } else if (this.assertBestScoreIsUnmodified) {
            solverScope.assertScore(solverScope.getBestSolution());
        }
    }

    public void updateBestSolution(DefaultSolverScope solverScope, Solution newBestSolution) {
        solverScope.setBestSolution(newBestSolution);
        solverScope.setBestScore((Score)newBestSolution.getScore());
        this.solverEventSupport.fireBestSolutionChanged(newBestSolution);
    }
}

