/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.constructionheuristic.greedyFit.decider.forager;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.drools.planner.core.constructionheuristic.greedyFit.decider.ConstructionHeuristicPickEarlyType;
import org.drools.planner.core.constructionheuristic.greedyFit.decider.GreedyMoveScope;
import org.drools.planner.core.constructionheuristic.greedyFit.event.GreedySolverPhaseLifecycleListenerAdapter;
import org.drools.planner.core.constructionheuristic.greedyFit.scope.GreedyFitStepScope;
import org.drools.planner.core.score.Score;
import org.drools.planner.core.score.comparator.NaturalScoreComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GreedyForager
extends GreedySolverPhaseLifecycleListenerAdapter {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Comparator<Score> scoreComparator = new NaturalScoreComparator();
    protected ConstructionHeuristicPickEarlyType pickEarlyType;
    protected int minimalAcceptedSelection = Integer.MAX_VALUE;
    protected int selectedCount;
    protected List<GreedyMoveScope> maxScoreAcceptedList;
    protected Score maxScore;
    protected GreedyMoveScope earlyPickedMoveScope = null;

    public void setPickEarlyType(ConstructionHeuristicPickEarlyType pickEarlyType) {
        this.pickEarlyType = pickEarlyType;
    }

    public void setMinimalAcceptedSelection(int minimalAcceptedSelection) {
        this.minimalAcceptedSelection = minimalAcceptedSelection;
    }

    @Override
    public void stepStarted(GreedyFitStepScope greedyStepScope) {
        this.selectedCount = 0;
        this.maxScoreAcceptedList = new ArrayList<GreedyMoveScope>(1024);
        this.maxScore = greedyStepScope.getPhaseScope().getScoreDefinition().getPerfectMinimumScore();
        this.earlyPickedMoveScope = null;
    }

    public void addMove(GreedyMoveScope moveScope) {
        ++this.selectedCount;
        this.checkPickEarly(moveScope);
        this.addMoveScopeToAcceptedList(moveScope);
    }

    protected void checkPickEarly(GreedyMoveScope moveScope) {
        switch (this.pickEarlyType) {
            case NEVER: {
                break;
            }
            case FIRST_LAST_STEP_SCORE_EQUAL_OR_IMPROVING: {
                Score lastStepScore = moveScope.getGreedyFitStepScope().getPhaseScope().getLastCompletedStepScope().getScore();
                if (lastStepScore == null || moveScope.getScore().compareTo(lastStepScore) < 0) break;
                this.earlyPickedMoveScope = moveScope;
                break;
            }
            default: {
                throw new IllegalStateException("The pickEarlyType (" + (Object)((Object)this.pickEarlyType) + ") is not implemented");
            }
        }
    }

    protected void addMoveScopeToAcceptedList(GreedyMoveScope moveScope) {
        if (this.scoreComparator.compare(moveScope.getScore(), this.maxScore) > 0) {
            this.maxScore = moveScope.getScore();
            this.maxScoreAcceptedList.clear();
            this.maxScoreAcceptedList.add(moveScope);
        } else if (moveScope.getScore().equals(this.maxScore)) {
            this.maxScoreAcceptedList.add(moveScope);
        }
    }

    public boolean isQuitEarly() {
        return this.earlyPickedMoveScope != null || this.selectedCount >= this.minimalAcceptedSelection;
    }

    public GreedyMoveScope pickMove(GreedyFitStepScope greedyStepScope) {
        if (this.earlyPickedMoveScope != null) {
            return this.earlyPickedMoveScope;
        }
        return this.pickMaxScoreMoveScopeFromAcceptedList(greedyStepScope);
    }

    protected GreedyMoveScope pickMaxScoreMoveScopeFromAcceptedList(GreedyFitStepScope greedyStepScope) {
        if (this.maxScoreAcceptedList.isEmpty()) {
            return null;
        }
        if (this.maxScoreAcceptedList.size() == 1) {
            return this.maxScoreAcceptedList.get(0);
        }
        return this.maxScoreAcceptedList.get(0);
    }

    public int getSelectedCount() {
        return this.selectedCount;
    }
}

