/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.domain.entity;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;
import org.drools.planner.api.domain.entity.PlanningEntityDifficultyWeightFactory;
import org.drools.planner.core.solution.Solution;

public class PlanningEntitySorter {
    private Comparator<Object> difficultyComparator = null;
    private PlanningEntityDifficultyWeightFactory difficultyWeightFactory = null;

    public void setDifficultyComparator(Comparator<Object> difficultyComparator) {
        this.difficultyComparator = difficultyComparator;
    }

    public void setDifficultyWeightFactory(PlanningEntityDifficultyWeightFactory difficultyWeightFactory) {
        this.difficultyWeightFactory = difficultyWeightFactory;
    }

    public boolean isSortDifficultySupported() {
        return this.difficultyComparator != null || this.difficultyWeightFactory != null;
    }

    public void sortDifficultyAscending(Solution solution, List<Object> planningEntityList) {
        if (this.difficultyComparator != null) {
            Collections.sort(planningEntityList, this.difficultyComparator);
        } else if (this.difficultyWeightFactory != null) {
            TreeMap<Comparable, Object> planningEntityMap = new TreeMap<Comparable, Object>();
            for (Object planningEntity : planningEntityList) {
                Comparable difficultyWeight = this.difficultyWeightFactory.createDifficultyWeight(solution, planningEntity);
                Object previous = planningEntityMap.put(difficultyWeight, planningEntity);
                if (previous == null) continue;
                throw new IllegalStateException("The planningEntityList contains 2 times the same planningEntity (" + previous + ") and (" + planningEntity + ").");
            }
            planningEntityList.clear();
            planningEntityList.addAll(planningEntityMap.values());
        } else {
            throw new IllegalStateException("Sorting on difficulty is impossible because difficultyComparator and difficultyWeightFactory are null.");
        }
    }

    public void sortDifficultyDescending(Solution solution, List<Object> planningEntityList) {
        this.sortDifficultyAscending(solution, planningEntityList);
        Collections.reverse(planningEntityList);
    }
}

