/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.domain.variable;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import org.drools.planner.api.domain.variable.PlanningValueStrengthWeightFactory;
import org.drools.planner.api.domain.variable.PlanningVariable;
import org.drools.planner.api.domain.variable.ValueRange;
import org.drools.planner.api.domain.variable.ValueRanges;
import org.drools.planner.config.util.ConfigUtils;
import org.drools.planner.core.domain.common.DescriptorUtils;
import org.drools.planner.core.domain.entity.PlanningEntityDescriptor;
import org.drools.planner.core.domain.variable.CompositePlanningValueRangeDescriptor;
import org.drools.planner.core.domain.variable.PlanningEntityPropertyPlanningValueRangeDescriptor;
import org.drools.planner.core.domain.variable.PlanningValueRangeDescriptor;
import org.drools.planner.core.domain.variable.PlanningValueSorter;
import org.drools.planner.core.domain.variable.SolutionPropertyPlanningValueRangeDescriptor;
import org.drools.planner.core.domain.variable.UndefinedPlanningValueRangeDescriptor;
import org.drools.planner.core.heuristic.selector.common.decorator.SelectionFilter;
import org.drools.planner.core.heuristic.selector.entity.decorator.NullValueUninitializedEntityFilter;
import org.drools.planner.core.solution.Solution;

public class PlanningVariableDescriptor {
    private final PlanningEntityDescriptor planningEntityDescriptor;
    private final PropertyDescriptor variablePropertyDescriptor;
    private boolean chained;
    private PlanningValueRangeDescriptor valueRangeDescriptor;
    private boolean nullable;
    private SelectionFilter uninitializedEntityFilter;
    private PlanningValueSorter valueSorter;

    public PlanningVariableDescriptor(PlanningEntityDescriptor planningEntityDescriptor, PropertyDescriptor variablePropertyDescriptor) {
        this.planningEntityDescriptor = planningEntityDescriptor;
        this.variablePropertyDescriptor = variablePropertyDescriptor;
    }

    public void processAnnotations() {
        this.processPropertyAnnotations();
    }

    private void processPropertyAnnotations() {
        PlanningVariable planningVariableAnnotation = this.variablePropertyDescriptor.getReadMethod().getAnnotation(PlanningVariable.class);
        this.valueSorter = new PlanningValueSorter();
        this.processNullable(planningVariableAnnotation);
        this.processStrength(planningVariableAnnotation);
        this.processChained(planningVariableAnnotation);
        this.processValueRangeAnnotation();
    }

    private void processNullable(PlanningVariable planningVariableAnnotation) {
        this.nullable = planningVariableAnnotation.nullable();
        if (this.nullable && this.variablePropertyDescriptor.getPropertyType().isPrimitive()) {
            throw new IllegalArgumentException("The planningEntityClass (" + this.planningEntityDescriptor.getPlanningEntityClass() + ") has a PlanningVariable annotated property (" + this.variablePropertyDescriptor.getName() + ") with nullable (" + this.nullable + "), which is not compatible with the primitive propertyType (" + this.variablePropertyDescriptor.getPropertyType() + ").");
        }
        Class<? extends SelectionFilter> uninitializedEntityFilterClass = planningVariableAnnotation.uninitializedEntityFilter();
        if (uninitializedEntityFilterClass == PlanningVariable.NullUninitializedEntityFilter.class) {
            uninitializedEntityFilterClass = null;
        }
        this.uninitializedEntityFilter = uninitializedEntityFilterClass != null ? ConfigUtils.newInstance(this, "uninitializedEntityFilterClass", uninitializedEntityFilterClass) : new NullValueUninitializedEntityFilter(this);
    }

    private void processStrength(PlanningVariable planningVariableAnnotation) {
        Class<? extends PlanningValueStrengthWeightFactory> strengthWeightFactoryClass;
        Class<? extends Comparator> strengthComparatorClass = planningVariableAnnotation.strengthComparatorClass();
        if (strengthComparatorClass == PlanningVariable.NullStrengthComparator.class) {
            strengthComparatorClass = null;
        }
        if ((strengthWeightFactoryClass = planningVariableAnnotation.strengthWeightFactoryClass()) == PlanningVariable.NullStrengthWeightFactory.class) {
            strengthWeightFactoryClass = null;
        }
        if (strengthComparatorClass != null && strengthWeightFactoryClass != null) {
            throw new IllegalStateException("The planningEntityClass (" + this.planningEntityDescriptor.getPlanningEntityClass() + ") property (" + this.variablePropertyDescriptor.getName() + ") cannot have a strengthComparatorClass (" + strengthComparatorClass.getName() + ") and a strengthWeightFactoryClass (" + strengthWeightFactoryClass.getName() + ") at the same time.");
        }
        if (strengthComparatorClass != null) {
            Comparator strengthComparator = ConfigUtils.newInstance(this, "strengthComparatorClass", strengthComparatorClass);
            this.valueSorter.setStrengthComparator(strengthComparator);
        }
        if (strengthWeightFactoryClass != null) {
            PlanningValueStrengthWeightFactory strengthWeightFactory = ConfigUtils.newInstance(this, "strengthWeightFactoryClass", strengthWeightFactoryClass);
            this.valueSorter.setStrengthWeightFactory(strengthWeightFactory);
        }
    }

    private void processChained(PlanningVariable planningVariableAnnotation) {
        this.chained = planningVariableAnnotation.chained();
        if (this.chained && !this.variablePropertyDescriptor.getPropertyType().isAssignableFrom(this.planningEntityDescriptor.getPlanningEntityClass())) {
            throw new IllegalArgumentException("The planningEntityClass (" + this.planningEntityDescriptor.getPlanningEntityClass() + ") has a PlanningVariable annotated property (" + this.variablePropertyDescriptor.getName() + ") with chained (" + this.chained + ") and propertyType (" + this.variablePropertyDescriptor.getPropertyType() + ") which is not a superclass/interface of or the same as the planningEntityClass (" + this.planningEntityDescriptor.getPlanningEntityClass() + ").");
        }
        if (this.chained && this.nullable) {
            throw new IllegalArgumentException("The planningEntityClass (" + this.planningEntityDescriptor.getPlanningEntityClass() + ") has a PlanningVariable annotated property (" + this.variablePropertyDescriptor.getName() + ") with chained (" + this.chained + "), which is not compatible with nullable (" + this.nullable + ").");
        }
    }

    private void processValueRangeAnnotation() {
        Method propertyGetter = this.variablePropertyDescriptor.getReadMethod();
        ValueRange valueRangeAnnotation = propertyGetter.getAnnotation(ValueRange.class);
        ValueRanges valueRangesAnnotation = propertyGetter.getAnnotation(ValueRanges.class);
        if (valueRangeAnnotation != null) {
            if (valueRangesAnnotation != null) {
                throw new IllegalArgumentException("The planningEntityClass (" + this.planningEntityDescriptor.getPlanningEntityClass() + ") has a PlanningVariable annotated property (" + this.variablePropertyDescriptor.getName() + ") that has a @ValueRange and @ValueRanges annotation: fold them into 1 @ValueRanges.");
            }
            this.valueRangeDescriptor = this.buildValueRangeDescriptor(valueRangeAnnotation);
        } else {
            if (valueRangesAnnotation == null) {
                throw new IllegalArgumentException("The planningEntityClass (" + this.planningEntityDescriptor.getPlanningEntityClass() + ") has a PlanningVariable annotated property (" + this.variablePropertyDescriptor.getName() + ") that has no @ValueRange or @ValueRanges annotation.");
            }
            ArrayList<PlanningValueRangeDescriptor> valueRangeDescriptorList = new ArrayList<PlanningValueRangeDescriptor>(valueRangesAnnotation.value().length);
            for (ValueRange partialValueRangeAnnotation : valueRangesAnnotation.value()) {
                valueRangeDescriptorList.add(this.buildValueRangeDescriptor(partialValueRangeAnnotation));
            }
            this.valueRangeDescriptor = new CompositePlanningValueRangeDescriptor(this, valueRangeDescriptorList);
        }
    }

    private PlanningValueRangeDescriptor buildValueRangeDescriptor(ValueRange valueRangeAnnotation) {
        switch (valueRangeAnnotation.type()) {
            case FROM_SOLUTION_PROPERTY: {
                return new SolutionPropertyPlanningValueRangeDescriptor(this, valueRangeAnnotation);
            }
            case FROM_PLANNING_ENTITY_PROPERTY: {
                return new PlanningEntityPropertyPlanningValueRangeDescriptor(this, valueRangeAnnotation);
            }
            case UNDEFINED: {
                return new UndefinedPlanningValueRangeDescriptor(this, valueRangeAnnotation);
            }
        }
        throw new IllegalStateException("The valueRangeType (" + (Object)((Object)valueRangeAnnotation.type()) + ") is not implemented");
    }

    public PlanningEntityDescriptor getPlanningEntityDescriptor() {
        return this.planningEntityDescriptor;
    }

    public String getVariableName() {
        return this.variablePropertyDescriptor.getName();
    }

    public Class<?> getVariablePropertyType() {
        return this.variablePropertyDescriptor.getPropertyType();
    }

    public boolean isContinuous() {
        return false;
    }

    public boolean isChained() {
        return this.chained;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    @Deprecated
    public boolean isInitialized(Object planningEntity) {
        if (this.nullable) {
            return true;
        }
        Object variable = DescriptorUtils.executeGetter(this.variablePropertyDescriptor, planningEntity);
        return variable != null;
    }

    public void uninitialize(Object planningEntity) {
        DescriptorUtils.executeSetter(this.variablePropertyDescriptor, planningEntity, null);
    }

    public Object getValue(Object planningEntity) {
        return DescriptorUtils.executeGetter(this.variablePropertyDescriptor, planningEntity);
    }

    public void setValue(Object planningEntity, Object value) {
        DescriptorUtils.executeSetter(this.variablePropertyDescriptor, planningEntity, value);
    }

    public Collection<?> extractAllPlanningValues(Solution solution) {
        return this.valueRangeDescriptor.extractAllValues(solution);
    }

    public Collection<?> extractPlanningValues(Solution solution, Object planningEntity) {
        return this.valueRangeDescriptor.extractValues(solution, planningEntity);
    }

    @Deprecated
    public boolean isPlanningValuesCacheable() {
        return this.valueRangeDescriptor.isValuesCacheable();
    }

    @Deprecated
    public PlanningValueSorter getValueSorter() {
        return this.valueSorter;
    }

    public long getProblemScale(Solution solution, Object planningEntity) {
        return this.valueRangeDescriptor.getProblemScale(solution, planningEntity);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.variablePropertyDescriptor.getName() + " of " + this.planningEntityDescriptor.getPlanningEntityClass().getName() + ")";
    }
}

