/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.domain.variable;

import java.beans.PropertyDescriptor;
import java.util.Collection;
import org.drools.planner.api.domain.variable.ValueRange;
import org.drools.planner.core.domain.common.DescriptorUtils;
import org.drools.planner.core.domain.entity.PlanningEntityDescriptor;
import org.drools.planner.core.domain.variable.AbstractPlanningValueRangeDescriptor;
import org.drools.planner.core.domain.variable.PlanningVariableDescriptor;
import org.drools.planner.core.solution.Solution;

public class SolutionPropertyPlanningValueRangeDescriptor
extends AbstractPlanningValueRangeDescriptor {
    private PropertyDescriptor rangePropertyDescriptor;

    public SolutionPropertyPlanningValueRangeDescriptor(PlanningVariableDescriptor variableDescriptor, ValueRange valueRangeAnnotation) {
        super(variableDescriptor);
        this.validate(valueRangeAnnotation);
        this.processValueRangeAnnotation(valueRangeAnnotation);
    }

    private void validate(ValueRange valueRangeAnnotation) {
        if (valueRangeAnnotation.solutionProperty().equals("")) {
            throw new IllegalArgumentException("The planningEntityClass (" + this.variableDescriptor.getPlanningEntityDescriptor().getPlanningEntityClass() + ") has a PlanningVariable annotated property (" + this.variableDescriptor.getVariableName() + ") of type (" + (Object)((Object)valueRangeAnnotation.type()) + ") with an empty solutionProperty (" + valueRangeAnnotation.solutionProperty() + ").");
        }
        if (!valueRangeAnnotation.planningEntityProperty().equals("")) {
            throw new IllegalArgumentException("The planningEntityClass (" + this.variableDescriptor.getPlanningEntityDescriptor().getPlanningEntityClass() + ") has a PlanningVariable annotated property (" + this.variableDescriptor.getVariableName() + ") of type (" + (Object)((Object)valueRangeAnnotation.type()) + ") with a non-empty planningEntityProperty (" + valueRangeAnnotation.planningEntityProperty() + ").");
        }
    }

    private void processValueRangeAnnotation(ValueRange valueRangeAnnotation) {
        this.processSolutionProperty(valueRangeAnnotation);
        this.processExcludeUninitializedPlanningEntity(valueRangeAnnotation);
    }

    private void processSolutionProperty(ValueRange valueRangeAnnotation) {
        String solutionProperty = valueRangeAnnotation.solutionProperty();
        PlanningEntityDescriptor planningEntityDescriptor = this.variableDescriptor.getPlanningEntityDescriptor();
        this.rangePropertyDescriptor = planningEntityDescriptor.getSolutionDescriptor().getPropertyDescriptor(solutionProperty);
        if (this.rangePropertyDescriptor == null) {
            String exceptionMessage = "The planningEntityClass (" + planningEntityDescriptor.getPlanningEntityClass() + ") has a PlanningVariable annotated property (" + this.variableDescriptor.getVariableName() + ") that refers to a solutionClass (" + planningEntityDescriptor.getSolutionDescriptor().getSolutionClass() + ") solutionProperty (" + solutionProperty + ") that does not exist.";
            if (solutionProperty.length() >= 2 && Character.isUpperCase(solutionProperty.charAt(1))) {
                String correctedSolutionProperty = solutionProperty.substring(0, 1).toUpperCase() + solutionProperty.substring(1);
                exceptionMessage = exceptionMessage + " But it probably needs to be correctedSolutionProperty (" + correctedSolutionProperty + ") instead because the JavaBeans spec states" + " the first letter should be a upper case if the second is upper case.";
            }
            throw new IllegalArgumentException(exceptionMessage);
        }
        if (!Collection.class.isAssignableFrom(this.rangePropertyDescriptor.getPropertyType())) {
            throw new IllegalArgumentException("The planningEntityClass (" + planningEntityDescriptor.getPlanningEntityClass() + ") has a PlanningVariable annotated property (" + this.variableDescriptor.getVariableName() + ") that refers to a solutionClass (" + planningEntityDescriptor.getSolutionDescriptor().getSolutionClass() + ") solutionProperty (" + solutionProperty + ") that does not return a Collection.");
        }
    }

    @Override
    public Collection<?> extractAllValues(Solution solution) {
        Collection<?> values = this.extractValuesWithoutFiltering(solution);
        return this.applyFiltering(values);
    }

    @Override
    public Collection<?> extractValues(Solution solution, Object planningEntity) {
        return this.extractAllValues(solution);
    }

    private Collection<?> extractValuesWithoutFiltering(Solution solution) {
        return (Collection)DescriptorUtils.executeGetter(this.rangePropertyDescriptor, solution);
    }

    @Override
    public long getProblemScale(Solution solution, Object planningEntity) {
        return this.extractValuesWithoutFiltering(solution).size();
    }

    @Override
    public boolean isValuesCacheable() {
        return !this.excludeUninitializedPlanningEntity;
    }
}

