/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.heuristic.selector.move.generic;

import java.util.Collection;
import java.util.Iterator;
import org.drools.planner.core.domain.entity.PlanningEntityDescriptor;
import org.drools.planner.core.domain.variable.PlanningVariableDescriptor;
import org.drools.planner.core.heuristic.selector.common.iterator.AbstractOriginalSwapIterator;
import org.drools.planner.core.heuristic.selector.common.iterator.AbstractRandomSwapIterator;
import org.drools.planner.core.heuristic.selector.common.iterator.ListIterable;
import org.drools.planner.core.heuristic.selector.entity.EntitySelector;
import org.drools.planner.core.heuristic.selector.move.generic.GenericMoveSelector;
import org.drools.planner.core.heuristic.selector.move.generic.SwapMove;
import org.drools.planner.core.heuristic.selector.move.generic.chained.ChainedSwapMove;
import org.drools.planner.core.move.Move;

public class SwapMoveSelector
extends GenericMoveSelector {
    protected final EntitySelector leftEntitySelector;
    protected final EntitySelector rightEntitySelector;
    protected final Collection<PlanningVariableDescriptor> variableDescriptors;
    protected final boolean randomSelection;
    protected final boolean anyChained;

    public SwapMoveSelector(EntitySelector leftEntitySelector, EntitySelector rightEntitySelector, Collection<PlanningVariableDescriptor> variableDescriptors, boolean randomSelection) {
        this.leftEntitySelector = leftEntitySelector;
        this.rightEntitySelector = rightEntitySelector;
        this.variableDescriptors = variableDescriptors;
        this.randomSelection = randomSelection;
        PlanningEntityDescriptor leftEntityDescriptor = leftEntitySelector.getEntityDescriptor();
        PlanningEntityDescriptor rightEntityDescriptor = rightEntitySelector.getEntityDescriptor();
        if (!leftEntityDescriptor.getPlanningEntityClass().equals(rightEntityDescriptor.getPlanningEntityClass())) {
            throw new IllegalStateException("The selector (" + this + ") has a leftEntitySelector's planningEntityClass (" + leftEntityDescriptor.getPlanningEntityClass() + ") which is not equal to the rightEntitySelector's planningEntityClass (" + rightEntityDescriptor.getPlanningEntityClass() + ").");
        }
        boolean anyChained = false;
        for (PlanningVariableDescriptor variableDescriptor : variableDescriptors) {
            if (!leftEntityDescriptor.getPlanningEntityClass().equals(variableDescriptor.getPlanningEntityDescriptor().getPlanningEntityClass())) {
                throw new IllegalStateException("The selector (" + this + ") has a variableDescriptor with a planningEntityClass (" + variableDescriptor.getPlanningEntityDescriptor().getPlanningEntityClass() + ") which is not equal to the leftEntitySelector's planningEntityClass (" + leftEntityDescriptor.getPlanningEntityClass() + ").");
            }
            if (!variableDescriptor.isChained()) continue;
            anyChained = true;
        }
        this.anyChained = anyChained;
        this.solverPhaseLifecycleSupport.addEventListener(leftEntitySelector);
        if (leftEntitySelector != rightEntitySelector) {
            this.solverPhaseLifecycleSupport.addEventListener(rightEntitySelector);
        }
    }

    @Override
    public boolean isContinuous() {
        return this.leftEntitySelector.isContinuous() || this.rightEntitySelector.isContinuous();
    }

    @Override
    public boolean isNeverEnding() {
        return this.randomSelection || this.leftEntitySelector.isNeverEnding() || this.rightEntitySelector.isNeverEnding();
    }

    @Override
    public long getSize() {
        return AbstractOriginalSwapIterator.getSize(this.leftEntitySelector, this.rightEntitySelector);
    }

    @Override
    public Iterator<Move> iterator() {
        if (!this.randomSelection) {
            return new AbstractOriginalSwapIterator<Move, Object>((ListIterable)this.leftEntitySelector, (ListIterable)this.rightEntitySelector){

                @Override
                protected Move newSwapSelection(Object leftSubSelection, Object rightSubSelection) {
                    return SwapMoveSelector.this.anyChained ? new ChainedSwapMove(SwapMoveSelector.this.variableDescriptors, leftSubSelection, rightSubSelection) : new SwapMove(SwapMoveSelector.this.variableDescriptors, leftSubSelection, rightSubSelection);
                }
            };
        }
        return new AbstractRandomSwapIterator<Move, Object>((Iterable)this.leftEntitySelector, (Iterable)this.rightEntitySelector){

            @Override
            protected Move newSwapSelection(Object leftSubSelection, Object rightSubSelection) {
                return SwapMoveSelector.this.anyChained ? new ChainedSwapMove(SwapMoveSelector.this.variableDescriptors, leftSubSelection, rightSubSelection) : new SwapMove(SwapMoveSelector.this.variableDescriptors, leftSubSelection, rightSubSelection);
            }
        };
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.leftEntitySelector + ", " + this.rightEntitySelector + ")";
    }
}

