/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.heuristic.selector.value.decorator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.drools.planner.core.domain.variable.PlanningVariableDescriptor;
import org.drools.planner.core.heuristic.selector.common.SelectionCacheLifecycleBridge;
import org.drools.planner.core.heuristic.selector.common.SelectionCacheLifecycleListener;
import org.drools.planner.core.heuristic.selector.common.SelectionCacheType;
import org.drools.planner.core.heuristic.selector.value.AbstractValueSelector;
import org.drools.planner.core.heuristic.selector.value.ValueSelector;
import org.drools.planner.core.solver.scope.DefaultSolverScope;

public abstract class AbstractCachingValueSelector
extends AbstractValueSelector
implements SelectionCacheLifecycleListener {
    protected final ValueSelector childValueSelector;
    protected final SelectionCacheType cacheType;
    protected List<Object> cachedValueList = null;

    public AbstractCachingValueSelector(ValueSelector childValueSelector, SelectionCacheType cacheType) {
        this.childValueSelector = childValueSelector;
        this.cacheType = cacheType;
        if (childValueSelector.isNeverEnding()) {
            throw new IllegalStateException("The selector (" + this + ") has a childValueSelector (" + childValueSelector + ") with neverEnding (" + childValueSelector.isNeverEnding() + ").");
        }
        this.solverPhaseLifecycleSupport.addEventListener(childValueSelector);
        if (cacheType.isNotCached()) {
            throw new IllegalArgumentException("The selector (" + this + ") does not support the cacheType (" + (Object)((Object)cacheType) + ").");
        }
        this.solverPhaseLifecycleSupport.addEventListener(new SelectionCacheLifecycleBridge(cacheType, this));
    }

    public ValueSelector getChildValueSelector() {
        return this.childValueSelector;
    }

    @Override
    public void constructCache(DefaultSolverScope solverScope) {
        long childSize = this.childValueSelector.getSize();
        if (childSize > Integer.MAX_VALUE) {
            throw new IllegalStateException("The selector (" + this + ") has a childValueSelector (" + this.childValueSelector + ") with childSize (" + childSize + ") which is higher than Integer.MAX_VALUE.");
        }
        this.cachedValueList = new ArrayList<Object>((int)childSize);
        CollectionUtils.addAll(this.cachedValueList, (Iterator)this.childValueSelector.iterator());
        this.logger.trace("    Created cachedValueList with size ({}) in valueSelector({}).", (Object)this.cachedValueList.size(), (Object)this);
    }

    @Override
    public void disposeCache(DefaultSolverScope solverScope) {
        this.cachedValueList = null;
    }

    @Override
    public PlanningVariableDescriptor getVariableDescriptor() {
        return this.childValueSelector.getVariableDescriptor();
    }

    @Override
    public boolean isContinuous() {
        return false;
    }

    @Override
    public long getSize() {
        return this.cachedValueList.size();
    }
}

