/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.move;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.score.director.ScoreDirector;

public class CompositeMove
implements Move {
    protected List<Move> moveList;

    public CompositeMove(List<Move> moveList) {
        this.moveList = moveList;
    }

    public List<Move> getMoveList() {
        return this.moveList;
    }

    @Override
    public boolean isMoveDoable(ScoreDirector scoreDirector) {
        for (Move move : this.moveList) {
            if (move.isMoveDoable(scoreDirector)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Move createUndoMove(ScoreDirector scoreDirector) {
        ArrayList<Move> undoMoveList = new ArrayList<Move>(this.moveList.size());
        for (Move move : this.moveList) {
            Move undoMove = move.createUndoMove(scoreDirector);
            undoMoveList.add(undoMove);
        }
        Collections.reverse(undoMoveList);
        return new CompositeMove(undoMoveList);
    }

    @Override
    public void doMove(ScoreDirector scoreDirector) {
        for (Move move : this.moveList) {
            move.doMove(scoreDirector);
        }
    }

    @Override
    public Collection<? extends Object> getPlanningEntities() {
        LinkedHashSet<? extends Object> entities = new LinkedHashSet<Object>(this.moveList.size() * 2);
        for (Move move : this.moveList) {
            entities.addAll(move.getPlanningEntities());
        }
        return entities;
    }

    @Override
    public Collection<? extends Object> getPlanningValues() {
        LinkedHashSet<? extends Object> values = new LinkedHashSet<Object>(this.moveList.size() * 2);
        for (Move move : this.moveList) {
            values.addAll(move.getPlanningValues());
        }
        return values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof CompositeMove) {
            CompositeMove other = (CompositeMove)o;
            return ((Object)this.moveList).equals(other.moveList);
        }
        return false;
    }

    public int hashCode() {
        return ((Object)this.moveList).hashCode();
    }

    public String toString() {
        return this.moveList.toString();
    }
}

