/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.score.buildin.simpledouble;

import org.drools.planner.core.score.Score;
import org.drools.planner.core.score.buildin.simpledouble.DefaultSimpleDoubleScore;
import org.drools.planner.core.score.buildin.simpledouble.SimpleDoubleScore;
import org.drools.planner.core.score.buildin.simpledouble.SimpleDoubleScoreHolder;
import org.drools.planner.core.score.definition.AbstractScoreDefinition;
import org.drools.planner.core.score.holder.ScoreHolder;

public class SimpleDoubleScoreDefinition
extends AbstractScoreDefinition<SimpleDoubleScore> {
    private SimpleDoubleScore perfectMaximumScore = new DefaultSimpleDoubleScore(0.0);
    private SimpleDoubleScore perfectMinimumScore = new DefaultSimpleDoubleScore(-1.7976931348623157E308);

    public void setPerfectMaximumScore(SimpleDoubleScore perfectMaximumScore) {
        this.perfectMaximumScore = perfectMaximumScore;
    }

    public void setPerfectMinimumScore(SimpleDoubleScore perfectMinimumScore) {
        this.perfectMinimumScore = perfectMinimumScore;
    }

    @Override
    public SimpleDoubleScore getPerfectMaximumScore() {
        return this.perfectMaximumScore;
    }

    @Override
    public SimpleDoubleScore getPerfectMinimumScore() {
        return this.perfectMinimumScore;
    }

    @Override
    public Score parseScore(String scoreString) {
        return DefaultSimpleDoubleScore.parseScore(scoreString);
    }

    @Override
    public double calculateTimeGradient(SimpleDoubleScore startScore, SimpleDoubleScore endScore, SimpleDoubleScore score) {
        if (score.getScore() >= endScore.getScore()) {
            return 1.0;
        }
        if (startScore.getScore() >= score.getScore()) {
            return 0.0;
        }
        double scoreTotal = endScore.getScore() - startScore.getScore();
        double scoreDelta = score.getScore() - startScore.getScore();
        return scoreDelta / scoreTotal;
    }

    @Override
    public ScoreHolder buildScoreHolder() {
        return new SimpleDoubleScoreHolder();
    }
}

