/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.config.localsearch.decider.acceptor;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.drools.planner.config.EnvironmentMode;
import org.drools.planner.config.util.ConfigUtils;
import org.drools.planner.core.localsearch.decider.acceptor.Acceptor;
import org.drools.planner.core.localsearch.decider.acceptor.CompositeAcceptor;
import org.drools.planner.core.localsearch.decider.acceptor.greatdeluge.GreatDelugeAcceptor;
import org.drools.planner.core.localsearch.decider.acceptor.lateacceptance.LateAcceptanceAcceptor;
import org.drools.planner.core.localsearch.decider.acceptor.simulatedannealing.SimulatedAnnealingAcceptor;
import org.drools.planner.core.localsearch.decider.acceptor.tabu.MoveTabuAcceptor;
import org.drools.planner.core.localsearch.decider.acceptor.tabu.PlanningEntityTabuAcceptor;
import org.drools.planner.core.localsearch.decider.acceptor.tabu.PlanningValueTabuAcceptor;
import org.drools.planner.core.localsearch.decider.acceptor.tabu.SolutionTabuAcceptor;
import org.drools.planner.core.score.definition.ScoreDefinition;

@XStreamAlias(value="acceptor")
public class AcceptorConfig {
    @XStreamImplicit(itemFieldName="acceptorClass")
    private List<Class<? extends Acceptor>> acceptorClassList = null;
    @XStreamImplicit(itemFieldName="acceptorType")
    private List<AcceptorType> acceptorTypeList = null;
    protected Integer planningEntityTabuSize = null;
    protected Integer fadingPlanningEntityTabuSize = null;
    protected Integer planningValueTabuSize = null;
    protected Integer fadingPlanningValueTabuSize = null;
    protected Integer moveTabuSize = null;
    protected Integer fadingMoveTabuSize = null;
    protected Integer undoMoveTabuSize = null;
    protected Integer fadingUndoMoveTabuSize = null;
    protected Integer solutionTabuSize = null;
    protected Integer fadingSolutionTabuSize = null;
    protected String simulatedAnnealingStartingTemperature = null;
    protected Double greatDelugeWaterLevelUpperBoundRate = null;
    protected Double greatDelugeWaterRisingRate = null;
    protected Integer lateAcceptanceSize = null;

    public List<Class<? extends Acceptor>> getAcceptorClassList() {
        return this.acceptorClassList;
    }

    public void setAcceptorClassList(List<Class<? extends Acceptor>> acceptorClassList) {
        this.acceptorClassList = acceptorClassList;
    }

    public List<AcceptorType> getAcceptorTypeList() {
        return this.acceptorTypeList;
    }

    public void setAcceptorTypeList(List<AcceptorType> acceptorTypeList) {
        this.acceptorTypeList = acceptorTypeList;
    }

    public Integer getPlanningEntityTabuSize() {
        return this.planningEntityTabuSize;
    }

    public void setPlanningEntityTabuSize(Integer planningEntityTabuSize) {
        this.planningEntityTabuSize = planningEntityTabuSize;
    }

    public Integer getFadingPlanningEntityTabuSize() {
        return this.fadingPlanningEntityTabuSize;
    }

    public void setFadingPlanningEntityTabuSize(Integer fadingPlanningEntityTabuSize) {
        this.fadingPlanningEntityTabuSize = fadingPlanningEntityTabuSize;
    }

    public Integer getPlanningValueTabuSize() {
        return this.planningValueTabuSize;
    }

    public void setPlanningValueTabuSize(Integer planningValueTabuSize) {
        this.planningValueTabuSize = planningValueTabuSize;
    }

    public Integer getFadingPlanningValueTabuSize() {
        return this.fadingPlanningValueTabuSize;
    }

    public void setFadingPlanningValueTabuSize(Integer fadingPlanningValueTabuSize) {
        this.fadingPlanningValueTabuSize = fadingPlanningValueTabuSize;
    }

    public Integer getMoveTabuSize() {
        return this.moveTabuSize;
    }

    public void setMoveTabuSize(Integer moveTabuSize) {
        this.moveTabuSize = moveTabuSize;
    }

    public Integer getFadingMoveTabuSize() {
        return this.fadingMoveTabuSize;
    }

    public void setFadingMoveTabuSize(Integer fadingMoveTabuSize) {
        this.fadingMoveTabuSize = fadingMoveTabuSize;
    }

    public Integer getUndoMoveTabuSize() {
        return this.undoMoveTabuSize;
    }

    public void setUndoMoveTabuSize(Integer undoMoveTabuSize) {
        this.undoMoveTabuSize = undoMoveTabuSize;
    }

    public Integer getFadingUndoMoveTabuSize() {
        return this.fadingUndoMoveTabuSize;
    }

    public void setFadingUndoMoveTabuSize(Integer fadingUndoMoveTabuSize) {
        this.fadingUndoMoveTabuSize = fadingUndoMoveTabuSize;
    }

    public Integer getSolutionTabuSize() {
        return this.solutionTabuSize;
    }

    public void setSolutionTabuSize(Integer solutionTabuSize) {
        this.solutionTabuSize = solutionTabuSize;
    }

    public Integer getFadingSolutionTabuSize() {
        return this.fadingSolutionTabuSize;
    }

    public void setFadingSolutionTabuSize(Integer fadingSolutionTabuSize) {
        this.fadingSolutionTabuSize = fadingSolutionTabuSize;
    }

    public String getSimulatedAnnealingStartingTemperature() {
        return this.simulatedAnnealingStartingTemperature;
    }

    public void setSimulatedAnnealingStartingTemperature(String simulatedAnnealingStartingTemperature) {
        this.simulatedAnnealingStartingTemperature = simulatedAnnealingStartingTemperature;
    }

    public Double getGreatDelugeWaterLevelUpperBoundRate() {
        return this.greatDelugeWaterLevelUpperBoundRate;
    }

    public void setGreatDelugeWaterLevelUpperBoundRate(Double greatDelugeWaterLevelUpperBoundRate) {
        this.greatDelugeWaterLevelUpperBoundRate = greatDelugeWaterLevelUpperBoundRate;
    }

    public Double getGreatDelugeWaterRisingRate() {
        return this.greatDelugeWaterRisingRate;
    }

    public void setGreatDelugeWaterRisingRate(Double greatDelugeWaterRisingRate) {
        this.greatDelugeWaterRisingRate = greatDelugeWaterRisingRate;
    }

    public Integer getLateAcceptanceSize() {
        return this.lateAcceptanceSize;
    }

    public void setLateAcceptanceSize(Integer lateAcceptanceSize) {
        this.lateAcceptanceSize = lateAcceptanceSize;
    }

    public Acceptor buildAcceptor(EnvironmentMode environmentMode, ScoreDefinition scoreDefinition) {
        ArrayList<Acceptor> acceptorList = new ArrayList<Acceptor>();
        if (this.acceptorClassList != null) {
            for (Class<? extends Acceptor> acceptorClass : this.acceptorClassList) {
                Acceptor acceptor = ConfigUtils.newInstance(this, "acceptorClass", acceptorClass);
                acceptorList.add(acceptor);
            }
        }
        if (this.acceptorTypeList != null && this.acceptorTypeList.contains((Object)AcceptorType.PLANNING_ENTITY_TABU) || this.planningEntityTabuSize != null || this.fadingPlanningEntityTabuSize != null) {
            PlanningEntityTabuAcceptor planningEntityTabuAcceptor = new PlanningEntityTabuAcceptor();
            if (this.planningEntityTabuSize != null) {
                planningEntityTabuAcceptor.setTabuSize(this.planningEntityTabuSize);
            }
            if (this.fadingPlanningEntityTabuSize != null) {
                planningEntityTabuAcceptor.setFadingTabuSize(this.fadingPlanningEntityTabuSize);
            }
            if (environmentMode == EnvironmentMode.TRACE) {
                planningEntityTabuAcceptor.setAssertTabuHashCodeCorrectness(true);
            }
            acceptorList.add(planningEntityTabuAcceptor);
        }
        if (this.acceptorTypeList != null && this.acceptorTypeList.contains((Object)AcceptorType.PLANNING_VALUE_TABU) || this.planningValueTabuSize != null || this.fadingPlanningValueTabuSize != null) {
            PlanningValueTabuAcceptor planningValueTabuAcceptor = new PlanningValueTabuAcceptor();
            if (this.planningValueTabuSize != null) {
                planningValueTabuAcceptor.setTabuSize(this.planningValueTabuSize);
            }
            if (this.fadingPlanningValueTabuSize != null) {
                planningValueTabuAcceptor.setFadingTabuSize(this.fadingPlanningValueTabuSize);
            }
            if (environmentMode == EnvironmentMode.TRACE) {
                planningValueTabuAcceptor.setAssertTabuHashCodeCorrectness(true);
            }
            acceptorList.add(planningValueTabuAcceptor);
        }
        if (this.acceptorTypeList != null && this.acceptorTypeList.contains((Object)AcceptorType.MOVE_TABU) || this.moveTabuSize != null || this.fadingMoveTabuSize != null) {
            MoveTabuAcceptor moveTabuAcceptor = new MoveTabuAcceptor();
            moveTabuAcceptor.setUseUndoMoveAsTabuMove(false);
            if (this.moveTabuSize != null) {
                moveTabuAcceptor.setTabuSize(this.moveTabuSize);
            }
            if (this.fadingMoveTabuSize != null) {
                moveTabuAcceptor.setFadingTabuSize(this.fadingMoveTabuSize);
            }
            if (environmentMode == EnvironmentMode.TRACE) {
                moveTabuAcceptor.setAssertTabuHashCodeCorrectness(true);
            }
            acceptorList.add(moveTabuAcceptor);
        }
        if (this.acceptorTypeList != null && this.acceptorTypeList.contains((Object)AcceptorType.UNDO_MOVE_TABU) || this.undoMoveTabuSize != null || this.fadingUndoMoveTabuSize != null) {
            MoveTabuAcceptor undoMoveTabuAcceptor = new MoveTabuAcceptor();
            undoMoveTabuAcceptor.setUseUndoMoveAsTabuMove(true);
            if (this.undoMoveTabuSize != null) {
                undoMoveTabuAcceptor.setTabuSize(this.undoMoveTabuSize);
            }
            if (this.fadingUndoMoveTabuSize != null) {
                undoMoveTabuAcceptor.setFadingTabuSize(this.fadingUndoMoveTabuSize);
            }
            if (environmentMode == EnvironmentMode.TRACE) {
                undoMoveTabuAcceptor.setAssertTabuHashCodeCorrectness(true);
            }
            acceptorList.add(undoMoveTabuAcceptor);
        }
        if (this.acceptorTypeList != null && this.acceptorTypeList.contains((Object)AcceptorType.SOLUTION_TABU) || this.solutionTabuSize != null || this.fadingSolutionTabuSize != null) {
            SolutionTabuAcceptor solutionTabuAcceptor = new SolutionTabuAcceptor();
            if (this.solutionTabuSize != null) {
                solutionTabuAcceptor.setTabuSize(this.solutionTabuSize);
            }
            if (this.fadingSolutionTabuSize != null) {
                solutionTabuAcceptor.setFadingTabuSize(this.fadingSolutionTabuSize);
            }
            if (environmentMode == EnvironmentMode.TRACE) {
                solutionTabuAcceptor.setAssertTabuHashCodeCorrectness(true);
            }
            acceptorList.add(solutionTabuAcceptor);
        }
        if (this.acceptorTypeList != null && this.acceptorTypeList.contains((Object)AcceptorType.SIMULATED_ANNEALING) || this.simulatedAnnealingStartingTemperature != null) {
            SimulatedAnnealingAcceptor simulatedAnnealingAcceptor = new SimulatedAnnealingAcceptor();
            simulatedAnnealingAcceptor.setStartingTemperature(scoreDefinition.parseScore(this.simulatedAnnealingStartingTemperature));
            acceptorList.add(simulatedAnnealingAcceptor);
        }
        if (this.acceptorTypeList != null && this.acceptorTypeList.contains((Object)AcceptorType.GREAT_DELUGE) || this.greatDelugeWaterLevelUpperBoundRate != null || this.greatDelugeWaterRisingRate != null) {
            double waterLevelUpperBoundRate = (Double)ObjectUtils.defaultIfNull((Object)this.greatDelugeWaterLevelUpperBoundRate, (Object)1.2);
            double waterRisingRate = (Double)ObjectUtils.defaultIfNull((Object)this.greatDelugeWaterRisingRate, (Object)1.0E-7);
            acceptorList.add(new GreatDelugeAcceptor(waterLevelUpperBoundRate, waterRisingRate));
        }
        if (this.acceptorTypeList != null && this.acceptorTypeList.contains((Object)AcceptorType.LATE_ACCEPTANCE) || this.lateAcceptanceSize != null) {
            LateAcceptanceAcceptor lateAcceptanceAcceptor = new LateAcceptanceAcceptor();
            lateAcceptanceAcceptor.setLateAcceptanceSize(this.lateAcceptanceSize == null ? 1000 : this.lateAcceptanceSize);
            acceptorList.add(lateAcceptanceAcceptor);
        }
        if (acceptorList.size() == 1) {
            return (Acceptor)acceptorList.get(0);
        }
        if (acceptorList.size() > 1) {
            CompositeAcceptor compositeAcceptor = new CompositeAcceptor();
            compositeAcceptor.setAcceptorList(acceptorList);
            return compositeAcceptor;
        }
        PlanningEntityTabuAcceptor planningEntityTabuAcceptor = new PlanningEntityTabuAcceptor();
        planningEntityTabuAcceptor.setTabuSize(5);
        if (environmentMode == EnvironmentMode.TRACE) {
            planningEntityTabuAcceptor.setAssertTabuHashCodeCorrectness(true);
        }
        return planningEntityTabuAcceptor;
    }

    public void inherit(AcceptorConfig inheritedConfig) {
        this.acceptorClassList = ConfigUtils.inheritMergeableListProperty(this.acceptorClassList, inheritedConfig.getAcceptorClassList());
        if (this.acceptorTypeList == null) {
            this.acceptorTypeList = inheritedConfig.getAcceptorTypeList();
        } else {
            List<AcceptorType> inheritedAcceptorTypeList = inheritedConfig.getAcceptorTypeList();
            if (inheritedAcceptorTypeList != null) {
                for (AcceptorType acceptorType : inheritedAcceptorTypeList) {
                    if (this.acceptorTypeList.contains((Object)acceptorType)) continue;
                    this.acceptorTypeList.add(acceptorType);
                }
            }
        }
        if (this.planningEntityTabuSize == null) {
            this.planningEntityTabuSize = inheritedConfig.getPlanningEntityTabuSize();
        }
        if (this.fadingPlanningEntityTabuSize == null) {
            this.fadingPlanningEntityTabuSize = inheritedConfig.getFadingPlanningEntityTabuSize();
        }
        if (this.planningValueTabuSize == null) {
            this.planningValueTabuSize = inheritedConfig.getPlanningValueTabuSize();
        }
        if (this.fadingPlanningValueTabuSize == null) {
            this.fadingPlanningValueTabuSize = inheritedConfig.getFadingPlanningValueTabuSize();
        }
        if (this.moveTabuSize == null) {
            this.moveTabuSize = inheritedConfig.getMoveTabuSize();
        }
        if (this.fadingMoveTabuSize == null) {
            this.fadingMoveTabuSize = inheritedConfig.getFadingMoveTabuSize();
        }
        if (this.undoMoveTabuSize == null) {
            this.undoMoveTabuSize = inheritedConfig.getUndoMoveTabuSize();
        }
        if (this.fadingUndoMoveTabuSize == null) {
            this.fadingUndoMoveTabuSize = inheritedConfig.getFadingUndoMoveTabuSize();
        }
        if (this.solutionTabuSize == null) {
            this.solutionTabuSize = inheritedConfig.getSolutionTabuSize();
        }
        if (this.fadingSolutionTabuSize == null) {
            this.fadingSolutionTabuSize = inheritedConfig.getFadingSolutionTabuSize();
        }
        if (this.simulatedAnnealingStartingTemperature == null) {
            this.simulatedAnnealingStartingTemperature = inheritedConfig.getSimulatedAnnealingStartingTemperature();
        }
        if (this.greatDelugeWaterLevelUpperBoundRate == null) {
            this.greatDelugeWaterLevelUpperBoundRate = inheritedConfig.getGreatDelugeWaterLevelUpperBoundRate();
        }
        if (this.greatDelugeWaterRisingRate == null) {
            this.greatDelugeWaterRisingRate = inheritedConfig.getGreatDelugeWaterRisingRate();
        }
        if (this.lateAcceptanceSize == null) {
            this.lateAcceptanceSize = inheritedConfig.getLateAcceptanceSize();
        }
    }

    public static enum AcceptorType {
        PLANNING_ENTITY_TABU,
        PLANNING_VALUE_TABU,
        MOVE_TABU,
        UNDO_MOVE_TABU,
        SOLUTION_TABU,
        SIMULATED_ANNEALING,
        GREAT_DELUGE,
        LATE_ACCEPTANCE;

    }
}

