/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.config.phase;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamInclude;
import org.drools.planner.config.EnvironmentMode;
import org.drools.planner.config.bruteforce.BruteForceSolverPhaseConfig;
import org.drools.planner.config.constructionheuristic.ConstructionHeuristicSolverPhaseConfig;
import org.drools.planner.config.localsearch.LocalSearchSolverPhaseConfig;
import org.drools.planner.config.phase.custom.CustomSolverPhaseConfig;
import org.drools.planner.config.termination.TerminationConfig;
import org.drools.planner.core.domain.solution.SolutionDescriptor;
import org.drools.planner.core.phase.AbstractSolverPhase;
import org.drools.planner.core.phase.SolverPhase;
import org.drools.planner.core.score.definition.ScoreDefinition;
import org.drools.planner.core.termination.PhaseToSolverTerminationBridge;
import org.drools.planner.core.termination.Termination;

@XStreamInclude(value={CustomSolverPhaseConfig.class, BruteForceSolverPhaseConfig.class, ConstructionHeuristicSolverPhaseConfig.class, LocalSearchSolverPhaseConfig.class})
public abstract class SolverPhaseConfig {
    @XStreamAlias(value="termination")
    private TerminationConfig terminationConfig = new TerminationConfig();

    public TerminationConfig getTerminationConfig() {
        return this.terminationConfig;
    }

    public void setTerminationConfig(TerminationConfig terminationConfig) {
        this.terminationConfig = terminationConfig;
    }

    public abstract SolverPhase buildSolverPhase(EnvironmentMode var1, SolutionDescriptor var2, ScoreDefinition var3, Termination var4);

    protected void configureSolverPhase(AbstractSolverPhase solverPhase, EnvironmentMode environmentMode, ScoreDefinition scoreDefinition, Termination solverTermination) {
        solverPhase.setTermination(this.terminationConfig.buildTermination(scoreDefinition, new PhaseToSolverTerminationBridge(solverTermination)));
    }

    public void inherit(SolverPhaseConfig inheritedConfig) {
        if (this.terminationConfig == null) {
            this.terminationConfig = inheritedConfig.getTerminationConfig();
        } else if (inheritedConfig.getTerminationConfig() != null) {
            this.terminationConfig.inherit(inheritedConfig.getTerminationConfig());
        }
    }
}

