/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.config.phase.custom;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.drools.planner.config.EnvironmentMode;
import org.drools.planner.config.phase.SolverPhaseConfig;
import org.drools.planner.config.util.ConfigUtils;
import org.drools.planner.core.domain.solution.SolutionDescriptor;
import org.drools.planner.core.phase.custom.CustomSolverPhase;
import org.drools.planner.core.phase.custom.CustomSolverPhaseCommand;
import org.drools.planner.core.phase.custom.DefaultCustomSolverPhase;
import org.drools.planner.core.score.definition.ScoreDefinition;
import org.drools.planner.core.termination.Termination;

@XStreamAlias(value="customSolverPhase")
public class CustomSolverPhaseConfig
extends SolverPhaseConfig {
    @XStreamImplicit(itemFieldName="customSolverPhaseCommandClass")
    protected List<Class<CustomSolverPhaseCommand>> customSolverPhaseCommandClassList = null;
    protected Boolean forceUpdateBestSolution = null;

    public List<Class<CustomSolverPhaseCommand>> getCustomSolverPhaseCommandClassList() {
        return this.customSolverPhaseCommandClassList;
    }

    public void setCustomSolverPhaseCommandClassList(List<Class<CustomSolverPhaseCommand>> customSolverPhaseCommandClassList) {
        this.customSolverPhaseCommandClassList = customSolverPhaseCommandClassList;
    }

    public Boolean getForceUpdateBestSolution() {
        return this.forceUpdateBestSolution;
    }

    public void setForceUpdateBestSolution(Boolean forceUpdateBestSolution) {
        this.forceUpdateBestSolution = forceUpdateBestSolution;
    }

    @Override
    public CustomSolverPhase buildSolverPhase(EnvironmentMode environmentMode, SolutionDescriptor solutionDescriptor, ScoreDefinition scoreDefinition, Termination solverTermination) {
        DefaultCustomSolverPhase customSolverPhase = new DefaultCustomSolverPhase();
        this.configureSolverPhase(customSolverPhase, environmentMode, scoreDefinition, solverTermination);
        if (CollectionUtils.isEmpty(this.customSolverPhaseCommandClassList)) {
            throw new IllegalArgumentException("Configure at least 1 <customSolverPhaseCommandClass> in the <customSolverPhase> configuration.");
        }
        ArrayList<CustomSolverPhaseCommand> customSolverPhaseCommandList = new ArrayList<CustomSolverPhaseCommand>(this.customSolverPhaseCommandClassList.size());
        for (Class<CustomSolverPhaseCommand> customSolverPhaseCommandClass : this.customSolverPhaseCommandClassList) {
            CustomSolverPhaseCommand customSolverPhaseCommand = ConfigUtils.newInstance(this, "customSolverPhaseCommandClass", customSolverPhaseCommandClass);
            customSolverPhaseCommandList.add(customSolverPhaseCommand);
        }
        customSolverPhase.setCustomSolverPhaseCommandList(customSolverPhaseCommandList);
        customSolverPhase.setForceUpdateBestSolution(this.forceUpdateBestSolution == null ? false : this.forceUpdateBestSolution);
        return customSolverPhase;
    }

    public void inherit(CustomSolverPhaseConfig inheritedConfig) {
        super.inherit(inheritedConfig);
        this.customSolverPhaseCommandClassList = ConfigUtils.inheritMergeableListProperty(this.customSolverPhaseCommandClassList, inheritedConfig.getCustomSolverPhaseCommandClassList());
        this.forceUpdateBestSolution = ConfigUtils.inheritOverwritableProperty(this.forceUpdateBestSolution, inheritedConfig.getForceUpdateBestSolution());
    }
}

