/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.constructionheuristic;

import java.util.List;
import org.drools.planner.core.constructionheuristic.ConstructionHeuristicSolverPhase;
import org.drools.planner.core.constructionheuristic.placer.entity.EntityPlacer;
import org.drools.planner.core.constructionheuristic.scope.ConstructionHeuristicSolverPhaseScope;
import org.drools.planner.core.constructionheuristic.scope.ConstructionHeuristicStepScope;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.phase.AbstractSolverPhase;
import org.drools.planner.core.solver.scope.DefaultSolverScope;

public class DefaultConstructionHeuristicSolverPhase
extends AbstractSolverPhase
implements ConstructionHeuristicSolverPhase {
    protected List<EntityPlacer> entityPlacerList;
    protected boolean assertStepScoreIsUncorrupted = false;

    public void setEntityPlacerList(List<EntityPlacer> entityPlacerList) {
        this.entityPlacerList = entityPlacerList;
    }

    public void setAssertStepScoreIsUncorrupted(boolean assertStepScoreIsUncorrupted) {
        this.assertStepScoreIsUncorrupted = assertStepScoreIsUncorrupted;
    }

    @Override
    public void solve(DefaultSolverScope solverScope) {
        ConstructionHeuristicSolverPhaseScope phaseScope = new ConstructionHeuristicSolverPhaseScope(solverScope);
        this.phaseStarted(phaseScope);
        if (this.entityPlacerList.size() != 1) {
            throw new UnsupportedOperationException();
        }
        EntityPlacer hackEntityPlacer = this.entityPlacerList.get(0);
        ConstructionHeuristicStepScope stepScope = this.createNextStepScope(phaseScope, null);
        while (!this.termination.isPhaseTerminated(phaseScope) && hackEntityPlacer.hasPlacement()) {
            this.stepStarted(stepScope);
            hackEntityPlacer.doPlacement(stepScope);
            Move nextStep = stepScope.getStep();
            if (nextStep == null) {
                this.logger.warn("    Cancelled step index ({}), time spend ({}): there is no doable move. Terminating phase early.", (Object)stepScope.getStepIndex(), (Object)phaseScope.calculateSolverTimeMillisSpend());
                break;
            }
            nextStep.doMove(stepScope.getScoreDirector());
            phaseScope.getWorkingSolution().setScore(stepScope.getScore());
            if (this.assertStepScoreIsUncorrupted) {
                phaseScope.assertWorkingScoreFromScratch(stepScope.getScore());
                phaseScope.assertExpectedWorkingScore(stepScope.getScore());
            }
            if (!hackEntityPlacer.hasPlacement()) {
                stepScope.setSolutionInitialized(true);
            }
            this.stepEnded(stepScope);
            stepScope = this.createNextStepScope(phaseScope, stepScope);
        }
        this.phaseEnded(phaseScope);
    }

    private ConstructionHeuristicStepScope createNextStepScope(ConstructionHeuristicSolverPhaseScope phaseScope, ConstructionHeuristicStepScope completedStepScope) {
        if (completedStepScope == null) {
            completedStepScope = new ConstructionHeuristicStepScope(phaseScope);
            completedStepScope.setScore(phaseScope.getStartingScore());
            completedStepScope.setStepIndex(-1);
        }
        phaseScope.setLastCompletedStepScope(completedStepScope);
        ConstructionHeuristicStepScope stepScope = new ConstructionHeuristicStepScope(phaseScope);
        stepScope.setStepIndex(completedStepScope.getStepIndex() + 1);
        stepScope.setSolutionInitialized(false);
        return stepScope;
    }

    @Override
    public void solvingStarted(DefaultSolverScope solverScope) {
        super.solvingStarted(solverScope);
        for (EntityPlacer entityPlacer : this.entityPlacerList) {
            entityPlacer.solvingStarted(solverScope);
        }
    }

    public void phaseStarted(ConstructionHeuristicSolverPhaseScope phaseScope) {
        super.phaseStarted(phaseScope);
        for (EntityPlacer entityPlacer : this.entityPlacerList) {
            entityPlacer.phaseStarted(phaseScope);
        }
    }

    public void stepStarted(ConstructionHeuristicStepScope stepScope) {
        super.stepStarted(stepScope);
        for (EntityPlacer entityPlacer : this.entityPlacerList) {
            entityPlacer.stepStarted(stepScope);
        }
    }

    public void stepEnded(ConstructionHeuristicStepScope stepScope) {
        super.stepEnded(stepScope);
        for (EntityPlacer entityPlacer : this.entityPlacerList) {
            entityPlacer.stepEnded(stepScope);
        }
        if (this.logger.isDebugEnabled()) {
            long timeMillisSpend = stepScope.getPhaseScope().calculateSolverTimeMillisSpend();
            this.logger.debug("    Step index ({}), time spend ({}), score ({}) for constructing step ({}).", new Object[]{stepScope.getStepIndex(), timeMillisSpend, stepScope.getScore(), stepScope.getStep()});
        }
    }

    public void phaseEnded(ConstructionHeuristicSolverPhaseScope phaseScope) {
        super.phaseEnded(phaseScope);
        for (EntityPlacer entityPlacer : this.entityPlacerList) {
            entityPlacer.phaseEnded(phaseScope);
        }
        this.logger.info("Phase constructionHeuristic ended: step total ({}), time spend ({}), best score ({}).", new Object[]{phaseScope.getLastCompletedStepScope().getStepIndex() + 1, phaseScope.calculateSolverTimeMillisSpend(), phaseScope.getBestScore()});
    }

    @Override
    public void solvingEnded(DefaultSolverScope solverScope) {
        super.solvingStarted(solverScope);
        for (EntityPlacer entityPlacer : this.entityPlacerList) {
            entityPlacer.solvingEnded(solverScope);
        }
    }
}

