/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.heuristic.selector.entity.pillar;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import org.drools.planner.core.domain.entity.PlanningEntityDescriptor;
import org.drools.planner.core.domain.variable.PlanningVariableDescriptor;
import org.drools.planner.core.heuristic.selector.AbstractSelector;
import org.drools.planner.core.heuristic.selector.common.SelectionCacheLifecycleBridge;
import org.drools.planner.core.heuristic.selector.common.SelectionCacheLifecycleListener;
import org.drools.planner.core.heuristic.selector.common.SelectionCacheType;
import org.drools.planner.core.heuristic.selector.common.iterator.CachedListRandomIterator;
import org.drools.planner.core.heuristic.selector.entity.EntitySelector;
import org.drools.planner.core.heuristic.selector.entity.pillar.PillarSelector;
import org.drools.planner.core.solver.scope.DefaultSolverScope;

public class SameValuePillarSelector
extends AbstractSelector
implements PillarSelector,
SelectionCacheLifecycleListener {
    protected final EntitySelector entitySelector;
    protected final Collection<PlanningVariableDescriptor> variableDescriptors;
    protected final boolean randomSelection;
    protected List<List<Object>> cachedPillarList = null;

    public SameValuePillarSelector(EntitySelector entitySelector, Collection<PlanningVariableDescriptor> variableDescriptors, boolean randomSelection) {
        this.entitySelector = entitySelector;
        this.variableDescriptors = variableDescriptors;
        this.randomSelection = randomSelection;
        Class<?> entityClass = entitySelector.getEntityDescriptor().getPlanningEntityClass();
        for (PlanningVariableDescriptor variableDescriptor : variableDescriptors) {
            if (!entityClass.equals(variableDescriptor.getPlanningEntityDescriptor().getPlanningEntityClass())) {
                throw new IllegalStateException("The selector (" + this + ") has a variableDescriptor (" + variableDescriptor + ") with a planningEntityClass (" + variableDescriptor.getPlanningEntityDescriptor().getPlanningEntityClass() + ") which is not equal to the entitySelector's planningEntityClass (" + entityClass + ").");
            }
            if (!variableDescriptor.isChained()) continue;
            throw new IllegalStateException("The selector (" + this + ") has a variableDescriptor (" + variableDescriptor + ") which is chained (" + variableDescriptor.isChained() + ").");
        }
        for (PlanningVariableDescriptor variableDescriptor : variableDescriptors) {
            if (!variableDescriptor.isChained()) continue;
            throw new IllegalStateException("The selector (" + this + ") cannot have a variableDescriptor (" + variableDescriptor + ") which is chained (" + variableDescriptor.isChained() + ").");
        }
        if (entitySelector.isNeverEnding()) {
            throw new IllegalStateException("The selector (" + this + ") has an entitySelector (" + entitySelector + ") with neverEnding (" + entitySelector.isNeverEnding() + ").");
        }
        this.solverPhaseLifecycleSupport.addEventListener(entitySelector);
        this.solverPhaseLifecycleSupport.addEventListener(new SelectionCacheLifecycleBridge(SelectionCacheType.STEP, this));
    }

    @Override
    public PlanningEntityDescriptor getEntityDescriptor() {
        return this.entitySelector.getEntityDescriptor();
    }

    @Override
    public void constructCache(DefaultSolverScope solverScope) {
        long entitySize = this.entitySelector.getSize();
        if (entitySize > Integer.MAX_VALUE) {
            throw new IllegalStateException("The subChainSelector (" + this + ") has an entitySelector (" + this.entitySelector + ") with entitySize (" + entitySize + ") which is higher than Integer.MAX_VALUE.");
        }
        LinkedHashMap valueStateToPillarMap = new LinkedHashMap((int)entitySize);
        for (Object entity : this.entitySelector) {
            ArrayList<Object> valueState = new ArrayList<Object>(this.variableDescriptors.size());
            for (PlanningVariableDescriptor variableDescriptor : this.variableDescriptors) {
                Object value = variableDescriptor.getValue(entity);
                valueState.add(value);
            }
            ArrayList pillar = (ArrayList)valueStateToPillarMap.get(valueState);
            if (pillar == null) {
                pillar = new ArrayList();
                valueStateToPillarMap.put(valueState, pillar);
            }
            pillar.add(entity);
        }
        this.cachedPillarList = new ArrayList(valueStateToPillarMap.values());
    }

    @Override
    public void disposeCache(DefaultSolverScope solverScope) {
        this.cachedPillarList = null;
    }

    @Override
    public boolean isContinuous() {
        return false;
    }

    @Override
    public boolean isNeverEnding() {
        return this.randomSelection;
    }

    @Override
    public long getSize() {
        return this.cachedPillarList.size();
    }

    @Override
    public Iterator<List<Object>> iterator() {
        if (!this.randomSelection) {
            return this.cachedPillarList.iterator();
        }
        return new CachedListRandomIterator<List<Object>>(this.cachedPillarList, this.workingRandom);
    }

    @Override
    public ListIterator<List<Object>> listIterator() {
        if (!this.randomSelection) {
            return this.cachedPillarList.listIterator();
        }
        throw new IllegalStateException("The selector (" + this + ") does not support a ListIterator with randomSelection (" + this.randomSelection + ").");
    }

    @Override
    public ListIterator<List<Object>> listIterator(int index) {
        if (!this.randomSelection) {
            return this.cachedPillarList.listIterator(index);
        }
        throw new IllegalStateException("The selector (" + this + ") does not support a ListIterator with randomSelection (" + this.randomSelection + ").");
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.entitySelector + ")";
    }
}

