/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.heuristic.selector.move.generic;

import java.util.Iterator;
import org.drools.planner.core.domain.variable.PlanningVariableDescriptor;
import org.drools.planner.core.heuristic.selector.common.iterator.UpcomingSelectionIterator;
import org.drools.planner.core.heuristic.selector.entity.EntitySelector;
import org.drools.planner.core.heuristic.selector.move.generic.ChangeMove;
import org.drools.planner.core.heuristic.selector.move.generic.GenericMoveSelector;
import org.drools.planner.core.heuristic.selector.move.generic.chained.ChainedChangeMove;
import org.drools.planner.core.heuristic.selector.value.ValueSelector;
import org.drools.planner.core.heuristic.selector.value.iterator.ValueIterator;
import org.drools.planner.core.move.Move;

public class ChangeMoveSelector
extends GenericMoveSelector {
    protected final EntitySelector entitySelector;
    protected final ValueSelector valueSelector;
    protected final boolean randomSelection;
    protected final boolean chained;

    public ChangeMoveSelector(EntitySelector entitySelector, ValueSelector valueSelector, boolean randomSelection) {
        this.entitySelector = entitySelector;
        this.valueSelector = valueSelector;
        this.randomSelection = randomSelection;
        PlanningVariableDescriptor variableDescriptor = valueSelector.getVariableDescriptor();
        this.chained = variableDescriptor.isChained();
        this.solverPhaseLifecycleSupport.addEventListener(entitySelector);
        this.solverPhaseLifecycleSupport.addEventListener(valueSelector);
    }

    @Override
    public boolean isContinuous() {
        return this.entitySelector.isContinuous() || this.valueSelector.isContinuous();
    }

    @Override
    public boolean isNeverEnding() {
        return this.randomSelection || this.entitySelector.isNeverEnding() || this.valueSelector.isNeverEnding();
    }

    @Override
    public long getSize() {
        return this.entitySelector.getSize() * this.valueSelector.getSize();
    }

    @Override
    public Iterator<Move> iterator() {
        if (!this.randomSelection) {
            return new OriginalChangeMoveIterator();
        }
        return new RandomChangeMoveIterator();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.entitySelector + ", " + this.valueSelector + ")";
    }

    private class RandomChangeMoveIterator
    extends UpcomingSelectionIterator<Move> {
        private Iterator<Object> entityIterator;
        private ValueIterator valueIterator;

        private RandomChangeMoveIterator() {
            this.entityIterator = ChangeMoveSelector.this.entitySelector.iterator();
            this.valueIterator = ChangeMoveSelector.this.valueSelector.iterator();
            if (!this.entityIterator.hasNext() || !this.valueIterator.hasNext()) {
                this.upcomingSelection = null;
            } else {
                this.createUpcomingSelection();
            }
        }

        @Override
        protected void createUpcomingSelection() {
            if (!this.entityIterator.hasNext()) {
                this.entityIterator = ChangeMoveSelector.this.entitySelector.iterator();
            }
            Object entity = this.entityIterator.next();
            int entityIteratorCreationCount = 0;
            while (!this.valueIterator.hasNext(entity)) {
                this.valueIterator = ChangeMoveSelector.this.valueSelector.iterator();
                if (this.valueIterator.hasNext(entity)) continue;
                if (!this.entityIterator.hasNext()) {
                    this.entityIterator = ChangeMoveSelector.this.entitySelector.iterator();
                    if (++entityIteratorCreationCount >= 2) {
                        this.upcomingSelection = null;
                        return;
                    }
                }
                entity = this.entityIterator.next();
            }
            Object toValue = this.valueIterator.next(entity);
            this.upcomingSelection = ChangeMoveSelector.this.chained ? new ChainedChangeMove(entity, ChangeMoveSelector.this.valueSelector.getVariableDescriptor(), toValue) : new ChangeMove(entity, ChangeMoveSelector.this.valueSelector.getVariableDescriptor(), toValue);
        }
    }

    private class OriginalChangeMoveIterator
    extends UpcomingSelectionIterator<Move> {
        private Iterator<Object> entityIterator;
        private ValueIterator valueIterator;
        private Object upcomingEntity;

        private OriginalChangeMoveIterator() {
            this.entityIterator = ChangeMoveSelector.this.entitySelector.iterator();
            this.valueIterator = ChangeMoveSelector.this.valueSelector.iterator();
            if (!this.entityIterator.hasNext() || !this.valueIterator.hasNext()) {
                this.upcomingSelection = null;
            } else {
                this.upcomingEntity = this.entityIterator.next();
                this.createUpcomingSelection();
            }
        }

        @Override
        protected void createUpcomingSelection() {
            while (!this.valueIterator.hasNext(this.upcomingEntity)) {
                if (!this.entityIterator.hasNext()) {
                    this.upcomingSelection = null;
                    return;
                }
                this.upcomingEntity = this.entityIterator.next();
                this.valueIterator = ChangeMoveSelector.this.valueSelector.iterator();
            }
            Object toValue = this.valueIterator.next(this.upcomingEntity);
            this.upcomingSelection = ChangeMoveSelector.this.chained ? new ChainedChangeMove(this.upcomingEntity, ChangeMoveSelector.this.valueSelector.getVariableDescriptor(), toValue) : new ChangeMove(this.upcomingEntity, ChangeMoveSelector.this.valueSelector.getVariableDescriptor(), toValue);
        }
    }
}

