/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.score.buildin.hardandsoftlong;

import org.drools.planner.core.score.Score;
import org.drools.planner.core.score.buildin.hardandsoftlong.DefaultHardAndSoftLongScore;
import org.drools.planner.core.score.buildin.hardandsoftlong.HardAndSoftLongScore;
import org.drools.planner.core.score.buildin.hardandsoftlong.HardAndSoftLongScoreHolder;
import org.drools.planner.core.score.definition.AbstractScoreDefinition;
import org.drools.planner.core.score.holder.ScoreHolder;

public class HardAndSoftLongScoreDefinition
extends AbstractScoreDefinition<HardAndSoftLongScore> {
    private double hardScoreTimeGradientWeight = 0.75;
    private HardAndSoftLongScore perfectMaximumScore = new DefaultHardAndSoftLongScore(0L, 0L);
    private HardAndSoftLongScore perfectMinimumScore = new DefaultHardAndSoftLongScore(Long.MIN_VALUE, Long.MIN_VALUE);

    public void setHardScoreTimeGradientWeight(double hardScoreTimeGradientWeight) {
        this.hardScoreTimeGradientWeight = hardScoreTimeGradientWeight;
        if (hardScoreTimeGradientWeight < 0.0 || hardScoreTimeGradientWeight > 1.0) {
            throw new IllegalArgumentException("Property hardScoreTimeGradientWeight (" + hardScoreTimeGradientWeight + ") must be greater or equal to 0.0 and smaller or equal to 1.0.");
        }
    }

    public void setPerfectMaximumScore(HardAndSoftLongScore perfectMaximumScore) {
        this.perfectMaximumScore = perfectMaximumScore;
    }

    public void setPerfectMinimumScore(HardAndSoftLongScore perfectMinimumScore) {
        this.perfectMinimumScore = perfectMinimumScore;
    }

    @Override
    public HardAndSoftLongScore getPerfectMaximumScore() {
        return this.perfectMaximumScore;
    }

    @Override
    public HardAndSoftLongScore getPerfectMinimumScore() {
        return this.perfectMinimumScore;
    }

    @Override
    public Score parseScore(String scoreString) {
        return DefaultHardAndSoftLongScore.parseScore(scoreString);
    }

    @Override
    public double calculateTimeGradient(HardAndSoftLongScore startScore, HardAndSoftLongScore endScore, HardAndSoftLongScore score) {
        double timeGradient;
        double softScoreTimeGradientWeight;
        if (score.getHardScore() > endScore.getHardScore()) {
            return 1.0;
        }
        if (startScore.getHardScore() > score.getHardScore()) {
            return 0.0;
        }
        if (startScore.getHardScore() == endScore.getHardScore()) {
            softScoreTimeGradientWeight = 1.0;
            timeGradient = 0.0;
        } else {
            softScoreTimeGradientWeight = 1.0 - this.hardScoreTimeGradientWeight;
            long hardScoreTotal = endScore.getHardScore() - startScore.getHardScore();
            long hardScoreDelta = score.getHardScore() - startScore.getHardScore();
            double hardTimeGradient = (double)hardScoreDelta / (double)hardScoreTotal;
            timeGradient = hardTimeGradient * this.hardScoreTimeGradientWeight;
        }
        if (score.getSoftScore() >= endScore.getSoftScore()) {
            timeGradient += softScoreTimeGradientWeight;
        } else if (startScore.getSoftScore() < score.getSoftScore()) {
            long softScoreTotal = endScore.getSoftScore() - startScore.getSoftScore();
            long softScoreDelta = score.getSoftScore() - startScore.getSoftScore();
            double softTimeGradient = (double)softScoreDelta / (double)softScoreTotal;
            timeGradient += softTimeGradient * softScoreTimeGradientWeight;
        }
        return timeGradient;
    }

    @Override
    public ScoreHolder buildScoreHolder() {
        return new HardAndSoftLongScoreHolder();
    }
}

