/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.score.buildin.simpledouble;

import org.drools.planner.core.score.AbstractScore;
import org.drools.planner.core.score.buildin.simpledouble.SimpleDoubleScore;

public final class DefaultSimpleDoubleScore
extends AbstractScore<SimpleDoubleScore>
implements SimpleDoubleScore {
    private final double score;

    public static DefaultSimpleDoubleScore parseScore(String scoreString) {
        return DefaultSimpleDoubleScore.valueOf(Double.parseDouble(scoreString));
    }

    public static DefaultSimpleDoubleScore valueOf(double score) {
        return new DefaultSimpleDoubleScore(score);
    }

    public DefaultSimpleDoubleScore(double score) {
        this.score = score;
    }

    @Override
    public double getScore() {
        return this.score;
    }

    @Override
    public SimpleDoubleScore add(SimpleDoubleScore augment) {
        return new DefaultSimpleDoubleScore(this.score + augment.getScore());
    }

    @Override
    public SimpleDoubleScore subtract(SimpleDoubleScore subtrahend) {
        return new DefaultSimpleDoubleScore(this.score - subtrahend.getScore());
    }

    @Override
    public SimpleDoubleScore multiply(double multiplicand) {
        return new DefaultSimpleDoubleScore(Math.floor(this.score * multiplicand));
    }

    @Override
    public SimpleDoubleScore divide(double divisor) {
        return new DefaultSimpleDoubleScore(Math.floor(this.score / divisor));
    }

    @Override
    public double[] toDoubleLevels() {
        return new double[]{this.score};
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SimpleDoubleScore) {
            SimpleDoubleScore other = (SimpleDoubleScore)o;
            return this.score == other.getScore();
        }
        return false;
    }

    public int hashCode() {
        return 629 + Double.valueOf(this.score).hashCode();
    }

    @Override
    public int compareTo(SimpleDoubleScore other) {
        if (this.score < other.getScore()) {
            return -1;
        }
        if (this.score > other.getScore()) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return Double.toString(this.score);
    }
}

