/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.score.director;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.planner.core.domain.solution.SolutionDescriptor;
import org.drools.planner.core.domain.variable.PlanningVariableDescriptor;
import org.drools.planner.core.score.Score;
import org.drools.planner.core.score.definition.ScoreDefinition;
import org.drools.planner.core.score.director.AbstractScoreDirectorFactory;
import org.drools.planner.core.score.director.ScoreDirector;
import org.drools.planner.core.score.director.ScoreDirectorFactory;
import org.drools.planner.core.solution.Solution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractScoreDirector<F extends AbstractScoreDirectorFactory>
implements ScoreDirector {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final F scoreDirectorFactory;
    protected Solution workingSolution;
    protected boolean hasChainedVariables;
    protected Map<PlanningVariableDescriptor, Map<Object, List<Object>>> chainedVariableToTrailingEntitiesMap;
    protected long calculateCount = 0L;

    protected AbstractScoreDirector(F scoreDirectorFactory) {
        this.scoreDirectorFactory = scoreDirectorFactory;
        Collection<PlanningVariableDescriptor> chainedVariableDescriptors = this.getSolutionDescriptor().getChainedVariableDescriptors();
        this.hasChainedVariables = !chainedVariableDescriptors.isEmpty();
        this.chainedVariableToTrailingEntitiesMap = new HashMap<PlanningVariableDescriptor, Map<Object, List<Object>>>(chainedVariableDescriptors.size());
        for (PlanningVariableDescriptor chainedVariableDescriptor : chainedVariableDescriptors) {
            this.chainedVariableToTrailingEntitiesMap.put(chainedVariableDescriptor, null);
        }
    }

    public F getScoreDirectorFactory() {
        return this.scoreDirectorFactory;
    }

    @Override
    public SolutionDescriptor getSolutionDescriptor() {
        return ((AbstractScoreDirectorFactory)this.scoreDirectorFactory).getSolutionDescriptor();
    }

    @Override
    public ScoreDefinition getScoreDefinition() {
        return ((AbstractScoreDirectorFactory)this.scoreDirectorFactory).getScoreDefinition();
    }

    @Override
    public Solution getWorkingSolution() {
        return this.workingSolution;
    }

    @Override
    public long getCalculateCount() {
        return this.calculateCount;
    }

    @Override
    public void setWorkingSolution(Solution workingSolution) {
        this.workingSolution = workingSolution;
        this.resetTrailingEntityMap();
    }

    @Override
    public Solution cloneWorkingSolution() {
        return this.getSolutionDescriptor().getSolutionCloner().cloneSolution(this.workingSolution);
    }

    private void resetTrailingEntityMap() {
        if (this.hasChainedVariables) {
            List<Object> entityList = this.getSolutionDescriptor().getPlanningEntityList(this.workingSolution);
            for (Map.Entry<PlanningVariableDescriptor, Map<Object, List<Object>>> entry : this.chainedVariableToTrailingEntitiesMap.entrySet()) {
                entry.setValue(new HashMap(entityList.size()));
            }
            for (Object entity : entityList) {
                this.insertInTrailingEntityMap(entity);
            }
        }
    }

    private void insertInTrailingEntityMap(Object entity) {
        if (this.hasChainedVariables) {
            for (Map.Entry<PlanningVariableDescriptor, Map<Object, List<Object>>> entry : this.chainedVariableToTrailingEntitiesMap.entrySet()) {
                PlanningVariableDescriptor variableDescriptor = entry.getKey();
                if (!variableDescriptor.getPlanningEntityDescriptor().appliesToPlanningEntity(entity)) continue;
                Object value = variableDescriptor.getValue(entity);
                Map<Object, List<Object>> valueToTrailingEntityMap = entry.getValue();
                List<Object> trailingEntities = valueToTrailingEntityMap.get(value);
                if (trailingEntities == null) {
                    trailingEntities = new ArrayList<Object>();
                    valueToTrailingEntityMap.put(value, trailingEntities);
                }
                trailingEntities.add(entity);
            }
        }
    }

    private void retractFromTrailingEntityMap(Object entity) {
        if (this.hasChainedVariables) {
            for (Map.Entry<PlanningVariableDescriptor, Map<Object, List<Object>>> entry : this.chainedVariableToTrailingEntitiesMap.entrySet()) {
                PlanningVariableDescriptor variableDescriptor = entry.getKey();
                if (!variableDescriptor.getPlanningEntityDescriptor().appliesToPlanningEntity(entity)) continue;
                Object value = variableDescriptor.getValue(entity);
                Map<Object, List<Object>> valueToTrailingEntityMap = entry.getValue();
                List<Object> trailingEntities = valueToTrailingEntityMap.get(value);
                boolean removeSucceeded = trailingEntities.remove(entity);
                if (!removeSucceeded) {
                    throw new IllegalStateException("The ScoreDirector (" + this.getClass() + ") is corrupted.");
                }
                if (!trailingEntities.isEmpty()) continue;
                valueToTrailingEntityMap.put(value, null);
            }
        }
    }

    @Override
    public void beforeEntityAdded(Object entity) {
    }

    @Override
    public void afterEntityAdded(Object entity) {
        this.insertInTrailingEntityMap(entity);
    }

    @Override
    public void beforeAllVariablesChanged(Object entity) {
        this.retractFromTrailingEntityMap(entity);
    }

    @Override
    public void afterAllVariablesChanged(Object entity) {
        this.insertInTrailingEntityMap(entity);
    }

    @Override
    public void beforeVariableChanged(Object entity, String variableName) {
        this.retractFromTrailingEntityMap(entity);
    }

    @Override
    public void afterVariableChanged(Object entity, String variableName) {
        this.insertInTrailingEntityMap(entity);
    }

    @Override
    public void beforeEntityRemoved(Object entity) {
        this.retractFromTrailingEntityMap(entity);
    }

    @Override
    public void afterEntityRemoved(Object entity) {
    }

    @Override
    public void beforeProblemFactAdded(Object problemFact) {
    }

    @Override
    public void afterProblemFactAdded(Object problemFact) {
        this.resetTrailingEntityMap();
    }

    @Override
    public void beforeProblemFactChanged(Object problemFact) {
    }

    @Override
    public void afterProblemFactChanged(Object problemFact) {
        this.resetTrailingEntityMap();
    }

    @Override
    public void beforeProblemFactRemoved(Object problemFact) {
    }

    @Override
    public void afterProblemFactRemoved(Object problemFact) {
        this.resetTrailingEntityMap();
    }

    @Override
    public List<Object> getWorkingPlanningEntityList() {
        return this.getSolutionDescriptor().getPlanningEntityList(this.workingSolution);
    }

    @Override
    public boolean isWorkingSolutionInitialized() {
        return this.getSolutionDescriptor().isInitialized(this.workingSolution);
    }

    protected void setCalculatedScore(Score score) {
        this.workingSolution.setScore(score);
        ++this.calculateCount;
    }

    @Override
    public AbstractScoreDirector clone() {
        AbstractScoreDirector clone = (AbstractScoreDirector)this.scoreDirectorFactory.buildScoreDirector();
        clone.setWorkingSolution(this.cloneWorkingSolution());
        return clone;
    }

    @Override
    public Object getTrailingEntity(PlanningVariableDescriptor chainedVariableDescriptor, Object planningValue) {
        List<Object> trailingEntities = this.chainedVariableToTrailingEntitiesMap.get(chainedVariableDescriptor).get(planningValue);
        if (trailingEntities == null) {
            return null;
        }
        if (trailingEntities.size() > 1) {
            throw new IllegalStateException("The planningValue (" + planningValue + ") has multiple trailing entities (" + trailingEntities + ") pointing to it for chained planningVariable (" + chainedVariableDescriptor.getVariableName() + ").");
        }
        return trailingEntities.get(0);
    }

    @Override
    public void assertExpectedWorkingScore(Score expectedWorkingScore) {
        Score workingScore = this.calculateScore();
        if (!expectedWorkingScore.equals(workingScore)) {
            throw new IllegalStateException("Score corruption: the expectedWorkingScore (" + expectedWorkingScore + ") is not the workingScore (" + workingScore + ")");
        }
    }

    @Override
    public void assertWorkingScoreFromScratch(Score workingScore) {
        ScoreDirectorFactory assertionScoreDirectorFactory = ((AbstractScoreDirectorFactory)this.scoreDirectorFactory).getAssertionScoreDirectorFactory();
        if (assertionScoreDirectorFactory == null) {
            assertionScoreDirectorFactory = this.scoreDirectorFactory;
        }
        ScoreDirector uncorruptedScoreDirector = assertionScoreDirectorFactory.buildScoreDirector();
        uncorruptedScoreDirector.setWorkingSolution(this.workingSolution);
        Score uncorruptedScore = uncorruptedScoreDirector.calculateScore();
        if (!workingScore.equals(uncorruptedScore)) {
            String scoreCorruptionAnalysis = this.buildScoreCorruptionAnalysis(uncorruptedScoreDirector);
            uncorruptedScoreDirector.dispose();
            throw new IllegalStateException("Score corruption: the workingScore (" + workingScore + ") is not the uncorruptedScore (" + uncorruptedScore + ")" + (scoreCorruptionAnalysis == null ? "." : ":\n" + scoreCorruptionAnalysis));
        }
        uncorruptedScoreDirector.dispose();
    }

    protected String buildScoreCorruptionAnalysis(ScoreDirector uncorruptedScoreDirector) {
        return null;
    }

    @Override
    public void dispose() {
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.calculateCount + ")";
    }
}

