/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.domain.solution.cloner;

import java.util.Arrays;
import java.util.List;
import org.drools.planner.core.domain.solution.SolutionDescriptor;
import org.drools.planner.core.domain.solution.cloner.FieldAccessingSolutionCloner;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.core.testdata.domain.TestdataEntity;
import org.drools.planner.core.testdata.domain.TestdataSolution;
import org.drools.planner.core.testdata.domain.TestdataValue;
import org.drools.planner.core.testdata.domain.chained.TestdataChainedAnchor;
import org.drools.planner.core.testdata.domain.chained.TestdataChainedEntity;
import org.drools.planner.core.testdata.domain.chained.TestdataChainedObject;
import org.drools.planner.core.testdata.domain.chained.TestdataChainedSolution;
import org.drools.planner.core.testdata.util.PlannerAssert;
import org.junit.Test;

public class FieldAccessingSolutionClonerTest {
    @Test
    public void testCloneSolution() {
        SolutionDescriptor solutionDescriptor = TestdataSolution.buildSolutionDescriptor();
        FieldAccessingSolutionCloner cloner = new FieldAccessingSolutionCloner(solutionDescriptor);
        TestdataValue val1 = new TestdataValue("1");
        TestdataValue val2 = new TestdataValue("2");
        TestdataValue val3 = new TestdataValue("3");
        TestdataEntity a = new TestdataEntity("a", val1);
        TestdataEntity b = new TestdataEntity("b", val1);
        TestdataEntity c = new TestdataEntity("c", val3);
        TestdataEntity d = new TestdataEntity("d", val3);
        TestdataSolution original = new TestdataSolution("solution");
        List<TestdataValue> valueList = Arrays.asList(val1, val2, val3);
        original.setValueList(valueList);
        List<TestdataEntity> originalEntityList = Arrays.asList(a, b, c, d);
        original.setEntityList(originalEntityList);
        TestdataSolution clone = (TestdataSolution)cloner.cloneSolution((Solution)original);
        PlannerAssert.assertNotSame((Object)original, (Object)clone);
        PlannerAssert.assertSame(valueList, clone.getValueList());
        List<TestdataEntity> cloneEntityList = clone.getEntityList();
        PlannerAssert.assertNotSame(originalEntityList, cloneEntityList);
        PlannerAssert.assertCode("solution", clone);
        PlannerAssert.assertEquals((long)4L, (long)cloneEntityList.size());
        TestdataEntity cloneA = cloneEntityList.get(0);
        TestdataEntity cloneB = cloneEntityList.get(1);
        TestdataEntity cloneC = cloneEntityList.get(2);
        TestdataEntity cloneD = cloneEntityList.get(3);
        this.assertEntityClone(a, cloneA, "a", "1");
        this.assertEntityClone(b, cloneB, "b", "1");
        this.assertEntityClone(c, cloneC, "c", "3");
        this.assertEntityClone(d, cloneD, "d", "3");
        b.setValue(val2);
        PlannerAssert.assertCode("2", b.getValue());
        PlannerAssert.assertCode("1", cloneB.getValue());
    }

    private void assertEntityClone(TestdataEntity originalEntity, TestdataEntity cloneEntity, String entityCode, String valueCode) {
        PlannerAssert.assertNotSame((Object)originalEntity, (Object)cloneEntity);
        PlannerAssert.assertCode(entityCode, originalEntity);
        PlannerAssert.assertCode(entityCode, cloneEntity);
        PlannerAssert.assertCode(valueCode, cloneEntity.getValue());
    }

    @Test
    public void testCloneChainedSolution() {
        SolutionDescriptor solutionDescriptor = TestdataChainedSolution.buildSolutionDescriptor();
        FieldAccessingSolutionCloner cloner = new FieldAccessingSolutionCloner(solutionDescriptor);
        TestdataChainedAnchor a0 = new TestdataChainedAnchor("a0");
        TestdataChainedEntity a1 = new TestdataChainedEntity("a1", a0);
        TestdataChainedEntity a2 = new TestdataChainedEntity("a2", a1);
        TestdataChainedEntity a3 = new TestdataChainedEntity("a3", a2);
        TestdataChainedAnchor b0 = new TestdataChainedAnchor("b0");
        TestdataChainedEntity b1 = new TestdataChainedEntity("b1", b0);
        TestdataChainedSolution original = new TestdataChainedSolution("solution");
        List<TestdataChainedAnchor> anchorList = Arrays.asList(a0, b0);
        original.setChainedAnchorList(anchorList);
        List<TestdataChainedEntity> originalEntityList = Arrays.asList(a1, a2, a3, b1);
        original.setChainedEntityList(originalEntityList);
        TestdataChainedSolution clone = (TestdataChainedSolution)cloner.cloneSolution((Solution)original);
        PlannerAssert.assertNotSame((Object)original, (Object)clone);
        PlannerAssert.assertCode("solution", clone);
        PlannerAssert.assertSame(anchorList, clone.getChainedAnchorList());
        List<TestdataChainedEntity> cloneEntityList = clone.getChainedEntityList();
        PlannerAssert.assertNotSame(originalEntityList, cloneEntityList);
        PlannerAssert.assertEquals((long)4L, (long)cloneEntityList.size());
        TestdataChainedEntity cloneA1 = cloneEntityList.get(0);
        TestdataChainedEntity cloneA2 = cloneEntityList.get(1);
        TestdataChainedEntity cloneA3 = cloneEntityList.get(2);
        TestdataChainedEntity cloneB1 = cloneEntityList.get(3);
        this.assertChainedEntityClone(a1, cloneA1, "a1", a0);
        this.assertChainedEntityClone(a2, cloneA2, "a2", cloneA1);
        this.assertChainedEntityClone(a3, cloneA3, "a3", cloneA2);
        this.assertChainedEntityClone(b1, cloneB1, "b1", b0);
        a3.setChainedObject(b1);
        PlannerAssert.assertCode("b1", a3.getChainedObject());
        PlannerAssert.assertCode("a2", cloneA3.getChainedObject());
    }

    private void assertChainedEntityClone(TestdataChainedEntity originalEntity, TestdataChainedEntity cloneEntity, String entityCode, TestdataChainedObject value) {
        PlannerAssert.assertNotSame((Object)originalEntity, (Object)cloneEntity);
        PlannerAssert.assertCode(entityCode, originalEntity);
        PlannerAssert.assertCode(entityCode, cloneEntity);
        PlannerAssert.assertSame((Object)value, (Object)cloneEntity.getChainedObject());
    }
}

