/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.localsearch.decider.acceptor.greatdeluge;

import java.util.Random;
import org.drools.planner.core.localsearch.decider.acceptor.greatdeluge.GreatDelugeAcceptor;
import org.drools.planner.core.localsearch.scope.LocalSearchMoveScope;
import org.drools.planner.core.localsearch.scope.LocalSearchSolverPhaseScope;
import org.drools.planner.core.localsearch.scope.LocalSearchStepScope;
import org.drools.planner.core.move.DummyMove;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.score.Score;
import org.drools.planner.core.score.buildin.simple.SimpleScore;
import org.drools.planner.core.score.buildin.simple.SimpleScoreDefinition;
import org.drools.planner.core.score.definition.ScoreDefinition;
import org.drools.planner.core.score.director.ScoreDirector;
import org.drools.planner.core.score.director.drools.DroolsScoreDirectorFactory;
import org.drools.planner.core.solver.scope.DefaultSolverScope;
import org.drools.planner.core.testdata.domain.TestdataSolution;
import org.junit.Assert;
import org.junit.Test;

public class GreatDelugeAcceptorTest {
    @Test
    public void testIsAccepted() {
        GreatDelugeAcceptor acceptor = new GreatDelugeAcceptor(1.2, 0.01);
        LocalSearchSolverPhaseScope localSearchSolverPhaseScope = this.createLocalSearchSolverPhaseScope();
        acceptor.phaseStarted(localSearchSolverPhaseScope);
        LocalSearchStepScope localSearchStepScope = new LocalSearchStepScope(localSearchSolverPhaseScope);
        localSearchStepScope.setStepIndex(0);
        acceptor.stepStarted(localSearchStepScope);
        LocalSearchMoveScope a1 = this.createMoveScope(localSearchStepScope, (Score)SimpleScore.valueOf((int)-2000));
        LocalSearchMoveScope a2 = this.createMoveScope(localSearchStepScope, (Score)SimpleScore.valueOf((int)-1300));
        LocalSearchMoveScope a3 = this.createMoveScope(localSearchStepScope, (Score)SimpleScore.valueOf((int)-1200));
        LocalSearchMoveScope b1 = this.createMoveScope(localSearchStepScope, (Score)SimpleScore.valueOf((int)-1200));
        LocalSearchMoveScope b2 = this.createMoveScope(localSearchStepScope, (Score)SimpleScore.valueOf((int)-100));
        LocalSearchMoveScope c1 = this.createMoveScope(localSearchStepScope, (Score)SimpleScore.valueOf((int)-1100));
        LocalSearchMoveScope c2 = this.createMoveScope(localSearchStepScope, (Score)SimpleScore.valueOf((int)-120));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(a1));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(a2));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(a3));
    }

    private LocalSearchSolverPhaseScope createLocalSearchSolverPhaseScope() {
        DefaultSolverScope solverScope = new DefaultSolverScope();
        LocalSearchSolverPhaseScope phaseScope = new LocalSearchSolverPhaseScope(solverScope);
        DroolsScoreDirectorFactory scoreDirectorFactory = new DroolsScoreDirectorFactory();
        scoreDirectorFactory.setSolutionDescriptor(TestdataSolution.buildSolutionDescriptor());
        scoreDirectorFactory.setScoreDefinition((ScoreDefinition)new SimpleScoreDefinition());
        solverScope.setScoreDirector((ScoreDirector)scoreDirectorFactory.buildScoreDirector());
        solverScope.setWorkingRandom(new Random(){

            @Override
            public double nextDouble() {
                return 0.2;
            }
        });
        solverScope.setBestScore((Score)SimpleScore.valueOf((int)-1000));
        LocalSearchStepScope lastLocalSearchStepScope = new LocalSearchStepScope(phaseScope);
        lastLocalSearchStepScope.setScore((Score)SimpleScore.valueOf((int)-1000));
        phaseScope.setLastCompletedStepScope(lastLocalSearchStepScope);
        return phaseScope;
    }

    public LocalSearchMoveScope createMoveScope(LocalSearchStepScope localSearchStepScope, Score score) {
        LocalSearchMoveScope moveScope = new LocalSearchMoveScope(localSearchStepScope);
        moveScope.setMove((Move)new DummyMove());
        moveScope.setScore(score);
        return moveScope;
    }
}

