/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.score.director;

import java.util.Arrays;
import org.drools.planner.core.domain.entity.PlanningEntityDescriptor;
import org.drools.planner.core.domain.solution.SolutionDescriptor;
import org.drools.planner.core.domain.solution.cloner.FieldAccessingSolutionCloner;
import org.drools.planner.core.domain.variable.PlanningVariableDescriptor;
import org.drools.planner.core.score.Score;
import org.drools.planner.core.score.buildin.simple.SimpleScore;
import org.drools.planner.core.score.director.AbstractScoreDirector;
import org.drools.planner.core.score.director.AbstractScoreDirectorFactory;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.core.testdata.domain.TestdataObject;
import org.drools.planner.core.testdata.domain.chained.TestdataChainedAnchor;
import org.drools.planner.core.testdata.domain.chained.TestdataChainedEntity;
import org.drools.planner.core.testdata.domain.chained.TestdataChainedSolution;
import org.drools.planner.core.testdata.util.PlannerAssert;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class AbstractScoreDirectorTest {
    @Test
    public void getTrailingEntityMap() {
        TestdataChainedAnchor a0 = new TestdataChainedAnchor("a0");
        TestdataChainedEntity a1 = new TestdataChainedEntity("a1", a0);
        TestdataChainedEntity a2 = new TestdataChainedEntity("a2", a1);
        TestdataChainedEntity a3 = new TestdataChainedEntity("a3", a2);
        TestdataChainedAnchor b0 = new TestdataChainedAnchor("b0");
        TestdataChainedEntity b1 = new TestdataChainedEntity("b1", b0);
        TestdataChainedSolution solution = new TestdataChainedSolution("solution");
        solution.setChainedAnchorList(Arrays.asList(a0, b0));
        solution.setChainedEntityList(Arrays.asList(a1, a2, a3, b1));
        SolutionDescriptor solutionDescriptor = TestdataChainedSolution.buildSolutionDescriptor();
        PlanningEntityDescriptor entityDescriptor = solutionDescriptor.getPlanningEntityDescriptor(TestdataChainedEntity.class);
        PlanningVariableDescriptor variableDescriptor = entityDescriptor.getPlanningVariableDescriptor("chainedObject");
        AbstractScoreDirectorFactory scoreDirectorFactory = (AbstractScoreDirectorFactory)Mockito.mock(AbstractScoreDirectorFactory.class);
        Mockito.when((Object)scoreDirectorFactory.getSolutionDescriptor()).thenReturn((Object)solutionDescriptor);
        AbstractScoreDirector<AbstractScoreDirectorFactory> scoreDirector = new AbstractScoreDirector<AbstractScoreDirectorFactory>(scoreDirectorFactory){

            public Score calculateScore() {
                return SimpleScore.valueOf((int)-100);
            }
        };
        FieldAccessingSolutionCloner cloner = new FieldAccessingSolutionCloner(solutionDescriptor);
        TestdataChainedSolution clonedStartingSolution = (TestdataChainedSolution)cloner.cloneSolution((Solution)solution);
        scoreDirector.setWorkingSolution((Solution)solution);
        Assert.assertEquals((Object)a1, (Object)scoreDirector.getTrailingEntity(variableDescriptor, (Object)a0));
        Assert.assertEquals((Object)a2, (Object)scoreDirector.getTrailingEntity(variableDescriptor, (Object)a1));
        Assert.assertEquals((Object)a3, (Object)scoreDirector.getTrailingEntity(variableDescriptor, (Object)a2));
        Assert.assertEquals((Object)b1, (Object)scoreDirector.getTrailingEntity(variableDescriptor, (Object)b0));
        scoreDirector.beforeVariableChanged((Object)a3, "chainedObject");
        a3.setChainedObject(b1);
        scoreDirector.afterVariableChanged((Object)a3, "chainedObject");
        Assert.assertEquals((Object)a1, (Object)scoreDirector.getTrailingEntity(variableDescriptor, (Object)a0));
        Assert.assertEquals((Object)a2, (Object)scoreDirector.getTrailingEntity(variableDescriptor, (Object)a1));
        Assert.assertEquals((Object)b1, (Object)scoreDirector.getTrailingEntity(variableDescriptor, (Object)b0));
        Assert.assertEquals((Object)a3, (Object)scoreDirector.getTrailingEntity(variableDescriptor, (Object)b1));
        scoreDirector.setWorkingSolution((Solution)clonedStartingSolution);
        TestdataChainedEntity a1Clone = clonedStartingSolution.getChainedEntityList().get(0);
        PlannerAssert.assertCode("a1", a1Clone);
        TestdataChainedEntity a2Clone = clonedStartingSolution.getChainedEntityList().get(1);
        PlannerAssert.assertCode("a2", a2Clone);
        Assert.assertEquals((Object)"a1", (Object)((TestdataObject)scoreDirector.getTrailingEntity(variableDescriptor, (Object)a0)).getCode());
        Assert.assertEquals((Object)"a2", (Object)((TestdataObject)scoreDirector.getTrailingEntity(variableDescriptor, (Object)a1Clone)).getCode());
        Assert.assertEquals((Object)"a3", (Object)((TestdataObject)scoreDirector.getTrailingEntity(variableDescriptor, (Object)a2Clone)).getCode());
        Assert.assertEquals((Object)"b1", (Object)((TestdataObject)scoreDirector.getTrailingEntity(variableDescriptor, (Object)b0)).getCode());
    }
}

