/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.config;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.reflection.FieldDictionary;
import com.thoughtworks.xstream.converters.reflection.FieldKeySorter;
import com.thoughtworks.xstream.converters.reflection.NativeFieldKeySorter;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.apache.commons.io.IOUtils;
import org.drools.planner.config.SolverFactory;
import org.drools.planner.config.solver.SolverConfig;
import org.drools.planner.core.Solver;

public class XmlSolverFactory
implements SolverFactory {
    private XStream xStream = XmlSolverFactory.buildXstream();
    private SolverConfig solverConfig = null;

    public static XStream buildXstream() {
        XStream xStream = new XStream((ReflectionProvider)new PureJavaReflectionProvider(new FieldDictionary((FieldKeySorter)new NativeFieldKeySorter())));
        xStream.setMode(1002);
        xStream.processAnnotations(SolverConfig.class);
        return xStream;
    }

    public XmlSolverFactory() {
    }

    public XmlSolverFactory(String resource) {
        this();
        this.configure(resource);
    }

    public void addXstreamAnnotations(Class ... xstreamAnnotations) {
        this.xStream.processAnnotations(xstreamAnnotations);
    }

    public XmlSolverFactory configure(String resource) {
        InputStream in = this.getClass().getResourceAsStream(resource);
        if (in == null) {
            throw new IllegalArgumentException("The solver configuration (" + resource + ") does not exist.");
        }
        return this.configure(in);
    }

    public XmlSolverFactory configure(InputStream in) {
        XmlSolverFactory xmlSolverFactory;
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(in, "UTF-8");
            xmlSolverFactory = this.configure(reader);
        }
        catch (UnsupportedEncodingException e) {
            try {
                throw new IllegalStateException("This vm does not support UTF-8 encoding.", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                IOUtils.closeQuietly((InputStream)in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        IOUtils.closeQuietly((InputStream)in);
        return xmlSolverFactory;
    }

    public XmlSolverFactory configure(Reader reader) {
        this.solverConfig = (SolverConfig)this.xStream.fromXML(reader);
        return this;
    }

    @Override
    public SolverConfig getSolverConfig() {
        if (this.solverConfig == null) {
            throw new IllegalStateException("The solverConfig (" + this.solverConfig + ") is null," + " call configure(...) first.");
        }
        return this.solverConfig;
    }

    @Override
    public Solver buildSolver() {
        if (this.solverConfig == null) {
            throw new IllegalStateException("The solverConfig (" + this.solverConfig + ") is null," + " call configure(...) first.");
        }
        return this.solverConfig.buildSolver();
    }
}

