/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.config.constructionheuristic;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.drools.planner.config.EnvironmentMode;
import org.drools.planner.config.constructionheuristic.placer.entity.EntityPlacerConfig;
import org.drools.planner.config.phase.SolverPhaseConfig;
import org.drools.planner.config.util.ConfigUtils;
import org.drools.planner.core.constructionheuristic.DefaultConstructionHeuristicSolverPhase;
import org.drools.planner.core.constructionheuristic.greedyFit.DefaultGreedyFitSolverPhase;
import org.drools.planner.core.constructionheuristic.greedyFit.decider.ConstructionHeuristicPickEarlyType;
import org.drools.planner.core.constructionheuristic.greedyFit.decider.DefaultGreedyDecider;
import org.drools.planner.core.constructionheuristic.greedyFit.decider.GreedyDecider;
import org.drools.planner.core.constructionheuristic.greedyFit.decider.forager.GreedyForager;
import org.drools.planner.core.constructionheuristic.greedyFit.selector.GreedyPlanningEntitySelector;
import org.drools.planner.core.constructionheuristic.placer.entity.EntityPlacer;
import org.drools.planner.core.domain.entity.PlanningEntityDescriptor;
import org.drools.planner.core.domain.solution.SolutionDescriptor;
import org.drools.planner.core.domain.variable.PlanningVariableDescriptor;
import org.drools.planner.core.heuristic.selector.entity.PlanningEntitySelectionOrder;
import org.drools.planner.core.heuristic.selector.entity.PlanningEntitySelector;
import org.drools.planner.core.heuristic.selector.variable.PlanningValueSelectionOrder;
import org.drools.planner.core.heuristic.selector.variable.PlanningValueSelector;
import org.drools.planner.core.heuristic.selector.variable.PlanningValueWalker;
import org.drools.planner.core.heuristic.selector.variable.PlanningVariableWalker;
import org.drools.planner.core.phase.SolverPhase;
import org.drools.planner.core.score.definition.ScoreDefinition;
import org.drools.planner.core.termination.Termination;

@XStreamAlias(value="constructionHeuristic")
public class ConstructionHeuristicSolverPhaseConfig
extends SolverPhaseConfig {
    protected ConstructionHeuristicType constructionHeuristicType = null;
    protected ConstructionHeuristicPickEarlyType constructionHeuristicPickEarlyType = null;
    @XStreamImplicit
    protected List<EntityPlacerConfig> entityPlacerConfigList = null;

    public ConstructionHeuristicType getConstructionHeuristicType() {
        return this.constructionHeuristicType;
    }

    public void setConstructionHeuristicType(ConstructionHeuristicType constructionHeuristicType) {
        this.constructionHeuristicType = constructionHeuristicType;
    }

    public ConstructionHeuristicPickEarlyType getConstructionHeuristicPickEarlyType() {
        return this.constructionHeuristicPickEarlyType;
    }

    public void setConstructionHeuristicPickEarlyType(ConstructionHeuristicPickEarlyType constructionHeuristicPickEarlyType) {
        this.constructionHeuristicPickEarlyType = constructionHeuristicPickEarlyType;
    }

    public List<EntityPlacerConfig> getEntityPlacerConfigList() {
        return this.entityPlacerConfigList;
    }

    public void setEntityPlacerConfigList(List<EntityPlacerConfig> entityPlacerConfigList) {
        this.entityPlacerConfigList = entityPlacerConfigList;
    }

    @Override
    public SolverPhase buildSolverPhase(int phaseIndex, EnvironmentMode environmentMode, SolutionDescriptor solutionDescriptor, ScoreDefinition scoreDefinition, Termination solverTermination) {
        if (this.constructionHeuristicType != null) {
            DefaultGreedyFitSolverPhase greedySolverPhase = new DefaultGreedyFitSolverPhase();
            this.configureSolverPhase(greedySolverPhase, phaseIndex, environmentMode, scoreDefinition, solverTermination);
            greedySolverPhase.setGreedyPlanningEntitySelector(this.buildGreedyPlanningEntitySelector(solutionDescriptor));
            greedySolverPhase.setGreedyDecider(this.buildGreedyDecider(solutionDescriptor, environmentMode));
            if (environmentMode == EnvironmentMode.FAST_ASSERT || environmentMode == EnvironmentMode.FULL_ASSERT) {
                greedySolverPhase.setAssertStepScoreIsUncorrupted(true);
            }
            return greedySolverPhase;
        }
        if (!CollectionUtils.isEmpty(this.entityPlacerConfigList)) {
            if (this.constructionHeuristicPickEarlyType != null) {
                throw new UnsupportedOperationException();
            }
            DefaultConstructionHeuristicSolverPhase phase = new DefaultConstructionHeuristicSolverPhase();
            this.configureSolverPhase(phase, phaseIndex, environmentMode, scoreDefinition, solverTermination);
            ArrayList<EntityPlacer> entityPlacerList = new ArrayList<EntityPlacer>(this.entityPlacerConfigList.size());
            for (EntityPlacerConfig entityPlacerConfig : this.entityPlacerConfigList) {
                EntityPlacer entityPlacer = entityPlacerConfig.buildEntityPlacer(environmentMode, solutionDescriptor, phase.getTermination());
                entityPlacerList.add(entityPlacer);
            }
            phase.setEntityPlacerList(entityPlacerList);
            if (environmentMode == EnvironmentMode.FAST_ASSERT || environmentMode == EnvironmentMode.FULL_ASSERT) {
                phase.setAssertStepScoreIsUncorrupted(true);
            }
            return phase;
        }
        throw new IllegalArgumentException("A constructionHeuristic requires configuration, for example a constructionHeuristicType.");
    }

    @Deprecated
    private GreedyPlanningEntitySelector buildGreedyPlanningEntitySelector(SolutionDescriptor solutionDescriptor) {
        GreedyPlanningEntitySelector greedyPlanningEntitySelector = new GreedyPlanningEntitySelector();
        Set<Class<?>> planningEntityClassSet = solutionDescriptor.getPlanningEntityClassSet();
        if (planningEntityClassSet.size() != 1) {
            throw new UnsupportedOperationException("Currently the greedyFit implementation only supports 1 planningEntityClass.");
        }
        Class<?> planningEntityClass = planningEntityClassSet.iterator().next();
        ArrayList<PlanningEntitySelector> planningEntitySelectorList = new ArrayList<PlanningEntitySelector>(1);
        PlanningEntitySelector planningEntitySelector = new PlanningEntitySelector(solutionDescriptor.getPlanningEntityDescriptor(planningEntityClass));
        planningEntitySelector.setSelectionOrder(this.determinePlanningEntitySelectionOrder());
        planningEntitySelectorList.add(planningEntitySelector);
        greedyPlanningEntitySelector.setPlanningEntitySelectorList(planningEntitySelectorList);
        return greedyPlanningEntitySelector;
    }

    @Deprecated
    private GreedyDecider buildGreedyDecider(SolutionDescriptor solutionDescriptor, EnvironmentMode environmentMode) {
        DefaultGreedyDecider greedyDecider = new DefaultGreedyDecider();
        Set<Class<?>> planningEntityClassSet = solutionDescriptor.getPlanningEntityClassSet();
        if (planningEntityClassSet.size() != 1) {
            throw new UnsupportedOperationException("Currently the greedyFit implementation only supports 1 planningEntityClass.");
        }
        Class<?> planningEntityClass = planningEntityClassSet.iterator().next();
        PlanningEntityDescriptor planningEntityDescriptor = solutionDescriptor.getPlanningEntityDescriptor(planningEntityClass);
        PlanningVariableWalker planningVariableWalker = new PlanningVariableWalker(planningEntityDescriptor);
        ArrayList<PlanningValueWalker> planningValueWalkerList = new ArrayList<PlanningValueWalker>();
        for (PlanningVariableDescriptor planningVariableDescriptor : planningEntityDescriptor.getPlanningVariableDescriptors()) {
            PlanningValueSelector planningValueSelector = new PlanningValueSelector(planningVariableDescriptor);
            planningValueSelector.setSelectionOrder(this.determinePlanningValueSelectionOrder());
            PlanningValueWalker planningValueWalker = new PlanningValueWalker(planningVariableDescriptor, planningValueSelector);
            planningValueWalkerList.add(planningValueWalker);
        }
        planningVariableWalker.setPlanningValueWalkerList(planningValueWalkerList);
        greedyDecider.setPlanningVariableWalker(planningVariableWalker);
        greedyDecider.setForager(this.buildGreedyForager());
        if (environmentMode == EnvironmentMode.FULL_ASSERT) {
            greedyDecider.setAssertMoveScoreIsUncorrupted(true);
        }
        if (environmentMode == EnvironmentMode.FAST_ASSERT || environmentMode == EnvironmentMode.FULL_ASSERT) {
            greedyDecider.setAssertUndoMoveIsUncorrupted(true);
        }
        return greedyDecider;
    }

    @Deprecated
    private GreedyForager buildGreedyForager() {
        GreedyForager forager = new GreedyForager();
        ConstructionHeuristicPickEarlyType pickEarlyType = this.constructionHeuristicPickEarlyType == null ? ConstructionHeuristicPickEarlyType.NEVER : this.constructionHeuristicPickEarlyType;
        forager.setPickEarlyType(pickEarlyType);
        return forager;
    }

    private PlanningEntitySelectionOrder determinePlanningEntitySelectionOrder() {
        switch (this.constructionHeuristicType) {
            case FIRST_FIT: 
            case BEST_FIT: {
                return PlanningEntitySelectionOrder.ORIGINAL;
            }
            case FIRST_FIT_DECREASING: 
            case BEST_FIT_DECREASING: {
                return PlanningEntitySelectionOrder.DECREASING_DIFFICULTY;
            }
        }
        throw new IllegalStateException("The constructionHeuristicType (" + (Object)((Object)this.constructionHeuristicType) + ") is not implemented.");
    }

    private PlanningValueSelectionOrder determinePlanningValueSelectionOrder() {
        switch (this.constructionHeuristicType) {
            case FIRST_FIT: 
            case FIRST_FIT_DECREASING: {
                return PlanningValueSelectionOrder.ORIGINAL;
            }
            case BEST_FIT: 
            case BEST_FIT_DECREASING: {
                return PlanningValueSelectionOrder.INCREASING_STRENGTH;
            }
        }
        throw new IllegalStateException("The constructionHeuristicType (" + (Object)((Object)this.constructionHeuristicType) + ") is not implemented.");
    }

    public void inherit(ConstructionHeuristicSolverPhaseConfig inheritedConfig) {
        super.inherit(inheritedConfig);
        if (this.constructionHeuristicType == null) {
            this.constructionHeuristicType = inheritedConfig.getConstructionHeuristicType();
        }
        if (this.constructionHeuristicPickEarlyType == null) {
            this.constructionHeuristicPickEarlyType = inheritedConfig.getConstructionHeuristicPickEarlyType();
        }
        this.entityPlacerConfigList = ConfigUtils.inheritMergeableListProperty(this.entityPlacerConfigList, inheritedConfig.getEntityPlacerConfigList());
    }

    public static enum ConstructionHeuristicType {
        FIRST_FIT,
        FIRST_FIT_DECREASING,
        BEST_FIT,
        BEST_FIT_DECREASING;

    }
}

