/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.config.constructionheuristic.placer.value;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.drools.planner.config.EnvironmentMode;
import org.drools.planner.config.constructionheuristic.placer.PlacerConfig;
import org.drools.planner.config.heuristic.selector.common.SelectionOrder;
import org.drools.planner.config.heuristic.selector.value.ValueSelectorConfig;
import org.drools.planner.config.util.ConfigUtils;
import org.drools.planner.core.constructionheuristic.placer.value.ValuePlacer;
import org.drools.planner.core.domain.entity.PlanningEntityDescriptor;
import org.drools.planner.core.domain.solution.SolutionDescriptor;
import org.drools.planner.core.heuristic.selector.common.SelectionCacheType;
import org.drools.planner.core.heuristic.selector.value.ValueSelector;
import org.drools.planner.core.termination.Termination;

@XStreamAlias(value="valuePlacer")
public class ValuePlacerConfig
extends PlacerConfig {
    @XStreamAlias(value="valueSelector")
    protected ValueSelectorConfig valueSelectorConfig = new ValueSelectorConfig();
    protected Integer selectedCountLimit = null;

    public ValueSelectorConfig getValueSelectorConfig() {
        return this.valueSelectorConfig;
    }

    public void setValueSelectorConfig(ValueSelectorConfig valueSelectorConfig) {
        this.valueSelectorConfig = valueSelectorConfig;
    }

    public Integer getSelectedCountLimit() {
        return this.selectedCountLimit;
    }

    public void setSelectedCountLimit(Integer selectedCountLimit) {
        this.selectedCountLimit = selectedCountLimit;
    }

    public ValuePlacer buildValuePlacer(EnvironmentMode environmentMode, SolutionDescriptor solutionDescriptor, Termination phaseTermination, PlanningEntityDescriptor entityDescriptor) {
        ValueSelector valueSelector = this.valueSelectorConfig.buildValueSelector(environmentMode, solutionDescriptor, entityDescriptor, this.selectedCountLimit == null ? SelectionCacheType.STEP : SelectionCacheType.JUST_IN_TIME, this.selectedCountLimit == null ? SelectionOrder.ORIGINAL : SelectionOrder.RANDOM);
        ValuePlacer valuePlacer = new ValuePlacer(phaseTermination, valueSelector, this.selectedCountLimit == null ? Integer.MAX_VALUE : this.selectedCountLimit);
        if (environmentMode == EnvironmentMode.FULL_ASSERT) {
            valuePlacer.setAssertMoveScoreIsUncorrupted(true);
        }
        if (environmentMode == EnvironmentMode.FAST_ASSERT || environmentMode == EnvironmentMode.FULL_ASSERT) {
            valuePlacer.setAssertUndoMoveIsUncorrupted(true);
        }
        return valuePlacer;
    }

    public void inherit(ValuePlacerConfig inheritedConfig) {
        super.inherit(inheritedConfig);
        if (this.valueSelectorConfig == null) {
            this.valueSelectorConfig = inheritedConfig.getValueSelectorConfig();
        } else if (inheritedConfig.getValueSelectorConfig() != null) {
            this.valueSelectorConfig.inherit(inheritedConfig.getValueSelectorConfig());
        }
        this.selectedCountLimit = ConfigUtils.inheritOverwritableProperty(this.selectedCountLimit, inheritedConfig.getSelectedCountLimit());
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.valueSelectorConfig + ")";
    }
}

