/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.config.heuristic.selector.move.generic;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.Collection;
import java.util.List;
import org.drools.planner.config.EnvironmentMode;
import org.drools.planner.config.heuristic.selector.common.SelectionOrder;
import org.drools.planner.config.heuristic.selector.entity.EntitySelectorConfig;
import org.drools.planner.config.heuristic.selector.move.MoveSelectorConfig;
import org.drools.planner.config.util.ConfigUtils;
import org.drools.planner.core.domain.solution.SolutionDescriptor;
import org.drools.planner.core.domain.variable.PlanningVariableDescriptor;
import org.drools.planner.core.heuristic.selector.common.SelectionCacheType;
import org.drools.planner.core.heuristic.selector.entity.EntitySelector;
import org.drools.planner.core.heuristic.selector.move.MoveSelector;
import org.drools.planner.core.heuristic.selector.move.generic.SwapMoveSelector;

@XStreamAlias(value="swapMoveSelector")
public class SwapMoveSelectorConfig
extends MoveSelectorConfig {
    @XStreamAlias(value="entitySelector")
    private EntitySelectorConfig entitySelectorConfig = new EntitySelectorConfig();
    @XStreamAlias(value="secondaryEntitySelector")
    private EntitySelectorConfig secondaryEntitySelectorConfig = null;
    @XStreamImplicit(itemFieldName="variableNameInclude")
    private List<String> variableNameIncludeList = null;

    public EntitySelectorConfig getEntitySelectorConfig() {
        return this.entitySelectorConfig;
    }

    public void setEntitySelectorConfig(EntitySelectorConfig entitySelectorConfig) {
        this.entitySelectorConfig = entitySelectorConfig;
    }

    public EntitySelectorConfig getSecondaryEntitySelectorConfig() {
        return this.secondaryEntitySelectorConfig;
    }

    public void setSecondaryEntitySelectorConfig(EntitySelectorConfig secondaryEntitySelectorConfig) {
        this.secondaryEntitySelectorConfig = secondaryEntitySelectorConfig;
    }

    public List<String> getVariableNameIncludeList() {
        return this.variableNameIncludeList;
    }

    public void setVariableNameIncludeList(List<String> variableNameIncludeList) {
        this.variableNameIncludeList = variableNameIncludeList;
    }

    @Override
    public MoveSelector buildBaseMoveSelector(EnvironmentMode environmentMode, SolutionDescriptor solutionDescriptor, SelectionCacheType minimumCacheType, boolean randomSelection) {
        EntitySelector leftEntitySelector = this.entitySelectorConfig.buildEntitySelector(environmentMode, solutionDescriptor, minimumCacheType, SelectionOrder.fromRandomSelectionBoolean(randomSelection));
        EntitySelectorConfig rightEntitySelectorConfig = this.secondaryEntitySelectorConfig == null ? this.entitySelectorConfig : this.secondaryEntitySelectorConfig;
        EntitySelector rightEntitySelector = rightEntitySelectorConfig.buildEntitySelector(environmentMode, solutionDescriptor, minimumCacheType, SelectionOrder.fromRandomSelectionBoolean(randomSelection));
        Collection<PlanningVariableDescriptor> variableDescriptors = this.deduceVariableDescriptors(leftEntitySelector.getEntityDescriptor(), this.variableNameIncludeList);
        return new SwapMoveSelector(leftEntitySelector, rightEntitySelector, variableDescriptors, randomSelection);
    }

    public void inherit(SwapMoveSelectorConfig inheritedConfig) {
        super.inherit(inheritedConfig);
        if (this.entitySelectorConfig == null) {
            this.entitySelectorConfig = inheritedConfig.getEntitySelectorConfig();
        } else if (inheritedConfig.getEntitySelectorConfig() != null) {
            this.entitySelectorConfig.inherit(inheritedConfig.getEntitySelectorConfig());
        }
        if (this.secondaryEntitySelectorConfig == null) {
            this.secondaryEntitySelectorConfig = inheritedConfig.getSecondaryEntitySelectorConfig();
        } else if (inheritedConfig.getSecondaryEntitySelectorConfig() != null) {
            this.secondaryEntitySelectorConfig.inherit(inheritedConfig.getSecondaryEntitySelectorConfig());
        }
        this.variableNameIncludeList = ConfigUtils.inheritMergeableListProperty(this.variableNameIncludeList, inheritedConfig.getVariableNameIncludeList());
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.entitySelectorConfig + (this.secondaryEntitySelectorConfig == null ? "" : ", " + this.secondaryEntitySelectorConfig) + ")";
    }
}

