/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.config.heuristic.selector.value.chained;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.drools.planner.api.domain.value.ValueRange;
import org.drools.planner.config.EnvironmentMode;
import org.drools.planner.config.heuristic.selector.SelectorConfig;
import org.drools.planner.config.heuristic.selector.common.SelectionOrder;
import org.drools.planner.config.heuristic.selector.value.ValueSelectorConfig;
import org.drools.planner.config.util.ConfigUtils;
import org.drools.planner.core.domain.entity.PlanningEntityDescriptor;
import org.drools.planner.core.domain.solution.SolutionDescriptor;
import org.drools.planner.core.heuristic.selector.common.SelectionCacheType;
import org.drools.planner.core.heuristic.selector.value.EntityIndependentValueSelector;
import org.drools.planner.core.heuristic.selector.value.ValueSelector;
import org.drools.planner.core.heuristic.selector.value.chained.DefaultSubChainSelector;
import org.drools.planner.core.heuristic.selector.value.chained.SubChainSelector;

@XStreamAlias(value="subChainSelector")
public class SubChainSelectorConfig
extends SelectorConfig {
    private static final int DEFAULT_MINIMUM_SUB_CHAIN_SIZE = 2;
    private static final int DEFAULT_MAXIMUM_SUB_CHAIN_SIZE = Integer.MAX_VALUE;
    @XStreamAlias(value="valueSelector")
    protected ValueSelectorConfig valueSelectorConfig = new ValueSelectorConfig();
    protected Integer minimumSubChainSize = null;
    protected Integer maximumSubChainSize = null;

    public ValueSelectorConfig getValueSelectorConfig() {
        return this.valueSelectorConfig;
    }

    public void setValueSelectorConfig(ValueSelectorConfig valueSelectorConfig) {
        this.valueSelectorConfig = valueSelectorConfig;
    }

    public Integer getMinimumSubChainSize() {
        return this.minimumSubChainSize;
    }

    public void setMinimumSubChainSize(Integer minimumSubChainSize) {
        this.minimumSubChainSize = minimumSubChainSize;
    }

    public Integer getMaximumSubChainSize() {
        return this.maximumSubChainSize;
    }

    public void setMaximumSubChainSize(Integer maximumSubChainSize) {
        this.maximumSubChainSize = maximumSubChainSize;
    }

    public SubChainSelector buildSubChainSelector(EnvironmentMode environmentMode, SolutionDescriptor solutionDescriptor, PlanningEntityDescriptor entityDescriptor, SelectionCacheType minimumCacheType, SelectionOrder inheritedSelectionOrder) {
        if (minimumCacheType.compareTo(SelectionCacheType.STEP) > 0) {
            throw new IllegalArgumentException("The subChainSelectorConfig (" + this + ")'s minimumCacheType (" + (Object)((Object)minimumCacheType) + ") must not be higher than " + (Object)((Object)SelectionCacheType.STEP) + " because the chains change every step.");
        }
        ValueSelector valueSelector = this.valueSelectorConfig.buildValueSelector(environmentMode, solutionDescriptor, entityDescriptor, minimumCacheType, SelectionOrder.ORIGINAL);
        if (!(valueSelector instanceof EntityIndependentValueSelector)) {
            throw new IllegalArgumentException("The minimumCacheType (" + this + ") needs to be based on a EntityIndependentValueSelector." + " Check your @" + ValueRange.class.getSimpleName() + " annotations.");
        }
        return new DefaultSubChainSelector((EntityIndependentValueSelector)valueSelector, inheritedSelectionOrder.toRandomSelectionBoolean(), this.minimumSubChainSize == null ? 2 : this.minimumSubChainSize, this.maximumSubChainSize == null ? Integer.MAX_VALUE : this.maximumSubChainSize);
    }

    public void inherit(SubChainSelectorConfig inheritedConfig) {
        super.inherit(inheritedConfig);
        if (this.valueSelectorConfig == null) {
            this.valueSelectorConfig = inheritedConfig.getValueSelectorConfig();
        } else if (inheritedConfig.getValueSelectorConfig() != null) {
            this.valueSelectorConfig.inherit(inheritedConfig.getValueSelectorConfig());
        }
        this.minimumSubChainSize = ConfigUtils.inheritOverwritableProperty(this.minimumSubChainSize, inheritedConfig.getMinimumSubChainSize());
        this.maximumSubChainSize = ConfigUtils.inheritOverwritableProperty(this.maximumSubChainSize, inheritedConfig.getMaximumSubChainSize());
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.valueSelectorConfig + ")";
    }
}

