/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.config.localsearch;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.drools.planner.config.EnvironmentMode;
import org.drools.planner.config.heuristic.selector.common.SelectionOrder;
import org.drools.planner.config.heuristic.selector.move.MoveSelectorConfig;
import org.drools.planner.config.heuristic.selector.move.composite.UnionMoveSelectorConfig;
import org.drools.planner.config.heuristic.selector.move.generic.ChangeMoveSelectorConfig;
import org.drools.planner.config.heuristic.selector.move.generic.SwapMoveSelectorConfig;
import org.drools.planner.config.localsearch.decider.acceptor.AcceptorConfig;
import org.drools.planner.config.localsearch.decider.forager.ForagerConfig;
import org.drools.planner.config.phase.SolverPhaseConfig;
import org.drools.planner.config.util.ConfigUtils;
import org.drools.planner.core.domain.solution.SolutionDescriptor;
import org.drools.planner.core.heuristic.selector.common.SelectionCacheType;
import org.drools.planner.core.heuristic.selector.move.MoveSelector;
import org.drools.planner.core.localsearch.DefaultLocalSearchSolverPhase;
import org.drools.planner.core.localsearch.LocalSearchSolverPhase;
import org.drools.planner.core.localsearch.decider.Decider;
import org.drools.planner.core.localsearch.decider.DefaultDecider;
import org.drools.planner.core.localsearch.decider.forager.Forager;
import org.drools.planner.core.score.definition.ScoreDefinition;
import org.drools.planner.core.termination.Termination;

@XStreamAlias(value="localSearch")
public class LocalSearchSolverPhaseConfig
extends SolverPhaseConfig {
    @XStreamImplicit
    private List<MoveSelectorConfig> moveSelectorConfigList = null;
    @XStreamAlias(value="acceptor")
    private AcceptorConfig acceptorConfig = new AcceptorConfig();
    @XStreamAlias(value="forager")
    private ForagerConfig foragerConfig = new ForagerConfig();

    public List<MoveSelectorConfig> getMoveSelectorConfigList() {
        return this.moveSelectorConfigList;
    }

    public void setMoveSelectorConfigList(List<MoveSelectorConfig> moveSelectorConfigList) {
        this.moveSelectorConfigList = moveSelectorConfigList;
    }

    public AcceptorConfig getAcceptorConfig() {
        return this.acceptorConfig;
    }

    public void setAcceptorConfig(AcceptorConfig acceptorConfig) {
        this.acceptorConfig = acceptorConfig;
    }

    public ForagerConfig getForagerConfig() {
        return this.foragerConfig;
    }

    public void setForagerConfig(ForagerConfig foragerConfig) {
        this.foragerConfig = foragerConfig;
    }

    @Override
    public LocalSearchSolverPhase buildSolverPhase(int phaseIndex, EnvironmentMode environmentMode, SolutionDescriptor solutionDescriptor, ScoreDefinition scoreDefinition, Termination solverTermination) {
        DefaultLocalSearchSolverPhase localSearchSolverPhase = new DefaultLocalSearchSolverPhase();
        this.configureSolverPhase(localSearchSolverPhase, phaseIndex, environmentMode, scoreDefinition, solverTermination);
        localSearchSolverPhase.setDecider(this.buildDecider(environmentMode, solutionDescriptor, scoreDefinition, localSearchSolverPhase.getTermination()));
        if (environmentMode == EnvironmentMode.FAST_ASSERT || environmentMode == EnvironmentMode.FULL_ASSERT) {
            localSearchSolverPhase.setAssertStepScoreIsUncorrupted(true);
        }
        return localSearchSolverPhase;
    }

    private Decider buildDecider(EnvironmentMode environmentMode, SolutionDescriptor solutionDescriptor, ScoreDefinition scoreDefinition, Termination phaseTermination) {
        DefaultDecider decider = new DefaultDecider();
        decider.setTermination(phaseTermination);
        MoveSelector moveSelector = this.buildMoveSelector(environmentMode, solutionDescriptor);
        decider.setMoveSelector(moveSelector);
        decider.setAcceptor(this.acceptorConfig.buildAcceptor(environmentMode, scoreDefinition));
        Forager forager = this.foragerConfig.buildForager(scoreDefinition);
        decider.setForager(forager);
        if (moveSelector.isNeverEnding() && !forager.supportsNeverEndingMoveSelector()) {
            throw new IllegalStateException("The moveSelector (" + moveSelector + ") has neverEnding (" + moveSelector.isNeverEnding() + "), but the forager (" + forager + ") does not support it." + " Configure the <forager> with <minimalAcceptedSelection>.");
        }
        if (environmentMode == EnvironmentMode.FULL_ASSERT) {
            decider.setAssertMoveScoreIsUncorrupted(true);
        }
        if (environmentMode == EnvironmentMode.FAST_ASSERT || environmentMode == EnvironmentMode.FULL_ASSERT) {
            decider.setAssertUndoMoveIsUncorrupted(true);
        }
        return decider;
    }

    private MoveSelector buildMoveSelector(EnvironmentMode environmentMode, SolutionDescriptor solutionDescriptor) {
        MoveSelector moveSelector;
        SelectionCacheType defaultCacheType = SelectionCacheType.JUST_IN_TIME;
        SelectionOrder defaultSelectionOrder = SelectionOrder.RANDOM;
        if (CollectionUtils.isEmpty(this.moveSelectorConfigList)) {
            UnionMoveSelectorConfig unionMoveSelectorConfig = new UnionMoveSelectorConfig();
            unionMoveSelectorConfig.setMoveSelectorConfigList(Arrays.asList(new ChangeMoveSelectorConfig(), new SwapMoveSelectorConfig()));
            moveSelector = unionMoveSelectorConfig.buildMoveSelector(environmentMode, solutionDescriptor, defaultCacheType, defaultSelectionOrder);
        } else if (this.moveSelectorConfigList.size() == 1) {
            moveSelector = this.moveSelectorConfigList.get(0).buildMoveSelector(environmentMode, solutionDescriptor, defaultCacheType, defaultSelectionOrder);
        } else {
            throw new IllegalArgumentException("The moveSelectorConfigList (" + this.moveSelectorConfigList + ") must a singleton or empty. Use a single " + UnionMoveSelectorConfig.class + " element to nest multiple MoveSelectors.");
        }
        return moveSelector;
    }

    public void inherit(LocalSearchSolverPhaseConfig inheritedConfig) {
        super.inherit(inheritedConfig);
        this.moveSelectorConfigList = ConfigUtils.inheritMergeableListProperty(this.moveSelectorConfigList, inheritedConfig.getMoveSelectorConfigList());
        if (this.acceptorConfig == null) {
            this.acceptorConfig = inheritedConfig.getAcceptorConfig();
        } else if (inheritedConfig.getAcceptorConfig() != null) {
            this.acceptorConfig.inherit(inheritedConfig.getAcceptorConfig());
        }
        if (this.foragerConfig == null) {
            this.foragerConfig = inheritedConfig.getForagerConfig();
        } else if (inheritedConfig.getForagerConfig() != null) {
            this.foragerConfig.inherit(inheritedConfig.getForagerConfig());
        }
    }
}

