/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.config.score.director;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.drools.RuleBase;
import org.drools.RuleBaseConfiguration;
import org.drools.RuleBaseFactory;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.PackageBuilder;
import org.drools.planner.config.EnvironmentMode;
import org.drools.planner.config.util.ConfigUtils;
import org.drools.planner.core.domain.solution.SolutionDescriptor;
import org.drools.planner.core.score.buildin.hardmediumsoft.HardMediumSoftScoreDefinition;
import org.drools.planner.core.score.buildin.hardsoft.HardSoftScoreDefinition;
import org.drools.planner.core.score.buildin.hardsoftlong.HardSoftLongScoreDefinition;
import org.drools.planner.core.score.buildin.simple.SimpleScoreDefinition;
import org.drools.planner.core.score.buildin.simpledouble.SimpleDoubleScoreDefinition;
import org.drools.planner.core.score.definition.ScoreDefinition;
import org.drools.planner.core.score.director.AbstractScoreDirectorFactory;
import org.drools.planner.core.score.director.ScoreDirectorFactory;
import org.drools.planner.core.score.director.drools.DroolsScoreDirectorFactory;
import org.drools.planner.core.score.director.incremental.IncrementalScoreCalculator;
import org.drools.planner.core.score.director.incremental.IncrementalScoreDirectorFactory;
import org.drools.planner.core.score.director.simple.SimpleScoreCalculator;
import org.drools.planner.core.score.director.simple.SimpleScoreDirectorFactory;

@XStreamAlias(value="scoreDirectorFactory")
public class ScoreDirectorFactoryConfig {
    protected ScoreDefinition scoreDefinition = null;
    protected Class<? extends ScoreDefinition> scoreDefinitionClass = null;
    protected ScoreDefinitionType scoreDefinitionType = null;
    @XStreamOmitField
    protected SimpleScoreCalculator simpleScoreCalculator = null;
    protected Class<? extends SimpleScoreCalculator> simpleScoreCalculatorClass = null;
    protected Class<? extends IncrementalScoreCalculator> incrementalScoreCalculatorClass = null;
    @XStreamOmitField
    protected RuleBase ruleBase = null;
    @XStreamImplicit(itemFieldName="scoreDrl")
    protected List<String> scoreDrlList = null;
    @XStreamAlias(value="assertionScoreDirectorFactory")
    protected ScoreDirectorFactoryConfig assertionScoreDirectorFactory = null;

    public ScoreDefinition getScoreDefinition() {
        return this.scoreDefinition;
    }

    public void setScoreDefinition(ScoreDefinition scoreDefinition) {
        this.scoreDefinition = scoreDefinition;
    }

    public Class<? extends ScoreDefinition> getScoreDefinitionClass() {
        return this.scoreDefinitionClass;
    }

    public void setScoreDefinitionClass(Class<? extends ScoreDefinition> scoreDefinitionClass) {
        this.scoreDefinitionClass = scoreDefinitionClass;
    }

    public ScoreDefinitionType getScoreDefinitionType() {
        return this.scoreDefinitionType;
    }

    public void setScoreDefinitionType(ScoreDefinitionType scoreDefinitionType) {
        this.scoreDefinitionType = scoreDefinitionType;
    }

    public SimpleScoreCalculator getSimpleScoreCalculator() {
        return this.simpleScoreCalculator;
    }

    public void setSimpleScoreCalculator(SimpleScoreCalculator simpleScoreCalculator) {
        this.simpleScoreCalculator = simpleScoreCalculator;
    }

    public Class<? extends SimpleScoreCalculator> getSimpleScoreCalculatorClass() {
        return this.simpleScoreCalculatorClass;
    }

    public void setSimpleScoreCalculatorClass(Class<? extends SimpleScoreCalculator> simpleScoreCalculatorClass) {
        this.simpleScoreCalculatorClass = simpleScoreCalculatorClass;
    }

    public Class<? extends IncrementalScoreCalculator> getIncrementalScoreCalculatorClass() {
        return this.incrementalScoreCalculatorClass;
    }

    public void setIncrementalScoreCalculatorClass(Class<? extends IncrementalScoreCalculator> incrementalScoreCalculatorClass) {
        this.incrementalScoreCalculatorClass = incrementalScoreCalculatorClass;
    }

    public RuleBase getRuleBase() {
        return this.ruleBase;
    }

    public void setRuleBase(RuleBase ruleBase) {
        this.ruleBase = ruleBase;
    }

    public List<String> getScoreDrlList() {
        return this.scoreDrlList;
    }

    public void setScoreDrlList(List<String> scoreDrlList) {
        this.scoreDrlList = scoreDrlList;
    }

    public ScoreDirectorFactoryConfig getAssertionScoreDirectorFactory() {
        return this.assertionScoreDirectorFactory;
    }

    public void setAssertionScoreDirectorFactory(ScoreDirectorFactoryConfig assertionScoreDirectorFactory) {
        this.assertionScoreDirectorFactory = assertionScoreDirectorFactory;
    }

    public ScoreDirectorFactory buildScoreDirectorFactory(EnvironmentMode environmentMode, SolutionDescriptor solutionDescriptor) {
        ScoreDefinition scoreDefinition = this.buildScoreDefinition();
        return this.buildScoreDirectorFactory(environmentMode, solutionDescriptor, scoreDefinition);
    }

    protected ScoreDirectorFactory buildScoreDirectorFactory(EnvironmentMode environmentMode, SolutionDescriptor solutionDescriptor, ScoreDefinition scoreDefinition) {
        AbstractScoreDirectorFactory scoreDirectorFactory = this.buildSimpleScoreDirectorFactory();
        if (scoreDirectorFactory == null) {
            scoreDirectorFactory = this.buildIncrementalScoreDirectorFactory();
        }
        if (scoreDirectorFactory == null) {
            scoreDirectorFactory = this.buildDroolsScoreDirectorFactory();
        }
        scoreDirectorFactory.setSolutionDescriptor(solutionDescriptor);
        scoreDirectorFactory.setScoreDefinition(scoreDefinition);
        if (this.assertionScoreDirectorFactory != null) {
            if (this.assertionScoreDirectorFactory.getAssertionScoreDirectorFactory() != null) {
                throw new IllegalArgumentException("A assertionScoreDirectorFactory (" + this.assertionScoreDirectorFactory + ") cannot have a non-null assertionScoreDirectorFactory (" + this.assertionScoreDirectorFactory.getAssertionScoreDirectorFactory() + ").");
            }
            if (this.assertionScoreDirectorFactory.getScoreDefinition() != null || this.assertionScoreDirectorFactory.getScoreDefinitionClass() != null || this.assertionScoreDirectorFactory.getScoreDefinitionType() != null) {
                throw new IllegalArgumentException("A assertionScoreDirectorFactory (" + this.assertionScoreDirectorFactory + ") must reuse the scoreDefinition of its parent." + " It cannot have a non-null scoreDefinition* property.");
            }
            if (environmentMode.compareTo(EnvironmentMode.FAST_ASSERT) > 0) {
                throw new IllegalArgumentException("A non-null assertionScoreDirectorFactory (" + this.assertionScoreDirectorFactory + ") requires an environmentMode (" + (Object)((Object)environmentMode) + ") of " + (Object)((Object)EnvironmentMode.FAST_ASSERT) + " or lower.");
            }
            scoreDirectorFactory.setAssertionScoreDirectorFactory(this.assertionScoreDirectorFactory.buildScoreDirectorFactory(EnvironmentMode.PRODUCTION, solutionDescriptor, scoreDefinition));
        }
        return scoreDirectorFactory;
    }

    public ScoreDefinition buildScoreDefinition() {
        if (this.scoreDefinition != null) {
            return this.scoreDefinition;
        }
        if (this.scoreDefinitionClass != null) {
            return ConfigUtils.newInstance(this, "scoreDefinitionClass", this.scoreDefinitionClass);
        }
        if (this.scoreDefinitionType != null) {
            switch (this.scoreDefinitionType) {
                case SIMPLE: {
                    return new SimpleScoreDefinition();
                }
                case SIMPLE_DOUBLE: {
                    return new SimpleDoubleScoreDefinition();
                }
                case HARD_SOFT: {
                    return new HardSoftScoreDefinition();
                }
                case HARD_SOFT_LONG: {
                    return new HardSoftLongScoreDefinition();
                }
                case HARD_MEDIUM_SOFT: {
                    return new HardMediumSoftScoreDefinition();
                }
            }
            throw new IllegalStateException("The scoreDefinitionType (" + (Object)((Object)this.scoreDefinitionType) + ") is not implemented.");
        }
        return new SimpleScoreDefinition();
    }

    private AbstractScoreDirectorFactory buildSimpleScoreDirectorFactory() {
        if (this.simpleScoreCalculator != null) {
            return new SimpleScoreDirectorFactory(this.simpleScoreCalculator);
        }
        if (this.simpleScoreCalculatorClass != null) {
            SimpleScoreCalculator simpleScoreCalculator = ConfigUtils.newInstance(this, "simpleScoreCalculatorClass", this.simpleScoreCalculatorClass);
            return new SimpleScoreDirectorFactory(simpleScoreCalculator);
        }
        return null;
    }

    private AbstractScoreDirectorFactory buildIncrementalScoreDirectorFactory() {
        if (this.incrementalScoreCalculatorClass != null) {
            return new IncrementalScoreDirectorFactory(this.incrementalScoreCalculatorClass);
        }
        return null;
    }

    private AbstractScoreDirectorFactory buildDroolsScoreDirectorFactory() {
        DroolsScoreDirectorFactory scoreDirectorFactory = new DroolsScoreDirectorFactory();
        scoreDirectorFactory.setRuleBase(this.buildRuleBase());
        return scoreDirectorFactory;
    }

    private RuleBase buildRuleBase() {
        if (this.ruleBase != null) {
            if (!CollectionUtils.isEmpty(this.scoreDrlList)) {
                throw new IllegalArgumentException("If ruleBase is not null, the scoreDrlList (" + this.scoreDrlList + ") must be empty.");
            }
            return this.ruleBase;
        }
        PackageBuilder packageBuilder = new PackageBuilder();
        for (String scoreDrl : this.scoreDrlList) {
            InputStream scoreDrlIn = this.getClass().getResourceAsStream(scoreDrl);
            if (scoreDrlIn == null) {
                throw new IllegalArgumentException("scoreDrl (" + scoreDrl + ") does not exist as a classpath resource.");
            }
            try {
                packageBuilder.addPackageFromDrl((Reader)new InputStreamReader(scoreDrlIn, "UTF-8"));
            }
            catch (DroolsParserException e) {
                throw new IllegalArgumentException("scoreDrl (" + scoreDrl + ") could not be loaded.", e);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("scoreDrl (" + scoreDrl + ") could not be loaded.", e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)scoreDrlIn);
            }
        }
        RuleBaseConfiguration ruleBaseConfiguration = new RuleBaseConfiguration();
        RuleBase ruleBase = RuleBaseFactory.newRuleBase((RuleBaseConfiguration)ruleBaseConfiguration);
        if (packageBuilder.hasErrors()) {
            throw new IllegalStateException("There are errors in the scoreDrl's:\n" + packageBuilder.getErrors().toString());
        }
        ruleBase.addPackage(packageBuilder.getPackage());
        return ruleBase;
    }

    public void inherit(ScoreDirectorFactoryConfig inheritedConfig) {
        if (this.scoreDefinition == null && this.scoreDefinitionClass == null && this.scoreDefinitionType == null) {
            this.scoreDefinition = inheritedConfig.getScoreDefinition();
            this.scoreDefinitionClass = inheritedConfig.getScoreDefinitionClass();
            this.scoreDefinitionType = inheritedConfig.getScoreDefinitionType();
        }
        if (this.simpleScoreCalculator == null) {
            this.simpleScoreCalculator = inheritedConfig.getSimpleScoreCalculator();
        }
        if (this.simpleScoreCalculatorClass == null) {
            this.simpleScoreCalculatorClass = inheritedConfig.getSimpleScoreCalculatorClass();
        }
        if (this.incrementalScoreCalculatorClass == null) {
            this.incrementalScoreCalculatorClass = inheritedConfig.getIncrementalScoreCalculatorClass();
        }
        if (this.ruleBase == null) {
            this.ruleBase = inheritedConfig.getRuleBase();
        }
        this.scoreDrlList = ConfigUtils.inheritMergeableListProperty(this.scoreDrlList, inheritedConfig.getScoreDrlList());
        if (this.assertionScoreDirectorFactory == null) {
            this.assertionScoreDirectorFactory = inheritedConfig.getAssertionScoreDirectorFactory();
        }
    }

    public static enum ScoreDefinitionType {
        SIMPLE,
        SIMPLE_DOUBLE,
        HARD_SOFT,
        HARD_SOFT_LONG,
        HARD_MEDIUM_SOFT;

    }
}

