/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.constructionheuristic.greedyFit;

import java.util.Iterator;
import org.drools.planner.core.constructionheuristic.greedyFit.GreedyFitSolverPhase;
import org.drools.planner.core.constructionheuristic.greedyFit.decider.GreedyDecider;
import org.drools.planner.core.constructionheuristic.greedyFit.scope.GreedyFitSolverPhaseScope;
import org.drools.planner.core.constructionheuristic.greedyFit.scope.GreedyFitStepScope;
import org.drools.planner.core.constructionheuristic.greedyFit.selector.GreedyPlanningEntitySelector;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.phase.AbstractSolverPhase;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.core.solver.scope.DefaultSolverScope;

public class DefaultGreedyFitSolverPhase
extends AbstractSolverPhase
implements GreedyFitSolverPhase {
    protected GreedyPlanningEntitySelector greedyPlanningEntitySelector;
    protected GreedyDecider greedyDecider;
    protected boolean assertStepScoreIsUncorrupted = false;

    public void setGreedyPlanningEntitySelector(GreedyPlanningEntitySelector greedyPlanningEntitySelector) {
        this.greedyPlanningEntitySelector = greedyPlanningEntitySelector;
    }

    public void setGreedyDecider(GreedyDecider greedyDecider) {
        this.greedyDecider = greedyDecider;
    }

    public void setAssertStepScoreIsUncorrupted(boolean assertStepScoreIsUncorrupted) {
        this.assertStepScoreIsUncorrupted = assertStepScoreIsUncorrupted;
    }

    @Override
    public void solve(DefaultSolverScope solverScope) {
        GreedyFitSolverPhaseScope phaseScope = new GreedyFitSolverPhaseScope(solverScope);
        this.phaseStarted(phaseScope);
        GreedyFitStepScope stepScope = this.createNextStepScope(phaseScope, null);
        Iterator<Object> it = this.greedyPlanningEntitySelector.iterator();
        while (!this.termination.isPhaseTerminated(phaseScope) && it.hasNext()) {
            Object planningEntity = it.next();
            stepScope.setPlanningEntity(planningEntity);
            this.stepStarted(stepScope);
            this.greedyDecider.decideNextStep(stepScope);
            Move nextStep = stepScope.getStep();
            if (nextStep == null) {
                this.logger.warn("    Cancelled step index ({}), time spend ({}): there is no doable move. Terminating phase early.", (Object)stepScope.getStepIndex(), (Object)phaseScope.calculateSolverTimeMillisSpend());
                break;
            }
            nextStep.doMove(stepScope.getScoreDirector());
            phaseScope.getWorkingSolution().setScore(stepScope.getScore());
            if (this.assertStepScoreIsUncorrupted) {
                phaseScope.assertWorkingScoreFromScratch(stepScope.getScore());
                phaseScope.assertExpectedWorkingScore(stepScope.getScore());
            }
            this.stepEnded(stepScope);
            stepScope = this.createNextStepScope(phaseScope, stepScope);
        }
        this.phaseEnded(phaseScope);
    }

    private GreedyFitStepScope createNextStepScope(GreedyFitSolverPhaseScope greedyFitSolverPhaseScope, GreedyFitStepScope completedGreedyFitStepScope) {
        if (completedGreedyFitStepScope == null) {
            completedGreedyFitStepScope = new GreedyFitStepScope(greedyFitSolverPhaseScope);
            completedGreedyFitStepScope.setScore(greedyFitSolverPhaseScope.getStartingScore());
            completedGreedyFitStepScope.setStepIndex(-1);
        }
        greedyFitSolverPhaseScope.setLastCompletedStepScope(completedGreedyFitStepScope);
        GreedyFitStepScope greedyFitStepScope = new GreedyFitStepScope(greedyFitSolverPhaseScope);
        greedyFitStepScope.setStepIndex(completedGreedyFitStepScope.getStepIndex() + 1);
        return greedyFitStepScope;
    }

    @Override
    public void solvingStarted(DefaultSolverScope solverScope) {
        super.solvingStarted(solverScope);
    }

    public void phaseStarted(GreedyFitSolverPhaseScope phaseScope) {
        super.phaseStarted(phaseScope);
        this.greedyPlanningEntitySelector.phaseStarted(phaseScope);
        this.greedyDecider.phaseStarted(phaseScope);
    }

    public void stepStarted(GreedyFitStepScope stepScope) {
        super.stepStarted(stepScope);
        this.greedyPlanningEntitySelector.stepStarted(stepScope);
        this.greedyDecider.stepStarted(stepScope);
    }

    public void stepEnded(GreedyFitStepScope stepScope) {
        super.stepEnded(stepScope);
        this.greedyPlanningEntitySelector.stepEnded(stepScope);
        this.greedyDecider.stepEnded(stepScope);
        if (this.logger.isDebugEnabled()) {
            long timeMillisSpend = stepScope.getPhaseScope().calculateSolverTimeMillisSpend();
            this.logger.debug("    Step index ({}), time spend ({}), score ({}), initialized planning entity ({}).", new Object[]{stepScope.getStepIndex(), timeMillisSpend, stepScope.getScore(), stepScope.getPlanningEntity()});
        }
    }

    public void phaseEnded(GreedyFitSolverPhaseScope phaseScope) {
        super.phaseEnded(phaseScope);
        Solution newBestSolution = phaseScope.getScoreDirector().cloneWorkingSolution();
        int newBestUninitializedVariableCount = phaseScope.getSolutionDescriptor().countUninitializedVariables(newBestSolution);
        this.bestSolutionRecaller.updateBestSolution(phaseScope.getSolverScope(), newBestSolution, newBestUninitializedVariableCount);
        this.greedyPlanningEntitySelector.phaseEnded(phaseScope);
        this.greedyDecider.phaseEnded(phaseScope);
        this.logger.info("Phase ({}) constructionHeuristic ended: step total ({}), time spend ({}), best score ({}).", new Object[]{this.phaseIndex, phaseScope.getLastCompletedStepScope().getStepIndex() + 1, phaseScope.calculateSolverTimeMillisSpend(), phaseScope.getBestScore()});
    }

    @Override
    public void solvingEnded(DefaultSolverScope solverScope) {
        super.solvingStarted(solverScope);
    }
}

