/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.domain.common;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class PropertyAccessor {
    private final PropertyDescriptor propertyDescriptor;
    private final Method readMethod;
    private final Method writeMethod;

    public PropertyAccessor(PropertyDescriptor propertyDescriptor) {
        this.propertyDescriptor = propertyDescriptor;
        this.readMethod = propertyDescriptor.getReadMethod();
        if (this.readMethod != null) {
            this.readMethod.setAccessible(true);
        }
        this.writeMethod = propertyDescriptor.getWriteMethod();
        if (this.writeMethod != null) {
            this.writeMethod.setAccessible(true);
        }
    }

    public Method getReadMethod() {
        return this.readMethod;
    }

    public Method getWriteMethod() {
        return this.writeMethod;
    }

    public String getName() {
        return this.propertyDescriptor.getName();
    }

    public Class<?> getPropertyType() {
        return this.propertyDescriptor.getPropertyType();
    }

    public Object executeGetter(Object bean) {
        try {
            return this.readMethod.invoke(bean, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Cannot call property (" + this.propertyDescriptor.getName() + ") getter on bean of class (" + bean.getClass() + ").", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("The property (" + this.propertyDescriptor.getName() + ") getter on bean of class (" + bean.getClass() + ") throws an exception.", e.getCause());
        }
    }

    public void executeSetter(Object bean, Object value) {
        try {
            this.writeMethod.invoke(bean, value);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Cannot call property (" + this.propertyDescriptor.getName() + ") setter on bean of class (" + bean.getClass() + ").", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("The property (" + this.propertyDescriptor.getName() + ") setter on bean of class (" + bean.getClass() + ") throws an exception.", e.getCause());
        }
    }
}

