/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.domain.solution.cloner;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import org.drools.planner.api.domain.solution.cloner.SolutionCloner;
import org.drools.planner.core.domain.solution.SolutionDescriptor;
import org.drools.planner.core.solution.Solution;

public class FieldAccessingSolutionCloner<SolutionG extends Solution>
implements SolutionCloner<SolutionG> {
    protected SolutionDescriptor solutionDescriptor;

    public FieldAccessingSolutionCloner(SolutionDescriptor solutionDescriptor) {
        this.solutionDescriptor = solutionDescriptor;
    }

    @Override
    public SolutionG cloneSolution(SolutionG originalSolution) {
        return new FieldAccessingSolutionClonerRun().cloneSolution(originalSolution);
    }

    protected class FieldAccessingSolutionClonerRun {
        protected Map<Object, Object> originalToCloneMap;
        protected Queue<Unprocessed> unprocessedQueue;

        protected FieldAccessingSolutionClonerRun() {
        }

        protected SolutionG cloneSolution(SolutionG originalSolution) {
            this.unprocessedQueue = new LinkedList<Unprocessed>();
            this.originalToCloneMap = new IdentityHashMap<Object, Object>(FieldAccessingSolutionCloner.this.solutionDescriptor.getPlanningEntityCount((Solution)originalSolution) + 1);
            Solution cloneSolution = (Solution)this.clone(originalSolution);
            this.processQueue();
            return cloneSolution;
        }

        protected <C> C clone(C original) {
            if (original == null) {
                return null;
            }
            Object existingClone = this.originalToCloneMap.get(original);
            if (existingClone != null) {
                return (C)existingClone;
            }
            Class<?> clazz = original.getClass();
            Object clone = this.constructClone(clazz);
            this.originalToCloneMap.put(original, clone);
            this.copyFields(clazz, original, clone);
            return (C)clone;
        }

        protected <C> C constructClone(Class<C> clazz) {
            try {
                Constructor<C> constructor = clazz.getConstructor(new Class[0]);
                constructor.setAccessible(true);
                return constructor.newInstance(new Object[0]);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException("The class (" + clazz + ") should have a no-arg constructor to create a clone.", e);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("The class (" + clazz + ") should have a no-arg constructor to create a clone.", e);
            }
            catch (InstantiationException e) {
                throw new IllegalStateException("The class (" + clazz + ") should have a no-arg constructor to create a clone.", e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("The class (" + clazz + ") should have a no-arg constructor to create a clone.", e);
            }
        }

        protected <C> void copyFields(Class<C> clazz, C original, C clone) {
            for (Field field : clazz.getDeclaredFields()) {
                field.setAccessible(true);
                Object originalValue = this.getField(original, field);
                if (this.isDeepCloneField(field, originalValue)) {
                    this.unprocessedQueue.add(new Unprocessed(clone, field, originalValue));
                    continue;
                }
                this.setField(clone, field, originalValue);
            }
            Class<C> superclass = clazz.getSuperclass();
            if (superclass != null) {
                this.copyFields(superclass, original, clone);
            }
        }

        protected boolean isDeepCloneField(Field field, Object originalValue) {
            if (originalValue == null) {
                return false;
            }
            Class<?> declaringClass = field.getDeclaringClass();
            if (declaringClass == FieldAccessingSolutionCloner.this.solutionDescriptor.getSolutionClass()) {
                String fieldName = field.getName();
                if (FieldAccessingSolutionCloner.this.solutionDescriptor.getEntityPropertyAccessorMap().get(fieldName) != null) {
                    return true;
                }
                if (FieldAccessingSolutionCloner.this.solutionDescriptor.getEntityCollectionPropertyAccessorMap().get(fieldName) != null) {
                    return true;
                }
            }
            Class<?> valueClass = originalValue.getClass();
            return FieldAccessingSolutionCloner.this.solutionDescriptor.getPlanningEntityClassSet().contains(valueClass) || valueClass == FieldAccessingSolutionCloner.this.solutionDescriptor.getSolutionClass();
        }

        protected void processQueue() {
            while (!this.unprocessedQueue.isEmpty()) {
                Unprocessed unprocessed = this.unprocessedQueue.remove();
                this.process(unprocessed);
            }
        }

        private void process(Unprocessed unprocessed) {
            Object cloneValue = unprocessed.originalValue instanceof Collection ? this.cloneCollection((Collection)unprocessed.originalValue) : (unprocessed.originalValue instanceof Map ? this.cloneMap((Map)unprocessed.originalValue) : this.clone(unprocessed.originalValue));
            this.setField(unprocessed.bean, unprocessed.field, cloneValue);
        }

        private Collection cloneCollection(Collection originalCollection) {
            Collection cloneCollection;
            if (!(originalCollection instanceof Cloneable)) {
                cloneCollection = new ArrayList(originalCollection.size());
            } else {
                try {
                    Method cloneMethod = originalCollection.getClass().getMethod("clone", new Class[0]);
                    cloneCollection = (Collection)cloneMethod.invoke((Object)originalCollection, new Object[0]);
                }
                catch (InvocationTargetException e) {
                    throw new IllegalStateException("Could not call clone() on collection (" + originalCollection + ") which is an instance of a class (" + originalCollection.getClass() + ") and implements Cloneable.");
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalStateException("Could not call clone() on collection (" + originalCollection + ") which is an instance of a class (" + originalCollection.getClass() + ") and implements Cloneable.");
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException("Could not call clone() on collection (" + originalCollection + ") which is an instance of a class (" + originalCollection.getClass() + ") and implements Cloneable.");
                }
                cloneCollection.clear();
            }
            for (Object originalEntity : originalCollection) {
                Object cloneElement = this.clone(originalEntity);
                cloneCollection.add(cloneElement);
            }
            return cloneCollection;
        }

        private Map cloneMap(Map originalMap) {
            throw new UnsupportedOperationException();
        }

        private Object getField(Object bean, Field field) {
            try {
                return field.get(bean);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("The class (" + bean.getClass() + ") has a field (" + field + ") which can not be read to create a clone.", e);
            }
        }

        private void setField(Object bean, Field field, Object value) {
            try {
                field.set(bean, value);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("The class (" + bean.getClass() + ") has a field (" + field + ") which can not be written to create a clone.", e);
            }
        }
    }

    protected static class Unprocessed {
        protected Object bean;
        protected Field field;
        protected Object originalValue;

        public Unprocessed(Object bean, Field field, Object originalValue) {
            this.bean = bean;
            this.field = field;
            this.originalValue = originalValue;
        }
    }
}

