/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.domain.value;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.drools.planner.api.domain.entity.PlanningEntity;
import org.drools.planner.api.domain.value.ValueRange;
import org.drools.planner.core.domain.entity.PlanningEntityDescriptor;
import org.drools.planner.core.domain.value.PlanningValueRangeDescriptor;
import org.drools.planner.core.domain.variable.PlanningVariableDescriptor;

public abstract class AbstractPlanningValueRangeDescriptor
implements PlanningValueRangeDescriptor {
    protected PlanningVariableDescriptor variableDescriptor;
    protected boolean excludeUninitializedPlanningEntity;

    public AbstractPlanningValueRangeDescriptor(PlanningVariableDescriptor variableDescriptor) {
        this.variableDescriptor = variableDescriptor;
    }

    public PlanningVariableDescriptor getVariableDescriptor() {
        return this.variableDescriptor;
    }

    protected void processExcludeUninitializedPlanningEntity(ValueRange valueRangeAnnotation) {
        this.excludeUninitializedPlanningEntity = valueRangeAnnotation.excludeUninitializedPlanningEntity();
        if (this.excludeUninitializedPlanningEntity) {
            Class<?> variablePropertyType = this.variableDescriptor.getVariablePropertyType();
            Set<Class<?>> entityClassSet = this.variableDescriptor.getPlanningEntityDescriptor().getSolutionDescriptor().getPlanningEntityClassSet();
            boolean assignableFrom = false;
            for (Class<?> entityClass : entityClassSet) {
                if (!variablePropertyType.isAssignableFrom(entityClass)) continue;
                assignableFrom = true;
                break;
            }
            if (!assignableFrom) {
                throw new IllegalArgumentException("The planningEntityClass (" + this.variableDescriptor.getPlanningEntityDescriptor().getPlanningEntityClass() + ") has a PlanningVariable annotated property (" + this.variableDescriptor.getVariableName() + ") with excludeUninitializedPlanningEntity (true), but there is no planning entity class" + " that extends the variablePropertyType (" + variablePropertyType + ").");
            }
        }
    }

    protected Collection<?> applyFiltering(Collection<?> values) {
        if (!this.excludeUninitializedPlanningEntity) {
            return values;
        }
        ArrayList filteredValues = new ArrayList(values.size());
        for (Object value : values) {
            if (!value.getClass().isAnnotationPresent(PlanningEntity.class)) continue;
            PlanningEntityDescriptor entityDescriptor = this.variableDescriptor.getPlanningEntityDescriptor().getSolutionDescriptor().getPlanningEntityDescriptor(value.getClass());
            if (entityDescriptor == null) {
                throw new IllegalArgumentException("The planningEntityClass (" + this.variableDescriptor.getPlanningEntityDescriptor().getPlanningEntityClass() + ") has a PlanningVariable annotated property (" + this.variableDescriptor.getVariableName() + ") with excludeUninitializedPlanningEntity (true)," + " but a planning value class (" + value.getClass() + ") annotated with PlanningEntity is a non configured as a planning entity.");
            }
            if (!this.variableDescriptor.isInitialized(value)) continue;
            filteredValues.add(value);
        }
        return filteredValues;
    }

    @Override
    public boolean isValuesCacheable() {
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.variableDescriptor.getVariableName() + ")";
    }
}

