/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.heuristic.selector.common.iterator;

import java.util.ListIterator;
import org.apache.commons.collections.IteratorUtils;
import org.drools.planner.core.heuristic.selector.ListIterableSelector;
import org.drools.planner.core.heuristic.selector.common.iterator.ListIterable;
import org.drools.planner.core.heuristic.selector.common.iterator.UpcomingSelectionIterator;

public abstract class AbstractOriginalSwapIterator<S, SubS>
extends UpcomingSelectionIterator<S> {
    protected final ListIterable<SubS> leftSubSelector;
    protected final ListIterable<SubS> rightSubSelector;
    protected final boolean leftEqualsRight;
    private ListIterator<SubS> leftSubSelectionIterator;
    private ListIterator<SubS> rightSubSelectionIterator;
    private SubS leftSubSelection;

    public static <SubS> long getSize(ListIterableSelector leftSubSelector, ListIterableSelector rightSubSelector) {
        if (leftSubSelector != rightSubSelector) {
            return leftSubSelector.getSize() * rightSubSelector.getSize();
        }
        long leftSize = leftSubSelector.getSize();
        return leftSize * (leftSize - 1L) / 2L;
    }

    public AbstractOriginalSwapIterator(ListIterable<SubS> leftSubSelector, ListIterable<SubS> rightSubSelector) {
        this.leftSubSelector = leftSubSelector;
        this.rightSubSelector = rightSubSelector;
        this.leftEqualsRight = leftSubSelector == rightSubSelector;
        this.leftSubSelectionIterator = leftSubSelector.listIterator();
        this.rightSubSelectionIterator = IteratorUtils.emptyListIterator();
        this.createUpcomingSelection();
    }

    @Override
    protected void createUpcomingSelection() {
        if (!this.rightSubSelectionIterator.hasNext()) {
            if (!this.leftSubSelectionIterator.hasNext()) {
                this.upcomingSelection = null;
                return;
            }
            this.leftSubSelection = this.leftSubSelectionIterator.next();
            if (!this.leftEqualsRight) {
                this.rightSubSelectionIterator = this.rightSubSelector.listIterator();
                if (!this.rightSubSelectionIterator.hasNext()) {
                    this.upcomingSelection = null;
                    return;
                }
            } else {
                if (!this.leftSubSelectionIterator.hasNext()) {
                    this.upcomingSelection = null;
                    return;
                }
                this.rightSubSelectionIterator = this.rightSubSelector.listIterator(this.leftSubSelectionIterator.nextIndex());
            }
        }
        SubS rightSubSelection = this.rightSubSelectionIterator.next();
        this.upcomingSelection = this.newSwapSelection(this.leftSubSelection, rightSubSelection);
    }

    protected abstract S newSwapSelection(SubS var1, SubS var2);
}

