/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.heuristic.selector.entity;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.drools.planner.core.domain.entity.PlanningEntityDescriptor;
import org.drools.planner.core.heuristic.selector.common.SelectionCacheLifecycleBridge;
import org.drools.planner.core.heuristic.selector.common.SelectionCacheLifecycleListener;
import org.drools.planner.core.heuristic.selector.common.SelectionCacheType;
import org.drools.planner.core.heuristic.selector.common.iterator.CachedListRandomIterator;
import org.drools.planner.core.heuristic.selector.entity.AbstractEntitySelector;
import org.drools.planner.core.solver.scope.DefaultSolverScope;

public class FromSolutionEntitySelector
extends AbstractEntitySelector
implements SelectionCacheLifecycleListener {
    protected final PlanningEntityDescriptor entityDescriptor;
    protected final SelectionCacheType cacheType;
    protected final boolean randomSelection;
    protected List<Object> cachedEntityList = null;

    public FromSolutionEntitySelector(PlanningEntityDescriptor entityDescriptor, SelectionCacheType cacheType, boolean randomSelection) {
        this.entityDescriptor = entityDescriptor;
        this.cacheType = cacheType;
        this.randomSelection = randomSelection;
        if (cacheType.isNotCached()) {
            throw new IllegalArgumentException("The selector (" + this + ") does not support the cacheType (" + (Object)((Object)cacheType) + ").");
        }
        this.solverPhaseLifecycleSupport.addEventListener(new SelectionCacheLifecycleBridge(cacheType, this));
    }

    @Override
    public PlanningEntityDescriptor getEntityDescriptor() {
        return this.entityDescriptor;
    }

    @Override
    public SelectionCacheType getCacheType() {
        return this.cacheType;
    }

    @Override
    public void constructCache(DefaultSolverScope solverScope) {
        this.cachedEntityList = this.entityDescriptor.extractEntities(solverScope.getWorkingSolution());
    }

    @Override
    public void disposeCache(DefaultSolverScope solverScope) {
        this.cachedEntityList = null;
    }

    @Override
    public boolean isContinuous() {
        return false;
    }

    @Override
    public boolean isNeverEnding() {
        return this.randomSelection;
    }

    @Override
    public long getSize() {
        return this.cachedEntityList.size();
    }

    @Override
    public Iterator<Object> iterator() {
        if (!this.randomSelection) {
            return this.cachedEntityList.iterator();
        }
        return new CachedListRandomIterator<Object>(this.cachedEntityList, this.workingRandom);
    }

    @Override
    public ListIterator<Object> listIterator() {
        if (!this.randomSelection) {
            return this.cachedEntityList.listIterator();
        }
        throw new IllegalStateException("The selector (" + this + ") does not support a ListIterator with randomSelection (" + this.randomSelection + ").");
    }

    @Override
    public ListIterator<Object> listIterator(int index) {
        if (!this.randomSelection) {
            return this.cachedEntityList.listIterator(index);
        }
        throw new IllegalStateException("The selector (" + this + ") does not support a ListIterator with randomSelection (" + this.randomSelection + ").");
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.entityDescriptor.getPlanningEntityClass().getSimpleName() + ")";
    }
}

