/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.heuristic.selector.entity.decorator;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.drools.planner.core.domain.entity.PlanningEntityDescriptor;
import org.drools.planner.core.heuristic.selector.common.SelectionCacheLifecycleBridge;
import org.drools.planner.core.heuristic.selector.common.SelectionCacheLifecycleListener;
import org.drools.planner.core.heuristic.selector.common.SelectionCacheType;
import org.drools.planner.core.heuristic.selector.entity.AbstractEntitySelector;
import org.drools.planner.core.heuristic.selector.entity.EntitySelector;
import org.drools.planner.core.solver.scope.DefaultSolverScope;

public abstract class AbstractCachingEntitySelector
extends AbstractEntitySelector
implements SelectionCacheLifecycleListener {
    protected final EntitySelector childEntitySelector;
    protected final SelectionCacheType cacheType;
    protected List<Object> cachedEntityList = null;

    public AbstractCachingEntitySelector(EntitySelector childEntitySelector, SelectionCacheType cacheType) {
        this.childEntitySelector = childEntitySelector;
        this.cacheType = cacheType;
        if (childEntitySelector.isNeverEnding()) {
            throw new IllegalStateException("The selector (" + this + ") has a childEntitySelector (" + childEntitySelector + ") with neverEnding (" + childEntitySelector.isNeverEnding() + ").");
        }
        this.solverPhaseLifecycleSupport.addEventListener(childEntitySelector);
        if (cacheType.isNotCached()) {
            throw new IllegalArgumentException("The selector (" + this + ") does not support the cacheType (" + (Object)((Object)cacheType) + ").");
        }
        this.solverPhaseLifecycleSupport.addEventListener(new SelectionCacheLifecycleBridge(cacheType, this));
    }

    public EntitySelector getChildEntitySelector() {
        return this.childEntitySelector;
    }

    @Override
    public SelectionCacheType getCacheType() {
        return this.cacheType;
    }

    @Override
    public void constructCache(DefaultSolverScope solverScope) {
        long childSize = this.childEntitySelector.getSize();
        if (childSize > Integer.MAX_VALUE) {
            throw new IllegalStateException("The selector (" + this + ") has a childEntitySelector (" + this.childEntitySelector + ") with childSize (" + childSize + ") which is higher than Integer.MAX_VALUE.");
        }
        this.cachedEntityList = new ArrayList<Object>((int)childSize);
        CollectionUtils.addAll(this.cachedEntityList, this.childEntitySelector.iterator());
        this.logger.trace("    Created cachedEntityList with size ({}) in entitySelector({}).", (Object)this.cachedEntityList.size(), (Object)this);
    }

    @Override
    public void disposeCache(DefaultSolverScope solverScope) {
        this.cachedEntityList = null;
    }

    @Override
    public PlanningEntityDescriptor getEntityDescriptor() {
        return this.childEntitySelector.getEntityDescriptor();
    }

    @Override
    public boolean isContinuous() {
        return false;
    }

    @Override
    public long getSize() {
        return this.cachedEntityList.size();
    }
}

