/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.heuristic.selector.value;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.drools.planner.core.domain.variable.PlanningVariableDescriptor;
import org.drools.planner.core.heuristic.selector.common.SelectionCacheLifecycleBridge;
import org.drools.planner.core.heuristic.selector.common.SelectionCacheLifecycleListener;
import org.drools.planner.core.heuristic.selector.common.SelectionCacheType;
import org.drools.planner.core.heuristic.selector.common.iterator.CachedListRandomIterator;
import org.drools.planner.core.heuristic.selector.value.AbstractValueSelector;
import org.drools.planner.core.heuristic.selector.value.EntityIndependentValueSelector;
import org.drools.planner.core.solver.scope.DefaultSolverScope;

public class FromSolutionPropertyValueSelector
extends AbstractValueSelector
implements EntityIndependentValueSelector,
SelectionCacheLifecycleListener {
    protected final PlanningVariableDescriptor variableDescriptor;
    protected final SelectionCacheType cacheType;
    protected final boolean randomSelection;
    protected List<Object> cachedValueList = null;

    public FromSolutionPropertyValueSelector(PlanningVariableDescriptor variableDescriptor, SelectionCacheType cacheType, boolean randomSelection) {
        this.variableDescriptor = variableDescriptor;
        this.cacheType = cacheType;
        this.randomSelection = randomSelection;
        if (cacheType.isNotCached()) {
            throw new IllegalArgumentException("The selector (" + this + ") does not support the cacheType (" + (Object)((Object)cacheType) + ").");
        }
        this.solverPhaseLifecycleSupport.addEventListener(new SelectionCacheLifecycleBridge(cacheType, this));
    }

    @Override
    public PlanningVariableDescriptor getVariableDescriptor() {
        return this.variableDescriptor;
    }

    @Override
    public SelectionCacheType getCacheType() {
        return this.cacheType;
    }

    @Override
    public void constructCache(DefaultSolverScope solverScope) {
        Collection<?> planningValues = this.variableDescriptor.extractAllPlanningValues(solverScope.getWorkingSolution());
        this.cachedValueList = new ArrayList<Object>(planningValues.size() + 1);
        this.cachedValueList.addAll(planningValues);
        if (this.variableDescriptor.isNullable()) {
            this.cachedValueList.add(null);
        }
    }

    @Override
    public void disposeCache(DefaultSolverScope solverScope) {
        this.cachedValueList = null;
    }

    @Override
    public boolean isContinuous() {
        return this.variableDescriptor.isContinuous();
    }

    @Override
    public boolean isNeverEnding() {
        return this.randomSelection || this.isContinuous();
    }

    @Override
    public long getSize(Object entity) {
        return this.getSize();
    }

    @Override
    public long getSize() {
        return this.cachedValueList.size();
    }

    @Override
    public Iterator<Object> iterator(Object entity) {
        return this.iterator();
    }

    @Override
    public Iterator<Object> iterator() {
        if (!this.randomSelection) {
            return this.cachedValueList.iterator();
        }
        return new CachedListRandomIterator<Object>(this.cachedValueList, this.workingRandom);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.variableDescriptor.getVariableName() + ")";
    }
}

