/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.localsearch;

import org.drools.planner.core.localsearch.LocalSearchSolverPhase;
import org.drools.planner.core.localsearch.decider.Decider;
import org.drools.planner.core.localsearch.event.LocalSearchSolverPhaseLifecycleListener;
import org.drools.planner.core.localsearch.scope.LocalSearchSolverPhaseScope;
import org.drools.planner.core.localsearch.scope.LocalSearchStepScope;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.phase.AbstractSolverPhase;
import org.drools.planner.core.solver.scope.DefaultSolverScope;

public class DefaultLocalSearchSolverPhase
extends AbstractSolverPhase
implements LocalSearchSolverPhase,
LocalSearchSolverPhaseLifecycleListener {
    protected Decider decider;
    protected boolean assertStepScoreIsUncorrupted = false;

    public Decider getDecider() {
        return this.decider;
    }

    public void setDecider(Decider decider) {
        this.decider = decider;
        this.decider.setLocalSearchSolverPhase(this);
    }

    public void setAssertStepScoreIsUncorrupted(boolean assertStepScoreIsUncorrupted) {
        this.assertStepScoreIsUncorrupted = assertStepScoreIsUncorrupted;
    }

    @Override
    public void solve(DefaultSolverScope solverScope) {
        LocalSearchSolverPhaseScope phaseScope = new LocalSearchSolverPhaseScope(solverScope);
        this.phaseStarted(phaseScope);
        LocalSearchStepScope stepScope = this.createNextStepScope(phaseScope, null);
        while (!this.termination.isPhaseTerminated(phaseScope)) {
            stepScope.setTimeGradient(this.termination.calculatePhaseTimeGradient(phaseScope));
            this.stepStarted(stepScope);
            this.decider.decideNextStep(stepScope);
            Move nextStep = stepScope.getStep();
            if (nextStep == null) {
                if (this.termination.isPhaseTerminated(phaseScope)) {
                    this.logger.trace("    Step index ({}), time spend ({}) terminated without picking a nextStep.", (Object)stepScope.getStepIndex(), (Object)stepScope.getPhaseScope().calculateSolverTimeMillisSpend());
                    break;
                }
                if (stepScope.getSelectedMoveCount() == 0L) {
                    this.logger.warn("    No doable selected move at step index ({}), time spend ({}). Terminating phase early.", (Object)stepScope.getStepIndex(), (Object)stepScope.getPhaseScope().calculateSolverTimeMillisSpend());
                    break;
                }
                throw new IllegalStateException("The step index (" + stepScope.getStepIndex() + ") has accepted/selected move count (" + stepScope.getAcceptedMoveCount() + "/" + stepScope.getSelectedMoveCount() + ") but failed to pick a nextStep (" + nextStep + ").");
            }
            nextStep.doMove(stepScope.getScoreDirector());
            phaseScope.getWorkingSolution().setScore(stepScope.getScore());
            if (this.assertStepScoreIsUncorrupted) {
                phaseScope.assertWorkingScoreFromScratch(stepScope.getScore());
                phaseScope.assertExpectedWorkingScore(stepScope.getScore());
            }
            this.stepEnded(stepScope);
            stepScope = this.createNextStepScope(phaseScope, stepScope);
        }
        this.phaseEnded(phaseScope);
    }

    private LocalSearchStepScope createNextStepScope(LocalSearchSolverPhaseScope phaseScope, LocalSearchStepScope completedStepScope) {
        if (completedStepScope == null) {
            completedStepScope = new LocalSearchStepScope(phaseScope);
            completedStepScope.setScore(phaseScope.getStartingScore());
            completedStepScope.setStepIndex(-1);
            completedStepScope.setTimeGradient(0.0);
        }
        phaseScope.setLastCompletedStepScope(completedStepScope);
        LocalSearchStepScope stepScope = new LocalSearchStepScope(phaseScope);
        stepScope.setStepIndex(completedStepScope.getStepIndex() + 1);
        return stepScope;
    }

    @Override
    public void solvingStarted(DefaultSolverScope solverScope) {
        super.solvingStarted(solverScope);
        this.decider.solvingStarted(solverScope);
    }

    @Override
    public void phaseStarted(LocalSearchSolverPhaseScope phaseScope) {
        super.phaseStarted(phaseScope);
        this.decider.phaseStarted(phaseScope);
        if (!phaseScope.getScoreDirector().isWorkingSolutionInitialized()) {
            throw new IllegalStateException("Phase localSearch started with an uninitialized Solution. First initialize the Solution. For example, run a phase constructionHeuristic first.");
        }
    }

    @Override
    public void stepStarted(LocalSearchStepScope stepScope) {
        super.stepStarted(stepScope);
        this.decider.stepStarted(stepScope);
    }

    @Override
    public void stepEnded(LocalSearchStepScope stepScope) {
        super.stepEnded(stepScope);
        this.decider.stepEnded(stepScope);
        LocalSearchSolverPhaseScope localSearchSolverPhaseScope = stepScope.getPhaseScope();
        if (this.logger.isDebugEnabled()) {
            long timeMillisSpend = localSearchSolverPhaseScope.calculateSolverTimeMillisSpend();
            this.logger.debug("    Step index ({}), time spend ({}), score ({}), {} best score ({}), accepted/selected move count ({}/{}) for picked step ({}).", new Object[]{stepScope.getStepIndex(), timeMillisSpend, stepScope.getScore(), stepScope.getBestScoreImproved() != false ? "new" : "   ", localSearchSolverPhaseScope.getBestScore(), stepScope.getAcceptedMoveCount(), stepScope.getSelectedMoveCount(), stepScope.getStepString()});
        }
    }

    @Override
    public void phaseEnded(LocalSearchSolverPhaseScope phaseScope) {
        super.phaseEnded(phaseScope);
        this.decider.phaseEnded(phaseScope);
        this.logger.info("Phase ({}) localSearch ended: step total ({}), time spend ({}), best score ({}).", new Object[]{this.phaseIndex, phaseScope.getLastCompletedStepScope().getStepIndex() + 1, phaseScope.calculateSolverTimeMillisSpend(), phaseScope.getBestScore()});
    }

    @Override
    public void solvingEnded(DefaultSolverScope solverScope) {
        super.solvingEnded(solverScope);
        this.decider.solvingEnded(solverScope);
    }
}

