/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.localsearch.decider.acceptor;

import java.util.List;
import org.drools.planner.core.localsearch.decider.acceptor.AbstractAcceptor;
import org.drools.planner.core.localsearch.decider.acceptor.Acceptor;
import org.drools.planner.core.localsearch.scope.LocalSearchMoveScope;
import org.drools.planner.core.localsearch.scope.LocalSearchSolverPhaseScope;
import org.drools.planner.core.localsearch.scope.LocalSearchStepScope;
import org.drools.planner.core.solver.scope.DefaultSolverScope;

public class CompositeAcceptor
extends AbstractAcceptor {
    protected List<Acceptor> acceptorList;

    public void setAcceptorList(List<Acceptor> acceptorList) {
        this.acceptorList = acceptorList;
    }

    @Override
    public void solvingStarted(DefaultSolverScope solverScope) {
        for (Acceptor acceptor : this.acceptorList) {
            acceptor.solvingStarted(solverScope);
        }
    }

    @Override
    public void phaseStarted(LocalSearchSolverPhaseScope phaseScope) {
        for (Acceptor acceptor : this.acceptorList) {
            acceptor.phaseStarted(phaseScope);
        }
    }

    @Override
    public void stepStarted(LocalSearchStepScope stepScope) {
        for (Acceptor acceptor : this.acceptorList) {
            acceptor.stepStarted(stepScope);
        }
    }

    @Override
    public boolean isAccepted(LocalSearchMoveScope moveScope) {
        for (Acceptor acceptor : this.acceptorList) {
            boolean accepted = acceptor.isAccepted(moveScope);
            if (accepted) continue;
            return false;
        }
        return true;
    }

    @Override
    public void stepEnded(LocalSearchStepScope stepScope) {
        for (Acceptor acceptor : this.acceptorList) {
            acceptor.stepEnded(stepScope);
        }
    }

    @Override
    public void phaseEnded(LocalSearchSolverPhaseScope phaseScope) {
        for (Acceptor acceptor : this.acceptorList) {
            acceptor.phaseEnded(phaseScope);
        }
    }

    @Override
    public void solvingEnded(DefaultSolverScope solverScope) {
        for (Acceptor acceptor : this.acceptorList) {
            acceptor.solvingEnded(solverScope);
        }
    }
}

