/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.score.buildin.hardsoftlong;

import org.drools.planner.core.score.Score;
import org.drools.planner.core.score.buildin.hardsoftlong.HardSoftLongScore;
import org.drools.planner.core.score.buildin.hardsoftlong.HardSoftLongScoreHolder;
import org.drools.planner.core.score.definition.AbstractScoreDefinition;
import org.drools.planner.core.score.holder.ScoreHolder;

public class HardSoftLongScoreDefinition
extends AbstractScoreDefinition<HardSoftLongScore> {
    private double hardScoreTimeGradientWeight = 0.75;
    private HardSoftLongScore perfectMaximumScore = HardSoftLongScore.valueOf(0L, 0L);
    private HardSoftLongScore perfectMinimumScore = HardSoftLongScore.valueOf(Long.MIN_VALUE, Long.MIN_VALUE);

    public void setHardScoreTimeGradientWeight(double hardScoreTimeGradientWeight) {
        this.hardScoreTimeGradientWeight = hardScoreTimeGradientWeight;
        if (hardScoreTimeGradientWeight < 0.0 || hardScoreTimeGradientWeight > 1.0) {
            throw new IllegalArgumentException("Property hardScoreTimeGradientWeight (" + hardScoreTimeGradientWeight + ") must be greater or equal to 0.0 and smaller or equal to 1.0.");
        }
    }

    public void setPerfectMaximumScore(HardSoftLongScore perfectMaximumScore) {
        this.perfectMaximumScore = perfectMaximumScore;
    }

    public void setPerfectMinimumScore(HardSoftLongScore perfectMinimumScore) {
        this.perfectMinimumScore = perfectMinimumScore;
    }

    @Override
    public HardSoftLongScore getPerfectMaximumScore() {
        return this.perfectMaximumScore;
    }

    @Override
    public HardSoftLongScore getPerfectMinimumScore() {
        return this.perfectMinimumScore;
    }

    @Override
    public Class<HardSoftLongScore> getScoreClass() {
        return HardSoftLongScore.class;
    }

    @Override
    public Score parseScore(String scoreString) {
        return HardSoftLongScore.parseScore(scoreString);
    }

    @Override
    public double calculateTimeGradient(HardSoftLongScore startScore, HardSoftLongScore endScore, HardSoftLongScore score) {
        if (score.compareTo(endScore) > 0) {
            return 1.0;
        }
        if (score.compareTo(startScore) < 0) {
            return 0.0;
        }
        double softScoreTimeGradientWeight = 1.0 - this.hardScoreTimeGradientWeight;
        double timeGradient = 0.0;
        if (startScore.getHardScore() == endScore.getHardScore()) {
            timeGradient += this.hardScoreTimeGradientWeight;
        } else {
            long hardScoreTotal = endScore.getHardScore() - startScore.getHardScore();
            long hardScoreDelta = score.getHardScore() - startScore.getHardScore();
            double hardTimeGradient = (double)hardScoreDelta / (double)hardScoreTotal;
            timeGradient += hardTimeGradient * this.hardScoreTimeGradientWeight;
        }
        if (score.getSoftScore() >= endScore.getSoftScore()) {
            timeGradient += softScoreTimeGradientWeight;
        } else if (score.getSoftScore() > startScore.getSoftScore()) {
            long softScoreTotal = endScore.getSoftScore() - startScore.getSoftScore();
            long softScoreDelta = score.getSoftScore() - startScore.getSoftScore();
            double softTimeGradient = (double)softScoreDelta / (double)softScoreTotal;
            timeGradient += softTimeGradient * softScoreTimeGradientWeight;
        }
        return timeGradient;
    }

    @Override
    public ScoreHolder buildScoreHolder() {
        return new HardSoftLongScoreHolder();
    }
}

