/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.score.buildin.simplebigdecimal;

import java.math.BigDecimal;
import org.drools.planner.core.score.Score;
import org.drools.planner.core.score.buildin.simplebigdecimal.SimpleBigDecimalScore;
import org.drools.planner.core.score.buildin.simplebigdecimal.SimpleBigDecimalScoreHolder;
import org.drools.planner.core.score.definition.AbstractScoreDefinition;
import org.drools.planner.core.score.holder.ScoreHolder;

public class SimpleBigDecimalScoreDefinition
extends AbstractScoreDefinition<SimpleBigDecimalScore> {
    private SimpleBigDecimalScore perfectMaximumScore = SimpleBigDecimalScore.valueOf(BigDecimal.ZERO);
    private SimpleBigDecimalScore perfectMinimumScore = null;

    public void setPerfectMaximumScore(SimpleBigDecimalScore perfectMaximumScore) {
        this.perfectMaximumScore = perfectMaximumScore;
    }

    public void setPerfectMinimumScore(SimpleBigDecimalScore perfectMinimumScore) {
        this.perfectMinimumScore = perfectMinimumScore;
    }

    @Override
    public SimpleBigDecimalScore getPerfectMaximumScore() {
        return this.perfectMaximumScore;
    }

    @Override
    public SimpleBigDecimalScore getPerfectMinimumScore() {
        return this.perfectMinimumScore;
    }

    @Override
    public Class<SimpleBigDecimalScore> getScoreClass() {
        return SimpleBigDecimalScore.class;
    }

    @Override
    public Score parseScore(String scoreString) {
        return SimpleBigDecimalScore.parseScore(scoreString);
    }

    @Override
    public double calculateTimeGradient(SimpleBigDecimalScore startScore, SimpleBigDecimalScore endScore, SimpleBigDecimalScore score) {
        if (score.getScore().compareTo(endScore.getScore()) >= 0) {
            return 1.0;
        }
        if (startScore.getScore().compareTo(score.getScore()) >= 0) {
            return 0.0;
        }
        BigDecimal scoreTotal = endScore.getScore().subtract(startScore.getScore());
        BigDecimal scoreDelta = score.getScore().subtract(startScore.getScore());
        return scoreDelta.divide(scoreTotal).doubleValue();
    }

    @Override
    public ScoreHolder buildScoreHolder() {
        return new SimpleBigDecimalScoreHolder();
    }
}

