/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.solver;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.drools.planner.core.phase.AbstractSolverPhaseScope;
import org.drools.planner.core.solver.ProblemFactChange;
import org.drools.planner.core.solver.scope.DefaultSolverScope;
import org.drools.planner.core.termination.AbstractTermination;

public class BasicPlumbingTermination
extends AbstractTermination {
    protected AtomicBoolean terminatedEarly = new AtomicBoolean(false);
    protected BlockingQueue<ProblemFactChange> problemFactChangeQueue = new LinkedBlockingQueue<ProblemFactChange>();

    public void resetTerminateEarly() {
        this.terminatedEarly.set(false);
    }

    public boolean terminateEarly() {
        boolean terminationEarlySuccessful;
        boolean bl = terminationEarlySuccessful = !this.terminatedEarly.getAndSet(true);
        if (terminationEarlySuccessful) {
            this.logger.info("Terminating solver early.");
        }
        return terminationEarlySuccessful;
    }

    public boolean isTerminateEarly() {
        return this.terminatedEarly.get();
    }

    public boolean addProblemFactChange(ProblemFactChange problemFactChange) {
        return this.problemFactChangeQueue.add(problemFactChange);
    }

    public BlockingQueue<ProblemFactChange> getProblemFactChangeQueue() {
        return this.problemFactChangeQueue;
    }

    @Override
    public boolean isSolverTerminated(DefaultSolverScope solverScope) {
        return this.terminatedEarly.get() || !this.problemFactChangeQueue.isEmpty();
    }

    @Override
    public boolean isPhaseTerminated(AbstractSolverPhaseScope phaseScope) {
        throw new UnsupportedOperationException("BasicPlumbingTermination can only be used for solver termination.");
    }

    @Override
    public double calculateSolverTimeGradient(DefaultSolverScope solverScope) {
        return -1.0;
    }

    @Override
    public double calculatePhaseTimeGradient(AbstractSolverPhaseScope phaseScope) {
        throw new UnsupportedOperationException("BasicPlumbingTermination can only be used for solver termination.");
    }
}

