/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.config.heuristic.selector.entity;

import org.drools.planner.config.EnvironmentMode;
import org.drools.planner.config.heuristic.selector.common.SelectionOrder;
import org.drools.planner.config.heuristic.selector.entity.EntitySelectorConfig;
import org.drools.planner.core.domain.solution.SolutionDescriptor;
import org.drools.planner.core.heuristic.selector.common.SelectionCacheType;
import org.drools.planner.core.heuristic.selector.entity.EntitySelector;
import org.drools.planner.core.heuristic.selector.entity.FromSolutionEntitySelector;
import org.drools.planner.core.heuristic.selector.entity.decorator.ShufflingEntitySelector;
import org.drools.planner.core.testdata.domain.TestdataSolution;
import org.drools.planner.core.testdata.util.PlannerAssert;
import org.junit.Test;

public class EntitySelectorConfigTest {
    @Test
    public void phaseOriginal() {
        SolutionDescriptor solutionDescriptor = TestdataSolution.buildSolutionDescriptor();
        EntitySelectorConfig entitySelectorConfig = new EntitySelectorConfig();
        entitySelectorConfig.setCacheType(SelectionCacheType.PHASE);
        entitySelectorConfig.setSelectionOrder(SelectionOrder.ORIGINAL);
        EntitySelector entitySelector = entitySelectorConfig.buildEntitySelector(EnvironmentMode.REPRODUCIBLE, solutionDescriptor, SelectionCacheType.JUST_IN_TIME, SelectionOrder.RANDOM);
        PlannerAssert.assertInstanceOf(FromSolutionEntitySelector.class, entitySelector);
        PlannerAssert.assertNotInstanceOf(ShufflingEntitySelector.class, entitySelector);
        PlannerAssert.assertEquals((Object)SelectionCacheType.PHASE, (Object)entitySelector.getCacheType());
    }

    @Test
    public void stepOriginal() {
        SolutionDescriptor solutionDescriptor = TestdataSolution.buildSolutionDescriptor();
        EntitySelectorConfig entitySelectorConfig = new EntitySelectorConfig();
        entitySelectorConfig.setCacheType(SelectionCacheType.STEP);
        entitySelectorConfig.setSelectionOrder(SelectionOrder.ORIGINAL);
        EntitySelector entitySelector = entitySelectorConfig.buildEntitySelector(EnvironmentMode.REPRODUCIBLE, solutionDescriptor, SelectionCacheType.JUST_IN_TIME, SelectionOrder.RANDOM);
        PlannerAssert.assertInstanceOf(FromSolutionEntitySelector.class, entitySelector);
        PlannerAssert.assertNotInstanceOf(ShufflingEntitySelector.class, entitySelector);
        PlannerAssert.assertEquals((Object)SelectionCacheType.STEP, (Object)entitySelector.getCacheType());
    }

    @Test
    public void justInTimeOriginal() {
        SolutionDescriptor solutionDescriptor = TestdataSolution.buildSolutionDescriptor();
        EntitySelectorConfig entitySelectorConfig = new EntitySelectorConfig();
        entitySelectorConfig.setCacheType(SelectionCacheType.JUST_IN_TIME);
        entitySelectorConfig.setSelectionOrder(SelectionOrder.ORIGINAL);
        EntitySelector entitySelector = entitySelectorConfig.buildEntitySelector(EnvironmentMode.REPRODUCIBLE, solutionDescriptor, SelectionCacheType.JUST_IN_TIME, SelectionOrder.RANDOM);
        PlannerAssert.assertInstanceOf(FromSolutionEntitySelector.class, entitySelector);
    }

    @Test
    public void phaseRandom() {
        SolutionDescriptor solutionDescriptor = TestdataSolution.buildSolutionDescriptor();
        EntitySelectorConfig entitySelectorConfig = new EntitySelectorConfig();
        entitySelectorConfig.setCacheType(SelectionCacheType.PHASE);
        entitySelectorConfig.setSelectionOrder(SelectionOrder.RANDOM);
        EntitySelector entitySelector = entitySelectorConfig.buildEntitySelector(EnvironmentMode.REPRODUCIBLE, solutionDescriptor, SelectionCacheType.JUST_IN_TIME, SelectionOrder.RANDOM);
        PlannerAssert.assertInstanceOf(FromSolutionEntitySelector.class, entitySelector);
        PlannerAssert.assertNotInstanceOf(ShufflingEntitySelector.class, entitySelector);
        PlannerAssert.assertEquals((Object)SelectionCacheType.PHASE, (Object)entitySelector.getCacheType());
    }

    @Test
    public void stepRandom() {
        SolutionDescriptor solutionDescriptor = TestdataSolution.buildSolutionDescriptor();
        EntitySelectorConfig entitySelectorConfig = new EntitySelectorConfig();
        entitySelectorConfig.setCacheType(SelectionCacheType.STEP);
        entitySelectorConfig.setSelectionOrder(SelectionOrder.RANDOM);
        EntitySelector entitySelector = entitySelectorConfig.buildEntitySelector(EnvironmentMode.REPRODUCIBLE, solutionDescriptor, SelectionCacheType.JUST_IN_TIME, SelectionOrder.RANDOM);
        PlannerAssert.assertInstanceOf(FromSolutionEntitySelector.class, entitySelector);
        PlannerAssert.assertNotInstanceOf(ShufflingEntitySelector.class, entitySelector);
        PlannerAssert.assertEquals((Object)SelectionCacheType.STEP, (Object)entitySelector.getCacheType());
    }

    @Test
    public void justInTimeRandom() {
        SolutionDescriptor solutionDescriptor = TestdataSolution.buildSolutionDescriptor();
        EntitySelectorConfig entitySelectorConfig = new EntitySelectorConfig();
        entitySelectorConfig.setCacheType(SelectionCacheType.JUST_IN_TIME);
        entitySelectorConfig.setSelectionOrder(SelectionOrder.RANDOM);
        EntitySelector entitySelector = entitySelectorConfig.buildEntitySelector(EnvironmentMode.REPRODUCIBLE, solutionDescriptor, SelectionCacheType.JUST_IN_TIME, SelectionOrder.RANDOM);
        PlannerAssert.assertInstanceOf(FromSolutionEntitySelector.class, entitySelector);
    }

    @Test
    public void phaseShuffled() {
        SolutionDescriptor solutionDescriptor = TestdataSolution.buildSolutionDescriptor();
        EntitySelectorConfig entitySelectorConfig = new EntitySelectorConfig();
        entitySelectorConfig.setCacheType(SelectionCacheType.PHASE);
        entitySelectorConfig.setSelectionOrder(SelectionOrder.SHUFFLED);
        EntitySelector entitySelector = entitySelectorConfig.buildEntitySelector(EnvironmentMode.REPRODUCIBLE, solutionDescriptor, SelectionCacheType.JUST_IN_TIME, SelectionOrder.RANDOM);
        PlannerAssert.assertInstanceOf(ShufflingEntitySelector.class, entitySelector);
        PlannerAssert.assertInstanceOf(FromSolutionEntitySelector.class, ((ShufflingEntitySelector)entitySelector).getChildEntitySelector());
        PlannerAssert.assertEquals((Object)SelectionCacheType.PHASE, (Object)entitySelector.getCacheType());
    }

    @Test
    public void stepShuffled() {
        SolutionDescriptor solutionDescriptor = TestdataSolution.buildSolutionDescriptor();
        EntitySelectorConfig entitySelectorConfig = new EntitySelectorConfig();
        entitySelectorConfig.setCacheType(SelectionCacheType.STEP);
        entitySelectorConfig.setSelectionOrder(SelectionOrder.SHUFFLED);
        EntitySelector entitySelector = entitySelectorConfig.buildEntitySelector(EnvironmentMode.REPRODUCIBLE, solutionDescriptor, SelectionCacheType.JUST_IN_TIME, SelectionOrder.RANDOM);
        PlannerAssert.assertInstanceOf(ShufflingEntitySelector.class, entitySelector);
        PlannerAssert.assertInstanceOf(FromSolutionEntitySelector.class, ((ShufflingEntitySelector)entitySelector).getChildEntitySelector());
        PlannerAssert.assertEquals((Object)SelectionCacheType.STEP, (Object)entitySelector.getCacheType());
    }

    @Test(expected=IllegalArgumentException.class)
    public void justInTimeShuffled() {
        SolutionDescriptor solutionDescriptor = TestdataSolution.buildSolutionDescriptor();
        EntitySelectorConfig entitySelectorConfig = new EntitySelectorConfig();
        entitySelectorConfig.setCacheType(SelectionCacheType.JUST_IN_TIME);
        entitySelectorConfig.setSelectionOrder(SelectionOrder.SHUFFLED);
        EntitySelector entitySelector = entitySelectorConfig.buildEntitySelector(EnvironmentMode.REPRODUCIBLE, solutionDescriptor, SelectionCacheType.JUST_IN_TIME, SelectionOrder.RANDOM);
    }
}

