/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.config.heuristic.selector.move;

import org.drools.planner.config.EnvironmentMode;
import org.drools.planner.config.heuristic.selector.common.SelectionOrder;
import org.drools.planner.config.heuristic.selector.move.MoveSelectorConfig;
import org.drools.planner.core.domain.solution.SolutionDescriptor;
import org.drools.planner.core.heuristic.selector.SelectorTestUtils;
import org.drools.planner.core.heuristic.selector.common.SelectionCacheType;
import org.drools.planner.core.heuristic.selector.move.MoveSelector;
import org.drools.planner.core.heuristic.selector.move.decorator.CachingMoveSelector;
import org.drools.planner.core.heuristic.selector.move.decorator.ShufflingMoveSelector;
import org.drools.planner.core.move.DummyMove;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.testdata.util.PlannerAssert;
import org.junit.Assert;
import org.junit.Test;

public class MoveSelectorConfigTest {
    @Test
    public void phaseOriginal() {
        SolutionDescriptor solutionDescriptor = SelectorTestUtils.mockSolutionDescriptor();
        final MoveSelector baseMoveSelector = SelectorTestUtils.mockMoveSelector(DummyMove.class, new Move[0]);
        MoveSelectorConfig moveSelectorConfig = new MoveSelectorConfig(){

            protected MoveSelector buildBaseMoveSelector(EnvironmentMode environmentMode, SolutionDescriptor solutionDescriptor, SelectionCacheType minimumCacheType, boolean randomSelection) {
                Assert.assertEquals((Object)SelectionCacheType.PHASE, (Object)minimumCacheType);
                Assert.assertEquals((Object)false, (Object)randomSelection);
                return baseMoveSelector;
            }
        };
        moveSelectorConfig.setCacheType(SelectionCacheType.PHASE);
        moveSelectorConfig.setSelectionOrder(SelectionOrder.ORIGINAL);
        MoveSelector moveSelector = moveSelectorConfig.buildMoveSelector(EnvironmentMode.REPRODUCIBLE, solutionDescriptor, SelectionCacheType.JUST_IN_TIME, SelectionOrder.RANDOM);
        PlannerAssert.assertInstanceOf(CachingMoveSelector.class, moveSelector);
        PlannerAssert.assertNotInstanceOf(ShufflingMoveSelector.class, moveSelector);
        Assert.assertEquals((Object)SelectionCacheType.PHASE, (Object)moveSelector.getCacheType());
        PlannerAssert.assertSame((Object)baseMoveSelector, (Object)((CachingMoveSelector)moveSelector).getChildMoveSelector());
    }

    @Test
    public void stepOriginal() {
        SolutionDescriptor solutionDescriptor = SelectorTestUtils.mockSolutionDescriptor();
        final MoveSelector baseMoveSelector = SelectorTestUtils.mockMoveSelector(DummyMove.class, new Move[0]);
        MoveSelectorConfig moveSelectorConfig = new MoveSelectorConfig(){

            protected MoveSelector buildBaseMoveSelector(EnvironmentMode environmentMode, SolutionDescriptor solutionDescriptor, SelectionCacheType minimumCacheType, boolean randomSelection) {
                Assert.assertEquals((Object)SelectionCacheType.STEP, (Object)minimumCacheType);
                Assert.assertEquals((Object)false, (Object)randomSelection);
                return baseMoveSelector;
            }
        };
        moveSelectorConfig.setCacheType(SelectionCacheType.STEP);
        moveSelectorConfig.setSelectionOrder(SelectionOrder.ORIGINAL);
        MoveSelector moveSelector = moveSelectorConfig.buildMoveSelector(EnvironmentMode.REPRODUCIBLE, solutionDescriptor, SelectionCacheType.JUST_IN_TIME, SelectionOrder.RANDOM);
        PlannerAssert.assertInstanceOf(CachingMoveSelector.class, moveSelector);
        PlannerAssert.assertNotInstanceOf(ShufflingMoveSelector.class, moveSelector);
        Assert.assertEquals((Object)SelectionCacheType.STEP, (Object)moveSelector.getCacheType());
        PlannerAssert.assertSame((Object)baseMoveSelector, (Object)((CachingMoveSelector)moveSelector).getChildMoveSelector());
    }

    @Test
    public void justInTimeOriginal() {
        SolutionDescriptor solutionDescriptor = SelectorTestUtils.mockSolutionDescriptor();
        final MoveSelector baseMoveSelector = SelectorTestUtils.mockMoveSelector(DummyMove.class, new Move[0]);
        MoveSelectorConfig moveSelectorConfig = new MoveSelectorConfig(){

            protected MoveSelector buildBaseMoveSelector(EnvironmentMode environmentMode, SolutionDescriptor solutionDescriptor, SelectionCacheType minimumCacheType, boolean randomSelection) {
                Assert.assertEquals((Object)SelectionCacheType.JUST_IN_TIME, (Object)minimumCacheType);
                Assert.assertEquals((Object)false, (Object)randomSelection);
                return baseMoveSelector;
            }
        };
        moveSelectorConfig.setCacheType(SelectionCacheType.JUST_IN_TIME);
        moveSelectorConfig.setSelectionOrder(SelectionOrder.ORIGINAL);
        MoveSelector moveSelector = moveSelectorConfig.buildMoveSelector(EnvironmentMode.REPRODUCIBLE, solutionDescriptor, SelectionCacheType.JUST_IN_TIME, SelectionOrder.RANDOM);
        PlannerAssert.assertSame((Object)baseMoveSelector, (Object)moveSelector);
        Assert.assertEquals((Object)SelectionCacheType.JUST_IN_TIME, (Object)moveSelector.getCacheType());
    }

    @Test
    public void phaseRandom() {
        SolutionDescriptor solutionDescriptor = SelectorTestUtils.mockSolutionDescriptor();
        final MoveSelector baseMoveSelector = SelectorTestUtils.mockMoveSelector(DummyMove.class, new Move[0]);
        MoveSelectorConfig moveSelectorConfig = new MoveSelectorConfig(){

            protected MoveSelector buildBaseMoveSelector(EnvironmentMode environmentMode, SolutionDescriptor solutionDescriptor, SelectionCacheType minimumCacheType, boolean randomSelection) {
                Assert.assertEquals((Object)SelectionCacheType.PHASE, (Object)minimumCacheType);
                Assert.assertEquals((Object)false, (Object)randomSelection);
                return baseMoveSelector;
            }
        };
        moveSelectorConfig.setCacheType(SelectionCacheType.PHASE);
        moveSelectorConfig.setSelectionOrder(SelectionOrder.RANDOM);
        MoveSelector moveSelector = moveSelectorConfig.buildMoveSelector(EnvironmentMode.REPRODUCIBLE, solutionDescriptor, SelectionCacheType.JUST_IN_TIME, SelectionOrder.RANDOM);
        PlannerAssert.assertInstanceOf(CachingMoveSelector.class, moveSelector);
        PlannerAssert.assertNotInstanceOf(ShufflingMoveSelector.class, moveSelector);
        Assert.assertEquals((Object)SelectionCacheType.PHASE, (Object)moveSelector.getCacheType());
        PlannerAssert.assertSame((Object)baseMoveSelector, (Object)((CachingMoveSelector)moveSelector).getChildMoveSelector());
    }

    @Test
    public void stepRandom() {
        SolutionDescriptor solutionDescriptor = SelectorTestUtils.mockSolutionDescriptor();
        final MoveSelector baseMoveSelector = SelectorTestUtils.mockMoveSelector(DummyMove.class, new Move[0]);
        MoveSelectorConfig moveSelectorConfig = new MoveSelectorConfig(){

            protected MoveSelector buildBaseMoveSelector(EnvironmentMode environmentMode, SolutionDescriptor solutionDescriptor, SelectionCacheType minimumCacheType, boolean randomSelection) {
                Assert.assertEquals((Object)SelectionCacheType.STEP, (Object)minimumCacheType);
                Assert.assertEquals((Object)false, (Object)randomSelection);
                return baseMoveSelector;
            }
        };
        moveSelectorConfig.setCacheType(SelectionCacheType.STEP);
        moveSelectorConfig.setSelectionOrder(SelectionOrder.RANDOM);
        MoveSelector moveSelector = moveSelectorConfig.buildMoveSelector(EnvironmentMode.REPRODUCIBLE, solutionDescriptor, SelectionCacheType.JUST_IN_TIME, SelectionOrder.RANDOM);
        PlannerAssert.assertInstanceOf(CachingMoveSelector.class, moveSelector);
        PlannerAssert.assertNotInstanceOf(ShufflingMoveSelector.class, moveSelector);
        Assert.assertEquals((Object)SelectionCacheType.STEP, (Object)moveSelector.getCacheType());
        PlannerAssert.assertSame((Object)baseMoveSelector, (Object)((CachingMoveSelector)moveSelector).getChildMoveSelector());
    }

    @Test
    public void justInTimeRandom() {
        SolutionDescriptor solutionDescriptor = SelectorTestUtils.mockSolutionDescriptor();
        final MoveSelector baseMoveSelector = SelectorTestUtils.mockMoveSelector(DummyMove.class, new Move[0]);
        MoveSelectorConfig moveSelectorConfig = new MoveSelectorConfig(){

            protected MoveSelector buildBaseMoveSelector(EnvironmentMode environmentMode, SolutionDescriptor solutionDescriptor, SelectionCacheType minimumCacheType, boolean randomSelection) {
                Assert.assertEquals((Object)SelectionCacheType.JUST_IN_TIME, (Object)minimumCacheType);
                Assert.assertEquals((Object)true, (Object)randomSelection);
                return baseMoveSelector;
            }
        };
        moveSelectorConfig.setCacheType(SelectionCacheType.JUST_IN_TIME);
        moveSelectorConfig.setSelectionOrder(SelectionOrder.RANDOM);
        MoveSelector moveSelector = moveSelectorConfig.buildMoveSelector(EnvironmentMode.REPRODUCIBLE, solutionDescriptor, SelectionCacheType.JUST_IN_TIME, SelectionOrder.RANDOM);
        PlannerAssert.assertSame((Object)baseMoveSelector, (Object)moveSelector);
        Assert.assertEquals((Object)SelectionCacheType.JUST_IN_TIME, (Object)moveSelector.getCacheType());
    }

    @Test
    public void phaseShuffled() {
        SolutionDescriptor solutionDescriptor = SelectorTestUtils.mockSolutionDescriptor();
        final MoveSelector baseMoveSelector = SelectorTestUtils.mockMoveSelector(DummyMove.class, new Move[0]);
        MoveSelectorConfig moveSelectorConfig = new MoveSelectorConfig(){

            protected MoveSelector buildBaseMoveSelector(EnvironmentMode environmentMode, SolutionDescriptor solutionDescriptor, SelectionCacheType minimumCacheType, boolean randomSelection) {
                Assert.assertEquals((Object)SelectionCacheType.PHASE, (Object)minimumCacheType);
                Assert.assertEquals((Object)false, (Object)randomSelection);
                return baseMoveSelector;
            }
        };
        moveSelectorConfig.setCacheType(SelectionCacheType.PHASE);
        moveSelectorConfig.setSelectionOrder(SelectionOrder.SHUFFLED);
        MoveSelector moveSelector = moveSelectorConfig.buildMoveSelector(EnvironmentMode.REPRODUCIBLE, solutionDescriptor, SelectionCacheType.JUST_IN_TIME, SelectionOrder.RANDOM);
        PlannerAssert.assertInstanceOf(ShufflingMoveSelector.class, moveSelector);
        Assert.assertEquals((Object)SelectionCacheType.PHASE, (Object)moveSelector.getCacheType());
        PlannerAssert.assertSame((Object)baseMoveSelector, (Object)((ShufflingMoveSelector)moveSelector).getChildMoveSelector());
    }

    @Test
    public void stepShuffled() {
        SolutionDescriptor solutionDescriptor = SelectorTestUtils.mockSolutionDescriptor();
        final MoveSelector baseMoveSelector = SelectorTestUtils.mockMoveSelector(DummyMove.class, new Move[0]);
        MoveSelectorConfig moveSelectorConfig = new MoveSelectorConfig(){

            protected MoveSelector buildBaseMoveSelector(EnvironmentMode environmentMode, SolutionDescriptor solutionDescriptor, SelectionCacheType minimumCacheType, boolean randomSelection) {
                Assert.assertEquals((Object)SelectionCacheType.STEP, (Object)minimumCacheType);
                Assert.assertEquals((Object)false, (Object)randomSelection);
                return baseMoveSelector;
            }
        };
        moveSelectorConfig.setCacheType(SelectionCacheType.STEP);
        moveSelectorConfig.setSelectionOrder(SelectionOrder.SHUFFLED);
        MoveSelector moveSelector = moveSelectorConfig.buildMoveSelector(EnvironmentMode.REPRODUCIBLE, solutionDescriptor, SelectionCacheType.JUST_IN_TIME, SelectionOrder.RANDOM);
        PlannerAssert.assertInstanceOf(ShufflingMoveSelector.class, moveSelector);
        Assert.assertEquals((Object)SelectionCacheType.STEP, (Object)moveSelector.getCacheType());
        PlannerAssert.assertSame((Object)baseMoveSelector, (Object)((ShufflingMoveSelector)moveSelector).getChildMoveSelector());
    }

    @Test(expected=IllegalArgumentException.class)
    public void justInTimeShuffled() {
        SolutionDescriptor solutionDescriptor = SelectorTestUtils.mockSolutionDescriptor();
        final MoveSelector baseMoveSelector = SelectorTestUtils.mockMoveSelector(DummyMove.class, new Move[0]);
        MoveSelectorConfig moveSelectorConfig = new MoveSelectorConfig(){

            protected MoveSelector buildBaseMoveSelector(EnvironmentMode environmentMode, SolutionDescriptor solutionDescriptor, SelectionCacheType minimumCacheType, boolean randomSelection) {
                return baseMoveSelector;
            }
        };
        moveSelectorConfig.setCacheType(SelectionCacheType.JUST_IN_TIME);
        moveSelectorConfig.setSelectionOrder(SelectionOrder.SHUFFLED);
        MoveSelector moveSelector = moveSelectorConfig.buildMoveSelector(EnvironmentMode.REPRODUCIBLE, solutionDescriptor, SelectionCacheType.JUST_IN_TIME, SelectionOrder.RANDOM);
    }
}

