/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.domain.solution.cloner;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.drools.planner.api.domain.solution.cloner.SolutionCloner;
import org.drools.planner.core.domain.solution.SolutionDescriptor;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.core.testdata.domain.TestdataEntity;
import org.drools.planner.core.testdata.domain.TestdataSolution;
import org.drools.planner.core.testdata.domain.TestdataValue;
import org.drools.planner.core.testdata.domain.chained.TestdataChainedAnchor;
import org.drools.planner.core.testdata.domain.chained.TestdataChainedEntity;
import org.drools.planner.core.testdata.domain.chained.TestdataChainedObject;
import org.drools.planner.core.testdata.domain.chained.TestdataChainedSolution;
import org.drools.planner.core.testdata.domain.setbased.TestdataSetBasedEntity;
import org.drools.planner.core.testdata.domain.setbased.TestdataSetBasedSolution;
import org.drools.planner.core.testdata.util.PlannerAssert;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractSolutionClonerTest {
    protected abstract <Sol extends Solution> SolutionCloner<Sol> createSolutionCloner(SolutionDescriptor var1);

    @Test
    public void cloneSolution() {
        SolutionDescriptor solutionDescriptor = TestdataSolution.buildSolutionDescriptor();
        SolutionCloner cloner = this.createSolutionCloner(solutionDescriptor);
        TestdataValue val1 = new TestdataValue("1");
        TestdataValue val2 = new TestdataValue("2");
        TestdataValue val3 = new TestdataValue("3");
        TestdataEntity a = new TestdataEntity("a", val1);
        TestdataEntity b = new TestdataEntity("b", val1);
        TestdataEntity c = new TestdataEntity("c", val3);
        TestdataEntity d = new TestdataEntity("d", val3);
        TestdataSolution original = new TestdataSolution("solution");
        List<TestdataValue> valueList = Arrays.asList(val1, val2, val3);
        original.setValueList(valueList);
        List<TestdataEntity> originalEntityList = Arrays.asList(a, b, c, d);
        original.setEntityList(originalEntityList);
        TestdataSolution clone = (TestdataSolution)cloner.cloneSolution((Solution)original);
        Assert.assertNotSame((Object)original, (Object)clone);
        Assert.assertSame(valueList, clone.getValueList());
        List<TestdataEntity> cloneEntityList = clone.getEntityList();
        Assert.assertNotSame(originalEntityList, cloneEntityList);
        PlannerAssert.assertCode("solution", clone);
        Assert.assertEquals((long)4L, (long)cloneEntityList.size());
        TestdataEntity cloneA = cloneEntityList.get(0);
        TestdataEntity cloneB = cloneEntityList.get(1);
        TestdataEntity cloneC = cloneEntityList.get(2);
        TestdataEntity cloneD = cloneEntityList.get(3);
        this.assertEntityClone(a, cloneA, "a", "1");
        this.assertEntityClone(b, cloneB, "b", "1");
        this.assertEntityClone(c, cloneC, "c", "3");
        this.assertEntityClone(d, cloneD, "d", "3");
        b.setValue(val2);
        PlannerAssert.assertCode("2", b.getValue());
        PlannerAssert.assertCode("1", cloneB.getValue());
    }

    private void assertEntityClone(TestdataEntity originalEntity, TestdataEntity cloneEntity, String entityCode, String valueCode) {
        Assert.assertNotSame((Object)originalEntity, (Object)cloneEntity);
        PlannerAssert.assertCode(entityCode, originalEntity);
        PlannerAssert.assertCode(entityCode, cloneEntity);
        PlannerAssert.assertCode(valueCode, cloneEntity.getValue());
    }

    @Test
    public void cloneChainedSolution() {
        SolutionDescriptor solutionDescriptor = TestdataChainedSolution.buildSolutionDescriptor();
        SolutionCloner cloner = this.createSolutionCloner(solutionDescriptor);
        TestdataChainedAnchor a0 = new TestdataChainedAnchor("a0");
        TestdataChainedEntity a1 = new TestdataChainedEntity("a1", a0);
        TestdataChainedEntity a2 = new TestdataChainedEntity("a2", a1);
        TestdataChainedEntity a3 = new TestdataChainedEntity("a3", a2);
        TestdataChainedAnchor b0 = new TestdataChainedAnchor("b0");
        TestdataChainedEntity b1 = new TestdataChainedEntity("b1", b0);
        TestdataChainedSolution original = new TestdataChainedSolution("solution");
        List<TestdataChainedAnchor> anchorList = Arrays.asList(a0, b0);
        original.setChainedAnchorList(anchorList);
        List<TestdataChainedEntity> originalEntityList = Arrays.asList(a1, a2, a3, b1);
        original.setChainedEntityList(originalEntityList);
        TestdataChainedSolution clone = (TestdataChainedSolution)cloner.cloneSolution((Solution)original);
        Assert.assertNotSame((Object)original, (Object)clone);
        PlannerAssert.assertCode("solution", clone);
        Assert.assertSame(anchorList, clone.getChainedAnchorList());
        List<TestdataChainedEntity> cloneEntityList = clone.getChainedEntityList();
        Assert.assertNotSame(originalEntityList, cloneEntityList);
        Assert.assertEquals((long)4L, (long)cloneEntityList.size());
        TestdataChainedEntity cloneA1 = cloneEntityList.get(0);
        TestdataChainedEntity cloneA2 = cloneEntityList.get(1);
        TestdataChainedEntity cloneA3 = cloneEntityList.get(2);
        TestdataChainedEntity cloneB1 = cloneEntityList.get(3);
        this.assertChainedEntityClone(a1, cloneA1, "a1", a0);
        this.assertChainedEntityClone(a2, cloneA2, "a2", cloneA1);
        this.assertChainedEntityClone(a3, cloneA3, "a3", cloneA2);
        this.assertChainedEntityClone(b1, cloneB1, "b1", b0);
        a3.setChainedObject(b1);
        PlannerAssert.assertCode("b1", a3.getChainedObject());
        PlannerAssert.assertCode("a2", cloneA3.getChainedObject());
    }

    private void assertChainedEntityClone(TestdataChainedEntity originalEntity, TestdataChainedEntity cloneEntity, String entityCode, TestdataChainedObject value) {
        Assert.assertNotSame((Object)originalEntity, (Object)cloneEntity);
        PlannerAssert.assertCode(entityCode, originalEntity);
        PlannerAssert.assertCode(entityCode, cloneEntity);
        Assert.assertSame((Object)value, (Object)cloneEntity.getChainedObject());
    }

    @Test
    public void cloneSetBasedSolution() {
        SolutionDescriptor solutionDescriptor = TestdataSetBasedSolution.buildSolutionDescriptor();
        SolutionCloner cloner = this.createSolutionCloner(solutionDescriptor);
        TestdataValue val1 = new TestdataValue("1");
        TestdataValue val2 = new TestdataValue("2");
        TestdataValue val3 = new TestdataValue("3");
        TestdataSetBasedEntity a = new TestdataSetBasedEntity("a", val1);
        TestdataSetBasedEntity b = new TestdataSetBasedEntity("b", val1);
        TestdataSetBasedEntity c = new TestdataSetBasedEntity("c", val3);
        TestdataSetBasedEntity d = new TestdataSetBasedEntity("d", val3);
        TestdataSetBasedSolution original = new TestdataSetBasedSolution("solution");
        Comparator<TestdataValue> valueComparator = new Comparator<TestdataValue>(){

            @Override
            public int compare(TestdataValue a, TestdataValue b) {
                return b.getCode().compareTo(a.getCode());
            }
        };
        TreeSet<TestdataValue> valueSet = new TreeSet<TestdataValue>(valueComparator);
        valueSet.addAll(Arrays.asList(val1, val2, val3));
        original.setValueSet(valueSet);
        Comparator<TestdataSetBasedEntity> entityComparator = new Comparator<TestdataSetBasedEntity>(){

            @Override
            public int compare(TestdataSetBasedEntity a, TestdataSetBasedEntity b) {
                return b.getCode().compareTo(a.getCode());
            }
        };
        TreeSet<TestdataSetBasedEntity> originalEntitySet = new TreeSet<TestdataSetBasedEntity>(entityComparator);
        originalEntitySet.addAll(Arrays.asList(a, b, c, d));
        original.setEntitySet(originalEntitySet);
        TestdataSetBasedSolution clone = (TestdataSetBasedSolution)cloner.cloneSolution((Solution)original);
        Assert.assertNotSame((Object)original, (Object)clone);
        Assert.assertSame(valueSet, clone.getValueSet());
        Set<TestdataSetBasedEntity> cloneEntitySet = clone.getEntitySet();
        Assert.assertNotSame(originalEntitySet, cloneEntitySet);
        Assert.assertTrue((boolean)(cloneEntitySet instanceof SortedSet));
        Assert.assertSame((Object)entityComparator, ((SortedSet)cloneEntitySet).comparator());
        PlannerAssert.assertCode("solution", clone);
        Assert.assertEquals((long)4L, (long)cloneEntitySet.size());
        Iterator<TestdataSetBasedEntity> it = cloneEntitySet.iterator();
        TestdataSetBasedEntity cloneD = it.next();
        TestdataSetBasedEntity cloneC = it.next();
        TestdataSetBasedEntity cloneB = it.next();
        TestdataSetBasedEntity cloneA = it.next();
        this.assertSetBasedEntityClone(a, cloneA, "a", "1");
        this.assertSetBasedEntityClone(b, cloneB, "b", "1");
        this.assertSetBasedEntityClone(c, cloneC, "c", "3");
        this.assertSetBasedEntityClone(d, cloneD, "d", "3");
        b.setValue(val2);
        PlannerAssert.assertCode("2", b.getValue());
        PlannerAssert.assertCode("1", cloneB.getValue());
    }

    private void assertSetBasedEntityClone(TestdataSetBasedEntity originalEntity, TestdataSetBasedEntity cloneEntity, String entityCode, String valueCode) {
        Assert.assertNotSame((Object)originalEntity, (Object)cloneEntity);
        PlannerAssert.assertCode(entityCode, originalEntity);
        PlannerAssert.assertCode(entityCode, cloneEntity);
        PlannerAssert.assertCode(valueCode, cloneEntity.getValue());
    }
}

