/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.heuristic.selector.entity.decorator;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.drools.planner.core.heuristic.selector.SelectorTestUtils;
import org.drools.planner.core.heuristic.selector.common.SelectionCacheType;
import org.drools.planner.core.heuristic.selector.common.decorator.SelectionFilter;
import org.drools.planner.core.heuristic.selector.entity.EntitySelector;
import org.drools.planner.core.heuristic.selector.entity.decorator.CachingEntitySelector;
import org.drools.planner.core.heuristic.selector.entity.decorator.FilteringEntitySelector;
import org.drools.planner.core.phase.AbstractSolverPhaseScope;
import org.drools.planner.core.phase.event.SolverPhaseLifecycleListener;
import org.drools.planner.core.phase.step.AbstractStepScope;
import org.drools.planner.core.score.director.ScoreDirector;
import org.drools.planner.core.solver.scope.DefaultSolverScope;
import org.drools.planner.core.testdata.domain.TestdataEntity;
import org.drools.planner.core.testdata.util.PlannerAssert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class FilteringEntitySelectorTest {
    @Test
    public void cacheTypeSolver() {
        this.runCacheType(SelectionCacheType.SOLVER, 1);
    }

    @Test
    public void cacheTypePhase() {
        this.runCacheType(SelectionCacheType.PHASE, 2);
    }

    @Test
    public void cacheTypeStep() {
        this.runCacheType(SelectionCacheType.STEP, 5);
    }

    @Test
    public void cacheTypeJustInTime() {
        this.runCacheType(SelectionCacheType.JUST_IN_TIME, 5);
    }

    public void runCacheType(SelectionCacheType cacheType, int timesCalled) {
        EntitySelector childEntitySelector = SelectorTestUtils.mockEntitySelector(TestdataEntity.class, new TestdataEntity("e1"), new TestdataEntity("e2"), new TestdataEntity("e3"), new TestdataEntity("e4"));
        SelectionFilter<TestdataEntity> filter = new SelectionFilter<TestdataEntity>(){

            public boolean accept(ScoreDirector scoreDirector, TestdataEntity entity) {
                return !entity.getCode().equals("e3");
            }
        };
        List<SelectionFilter> filterList = Arrays.asList(filter);
        FilteringEntitySelector entitySelector = new FilteringEntitySelector(childEntitySelector, filterList);
        if (cacheType.isCached()) {
            entitySelector = new CachingEntitySelector((EntitySelector)entitySelector, cacheType, false);
        }
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        entitySelector.solvingStarted(solverScope);
        AbstractSolverPhaseScope phaseScopeA = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        entitySelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        entitySelector.stepStarted(stepScopeA1);
        this.runAsserts((EntitySelector)entitySelector, cacheType);
        entitySelector.stepEnded(stepScopeA1);
        AbstractStepScope stepScopeA2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA2.getPhaseScope()).thenReturn((Object)phaseScopeA);
        entitySelector.stepStarted(stepScopeA2);
        this.runAsserts((EntitySelector)entitySelector, cacheType);
        entitySelector.stepEnded(stepScopeA2);
        entitySelector.phaseEnded(phaseScopeA);
        AbstractSolverPhaseScope phaseScopeB = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeB.getSolverScope()).thenReturn((Object)solverScope);
        entitySelector.phaseStarted(phaseScopeB);
        AbstractStepScope stepScopeB1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB1.getPhaseScope()).thenReturn((Object)phaseScopeB);
        entitySelector.stepStarted(stepScopeB1);
        this.runAsserts((EntitySelector)entitySelector, cacheType);
        entitySelector.stepEnded(stepScopeB1);
        AbstractStepScope stepScopeB2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB2.getPhaseScope()).thenReturn((Object)phaseScopeB);
        entitySelector.stepStarted(stepScopeB2);
        this.runAsserts((EntitySelector)entitySelector, cacheType);
        entitySelector.stepEnded(stepScopeB2);
        AbstractStepScope stepScopeB3 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB3.getPhaseScope()).thenReturn((Object)phaseScopeB);
        entitySelector.stepStarted(stepScopeB3);
        this.runAsserts((EntitySelector)entitySelector, cacheType);
        entitySelector.stepEnded(stepScopeB3);
        entitySelector.phaseEnded(phaseScopeB);
        entitySelector.solvingEnded(solverScope);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)childEntitySelector, 1, 2, 5);
        ((EntitySelector)Mockito.verify((Object)childEntitySelector, (VerificationMode)Mockito.times((int)timesCalled))).iterator();
        ((EntitySelector)Mockito.verify((Object)childEntitySelector, (VerificationMode)Mockito.times((int)timesCalled))).getSize();
    }

    private void runAsserts(EntitySelector entitySelector, SelectionCacheType cacheType) {
        Iterator iterator = entitySelector.iterator();
        PlannerAssert.assertNotNull((Object)iterator);
        PlannerAssert.assertTrue((boolean)iterator.hasNext());
        PlannerAssert.assertCode("e1", iterator.next());
        PlannerAssert.assertTrue((boolean)iterator.hasNext());
        PlannerAssert.assertCode("e2", iterator.next());
        PlannerAssert.assertTrue((boolean)iterator.hasNext());
        PlannerAssert.assertCode("e4", iterator.next());
        PlannerAssert.assertFalse((boolean)iterator.hasNext());
        PlannerAssert.assertEquals((Object)false, (Object)entitySelector.isContinuous());
        PlannerAssert.assertEquals((Object)false, (Object)entitySelector.isNeverEnding());
        PlannerAssert.assertEquals((long)(cacheType.isNotCached() ? 4L : 3L), (long)entitySelector.getSize());
    }
}

