/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.heuristic.selector.entity.decorator;

import java.util.Iterator;
import java.util.Random;
import org.drools.planner.core.heuristic.selector.SelectorTestUtils;
import org.drools.planner.core.heuristic.selector.common.SelectionCacheType;
import org.drools.planner.core.heuristic.selector.common.decorator.SelectionProbabilityWeightFactory;
import org.drools.planner.core.heuristic.selector.entity.EntitySelector;
import org.drools.planner.core.heuristic.selector.entity.decorator.ProbabilityEntitySelector;
import org.drools.planner.core.phase.AbstractSolverPhaseScope;
import org.drools.planner.core.phase.event.SolverPhaseLifecycleListener;
import org.drools.planner.core.phase.step.AbstractStepScope;
import org.drools.planner.core.score.director.ScoreDirector;
import org.drools.planner.core.solver.scope.DefaultSolverScope;
import org.drools.planner.core.testdata.domain.TestdataEntity;
import org.drools.planner.core.testdata.util.PlannerAssert;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ProbabilityEntitySelectorTest {
    @Test
    public void randomSelection() {
        EntitySelector childEntitySelector = SelectorTestUtils.mockEntitySelector(TestdataEntity.class, new TestdataEntity("e1"), new TestdataEntity("e2"), new TestdataEntity("e3"), new TestdataEntity("e4"));
        SelectionProbabilityWeightFactory<TestdataEntity> probabilityWeightFactory = new SelectionProbabilityWeightFactory<TestdataEntity>(){

            public double createProbabilityWeight(ScoreDirector scoreDirector, TestdataEntity entity) {
                if (entity.getCode().equals("e1")) {
                    return 1000.0;
                }
                if (entity.getCode().equals("e2")) {
                    return 200.0;
                }
                if (entity.getCode().equals("e3")) {
                    return 30.0;
                }
                if (entity.getCode().equals("e4")) {
                    return 4.0;
                }
                throw new IllegalStateException("Unknown entity (" + entity + ").");
            }
        };
        ProbabilityEntitySelector entitySelector = new ProbabilityEntitySelector(childEntitySelector, SelectionCacheType.STEP, (SelectionProbabilityWeightFactory)probabilityWeightFactory);
        Random workingRandom = (Random)Mockito.mock(Random.class);
        Mockito.when((Object)workingRandom.nextDouble()).thenReturn((Object)0.9902755267423015, (Object[])new Double[]{0.08995137763371151, 0.0, 0.9967585089141004, 0.9716369529983793});
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        Mockito.when((Object)solverScope.getWorkingRandom()).thenReturn((Object)workingRandom);
        entitySelector.solvingStarted(solverScope);
        AbstractSolverPhaseScope phaseScopeA = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        Mockito.when((Object)phaseScopeA.getWorkingRandom()).thenReturn((Object)workingRandom);
        entitySelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        Mockito.when((Object)stepScopeA1.getWorkingRandom()).thenReturn((Object)workingRandom);
        entitySelector.stepStarted(stepScopeA1);
        Assert.assertEquals((Object)false, (Object)entitySelector.isContinuous());
        Assert.assertEquals((Object)true, (Object)entitySelector.isNeverEnding());
        Assert.assertEquals((long)4L, (long)entitySelector.getSize());
        Iterator iterator = entitySelector.iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        PlannerAssert.assertCode("e3", iterator.next());
        Assert.assertTrue((boolean)iterator.hasNext());
        PlannerAssert.assertCode("e1", iterator.next());
        Assert.assertTrue((boolean)iterator.hasNext());
        PlannerAssert.assertCode("e1", iterator.next());
        Assert.assertTrue((boolean)iterator.hasNext());
        PlannerAssert.assertCode("e4", iterator.next());
        Assert.assertTrue((boolean)iterator.hasNext());
        PlannerAssert.assertCode("e2", iterator.next());
        Assert.assertTrue((boolean)iterator.hasNext());
        entitySelector.stepEnded(stepScopeA1);
        entitySelector.phaseEnded(phaseScopeA);
        entitySelector.solvingEnded(solverScope);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)childEntitySelector, 1, 1, 1);
        ((EntitySelector)Mockito.verify((Object)childEntitySelector, (VerificationMode)Mockito.times((int)1))).iterator();
    }
}

