/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.heuristic.selector.move.decorator;

import java.util.Random;
import org.drools.planner.core.heuristic.selector.SelectorTestUtils;
import org.drools.planner.core.heuristic.selector.common.SelectionCacheType;
import org.drools.planner.core.heuristic.selector.common.decorator.SelectionProbabilityWeightFactory;
import org.drools.planner.core.heuristic.selector.move.MoveSelector;
import org.drools.planner.core.heuristic.selector.move.decorator.ProbabilityMoveSelector;
import org.drools.planner.core.move.DummyMove;
import org.drools.planner.core.phase.AbstractSolverPhaseScope;
import org.drools.planner.core.phase.event.SolverPhaseLifecycleListener;
import org.drools.planner.core.phase.step.AbstractStepScope;
import org.drools.planner.core.score.director.ScoreDirector;
import org.drools.planner.core.solver.scope.DefaultSolverScope;
import org.drools.planner.core.testdata.util.PlannerAssert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ProbabilityMoveSelectorTest {
    @Test
    public void randomSelection() {
        MoveSelector childMoveSelector = SelectorTestUtils.mockMoveSelector(DummyMove.class, new DummyMove("e1"), new DummyMove("e2"), new DummyMove("e3"), new DummyMove("e4"));
        SelectionProbabilityWeightFactory<DummyMove> probabilityWeightFactory = new SelectionProbabilityWeightFactory<DummyMove>(){

            public double createProbabilityWeight(ScoreDirector scoreDirector, DummyMove move) {
                if (move.getCode().equals("e1")) {
                    return 1000.0;
                }
                if (move.getCode().equals("e2")) {
                    return 200.0;
                }
                if (move.getCode().equals("e3")) {
                    return 30.0;
                }
                if (move.getCode().equals("e4")) {
                    return 4.0;
                }
                throw new IllegalStateException("Unknown move (" + move + ").");
            }
        };
        ProbabilityMoveSelector moveSelector = new ProbabilityMoveSelector(childMoveSelector, SelectionCacheType.STEP, (SelectionProbabilityWeightFactory)probabilityWeightFactory);
        Random workingRandom = (Random)Mockito.mock(Random.class);
        Mockito.when((Object)workingRandom.nextDouble()).thenReturn((Object)0.9902755267423015, (Object[])new Double[]{0.08995137763371151, 0.0, 0.9967585089141004, 0.9716369529983793});
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        Mockito.when((Object)solverScope.getWorkingRandom()).thenReturn((Object)workingRandom);
        moveSelector.solvingStarted(solverScope);
        AbstractSolverPhaseScope phaseScopeA = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        Mockito.when((Object)phaseScopeA.getWorkingRandom()).thenReturn((Object)workingRandom);
        moveSelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        Mockito.when((Object)stepScopeA1.getWorkingRandom()).thenReturn((Object)workingRandom);
        moveSelector.stepStarted(stepScopeA1);
        PlannerAssert.assertCodesOfNeverEndingMoveSelector((MoveSelector)moveSelector, 4L, "e3", "e1", "e1", "e4", "e2");
        moveSelector.stepEnded(stepScopeA1);
        moveSelector.phaseEnded(phaseScopeA);
        moveSelector.solvingEnded(solverScope);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)childMoveSelector, 1, 1, 1);
        ((MoveSelector)Mockito.verify((Object)childMoveSelector, (VerificationMode)Mockito.times((int)1))).iterator();
    }
}

