/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.heuristic.selector.value.decorator;

import java.util.Iterator;
import org.drools.planner.core.heuristic.selector.SelectorTestUtils;
import org.drools.planner.core.heuristic.selector.common.SelectionCacheType;
import org.drools.planner.core.heuristic.selector.value.EntityIndependentValueSelector;
import org.drools.planner.core.heuristic.selector.value.decorator.CachingValueSelector;
import org.drools.planner.core.phase.AbstractSolverPhaseScope;
import org.drools.planner.core.phase.event.SolverPhaseLifecycleListener;
import org.drools.planner.core.phase.step.AbstractStepScope;
import org.drools.planner.core.solver.scope.DefaultSolverScope;
import org.drools.planner.core.testdata.domain.TestdataEntity;
import org.drools.planner.core.testdata.domain.TestdataValue;
import org.drools.planner.core.testdata.util.PlannerAssert;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class CachingValueSelectorTest {
    @Test
    public void originalSelectionCacheTypeSolver() {
        this.runOriginalSelection(SelectionCacheType.SOLVER, 1);
    }

    @Test
    public void originalSelectionCacheTypePhase() {
        this.runOriginalSelection(SelectionCacheType.PHASE, 2);
    }

    @Test
    public void originalSelectionCacheTypeStep() {
        this.runOriginalSelection(SelectionCacheType.STEP, 5);
    }

    public void runOriginalSelection(SelectionCacheType cacheType, int timesCalled) {
        EntityIndependentValueSelector childValueSelector = SelectorTestUtils.mockEntityIndependentValueSelector(TestdataEntity.class, "value", new TestdataValue("e1"), new TestdataValue("e2"), new TestdataValue("e3"));
        CachingValueSelector valueSelector = new CachingValueSelector(childValueSelector, cacheType, false);
        ((EntityIndependentValueSelector)Mockito.verify((Object)childValueSelector, (VerificationMode)Mockito.times((int)1))).isNeverEnding();
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        valueSelector.solvingStarted(solverScope);
        AbstractSolverPhaseScope phaseScopeA = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        valueSelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        valueSelector.stepStarted(stepScopeA1);
        this.runAsserts(valueSelector);
        valueSelector.stepEnded(stepScopeA1);
        AbstractStepScope stepScopeA2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA2.getPhaseScope()).thenReturn((Object)phaseScopeA);
        valueSelector.stepStarted(stepScopeA2);
        this.runAsserts(valueSelector);
        valueSelector.stepEnded(stepScopeA2);
        valueSelector.phaseEnded(phaseScopeA);
        AbstractSolverPhaseScope phaseScopeB = (AbstractSolverPhaseScope)Mockito.mock(AbstractSolverPhaseScope.class);
        Mockito.when((Object)phaseScopeB.getSolverScope()).thenReturn((Object)solverScope);
        valueSelector.phaseStarted(phaseScopeB);
        AbstractStepScope stepScopeB1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB1.getPhaseScope()).thenReturn((Object)phaseScopeB);
        valueSelector.stepStarted(stepScopeB1);
        this.runAsserts(valueSelector);
        valueSelector.stepEnded(stepScopeB1);
        AbstractStepScope stepScopeB2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB2.getPhaseScope()).thenReturn((Object)phaseScopeB);
        valueSelector.stepStarted(stepScopeB2);
        this.runAsserts(valueSelector);
        valueSelector.stepEnded(stepScopeB2);
        AbstractStepScope stepScopeB3 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB3.getPhaseScope()).thenReturn((Object)phaseScopeB);
        valueSelector.stepStarted(stepScopeB3);
        this.runAsserts(valueSelector);
        valueSelector.stepEnded(stepScopeB3);
        valueSelector.phaseEnded(phaseScopeB);
        valueSelector.solvingEnded(solverScope);
        PlannerAssert.verifySolverPhaseLifecycle((SolverPhaseLifecycleListener)childValueSelector, 1, 2, 5);
        ((EntityIndependentValueSelector)Mockito.verify((Object)childValueSelector, (VerificationMode)Mockito.times((int)timesCalled))).iterator();
        ((EntityIndependentValueSelector)Mockito.verify((Object)childValueSelector, (VerificationMode)Mockito.times((int)timesCalled))).getSize();
    }

    private void runAsserts(CachingValueSelector valueSelector) {
        Iterator iterator = valueSelector.iterator();
        Assert.assertNotNull((Object)iterator);
        Assert.assertTrue((boolean)iterator.hasNext());
        PlannerAssert.assertCode("e1", iterator.next());
        Assert.assertTrue((boolean)iterator.hasNext());
        PlannerAssert.assertCode("e2", iterator.next());
        Assert.assertTrue((boolean)iterator.hasNext());
        PlannerAssert.assertCode("e3", iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((Object)false, (Object)valueSelector.isContinuous());
        Assert.assertEquals((Object)false, (Object)valueSelector.isNeverEnding());
        Assert.assertEquals((long)3L, (long)valueSelector.getSize());
    }
}

