/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.localsearch.decider.forager;

import java.util.Random;
import org.drools.planner.core.localsearch.decider.deciderscorecomparator.DeciderScoreComparatorFactory;
import org.drools.planner.core.localsearch.decider.deciderscorecomparator.NaturalDeciderScoreComparatorFactory;
import org.drools.planner.core.localsearch.decider.forager.AcceptedForager;
import org.drools.planner.core.localsearch.decider.forager.PickEarlyType;
import org.drools.planner.core.localsearch.scope.LocalSearchMoveScope;
import org.drools.planner.core.localsearch.scope.LocalSearchSolverPhaseScope;
import org.drools.planner.core.localsearch.scope.LocalSearchStepScope;
import org.drools.planner.core.move.DummyMove;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.score.Score;
import org.drools.planner.core.score.buildin.simple.SimpleScore;
import org.drools.planner.core.score.buildin.simple.SimpleScoreDefinition;
import org.drools.planner.core.score.definition.ScoreDefinition;
import org.drools.planner.core.score.director.ScoreDirector;
import org.drools.planner.core.score.director.drools.DroolsScoreDirectorFactory;
import org.drools.planner.core.solver.scope.DefaultSolverScope;
import org.drools.planner.core.testdata.domain.TestdataSolution;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class AcceptedForagerTest {
    @Test
    public void pickMoveMaxScoreAccepted() {
        AcceptedForager forager = new AcceptedForager(PickEarlyType.NEVER, Integer.MAX_VALUE);
        forager.setDeciderScoreComparatorFactory((DeciderScoreComparatorFactory)new NaturalDeciderScoreComparatorFactory());
        LocalSearchSolverPhaseScope localSearchSolverPhaseScope = this.createLocalSearchSolverPhaseScope();
        forager.phaseStarted(localSearchSolverPhaseScope);
        LocalSearchStepScope localSearchStepScope = this.createStepScope(localSearchSolverPhaseScope);
        forager.stepStarted(localSearchStepScope);
        LocalSearchMoveScope a = this.createMoveScope(localSearchStepScope, (Score)SimpleScore.valueOf((int)-20), true);
        LocalSearchMoveScope b = this.createMoveScope(localSearchStepScope, (Score)SimpleScore.valueOf((int)-1), false);
        LocalSearchMoveScope c = this.createMoveScope(localSearchStepScope, (Score)SimpleScore.valueOf((int)-20), false);
        LocalSearchMoveScope d = this.createMoveScope(localSearchStepScope, (Score)SimpleScore.valueOf((int)-2), true);
        LocalSearchMoveScope e = this.createMoveScope(localSearchStepScope, (Score)SimpleScore.valueOf((int)-300), true);
        forager.addMove(a);
        Assert.assertFalse((boolean)forager.isQuitEarly());
        forager.addMove(b);
        Assert.assertFalse((boolean)forager.isQuitEarly());
        forager.addMove(c);
        Assert.assertFalse((boolean)forager.isQuitEarly());
        forager.addMove(d);
        Assert.assertFalse((boolean)forager.isQuitEarly());
        forager.addMove(e);
        Assert.assertFalse((boolean)forager.isQuitEarly());
        LocalSearchMoveScope pickedScope = forager.pickMove(localSearchStepScope);
        Assert.assertSame((Object)d, (Object)pickedScope);
        forager.phaseEnded(localSearchSolverPhaseScope);
    }

    @Test
    public void pickMoveMaxScoreUnaccepted() {
        AcceptedForager forager = new AcceptedForager(PickEarlyType.NEVER, Integer.MAX_VALUE);
        forager.setDeciderScoreComparatorFactory((DeciderScoreComparatorFactory)new NaturalDeciderScoreComparatorFactory());
        LocalSearchSolverPhaseScope localSearchSolverPhaseScope = this.createLocalSearchSolverPhaseScope();
        forager.phaseStarted(localSearchSolverPhaseScope);
        LocalSearchStepScope localSearchStepScope = this.createStepScope(localSearchSolverPhaseScope);
        forager.stepStarted(localSearchStepScope);
        LocalSearchMoveScope a = this.createMoveScope(localSearchStepScope, (Score)SimpleScore.valueOf((int)-20), false);
        LocalSearchMoveScope b = this.createMoveScope(localSearchStepScope, (Score)SimpleScore.valueOf((int)-1), false);
        LocalSearchMoveScope c = this.createMoveScope(localSearchStepScope, (Score)SimpleScore.valueOf((int)-20), false);
        LocalSearchMoveScope d = this.createMoveScope(localSearchStepScope, (Score)SimpleScore.valueOf((int)-2), false);
        LocalSearchMoveScope e = this.createMoveScope(localSearchStepScope, (Score)SimpleScore.valueOf((int)-300), false);
        forager.addMove(a);
        Assert.assertFalse((boolean)forager.isQuitEarly());
        forager.addMove(b);
        Assert.assertFalse((boolean)forager.isQuitEarly());
        forager.addMove(c);
        Assert.assertFalse((boolean)forager.isQuitEarly());
        forager.addMove(d);
        Assert.assertFalse((boolean)forager.isQuitEarly());
        forager.addMove(e);
        Assert.assertFalse((boolean)forager.isQuitEarly());
        LocalSearchMoveScope pickedScope = forager.pickMove(localSearchStepScope);
        Assert.assertSame((Object)b, (Object)pickedScope);
        forager.phaseEnded(localSearchSolverPhaseScope);
    }

    @Test
    public void pickMoveFirstBestScoreImproving() {
        AcceptedForager forager = new AcceptedForager(PickEarlyType.FIRST_BEST_SCORE_IMPROVING, Integer.MAX_VALUE);
        forager.setDeciderScoreComparatorFactory((DeciderScoreComparatorFactory)new NaturalDeciderScoreComparatorFactory());
        LocalSearchSolverPhaseScope localSearchSolverPhaseScope = this.createLocalSearchSolverPhaseScope();
        forager.phaseStarted(localSearchSolverPhaseScope);
        LocalSearchStepScope localSearchStepScope = this.createStepScope(localSearchSolverPhaseScope);
        forager.stepStarted(localSearchStepScope);
        LocalSearchMoveScope a = this.createMoveScope(localSearchStepScope, (Score)SimpleScore.valueOf((int)-1), false);
        LocalSearchMoveScope b = this.createMoveScope(localSearchStepScope, (Score)SimpleScore.valueOf((int)-20), true);
        LocalSearchMoveScope c = this.createMoveScope(localSearchStepScope, (Score)SimpleScore.valueOf((int)-300), true);
        LocalSearchMoveScope d = this.createMoveScope(localSearchStepScope, (Score)SimpleScore.valueOf((int)-1), true);
        forager.addMove(a);
        Assert.assertFalse((boolean)forager.isQuitEarly());
        forager.addMove(b);
        Assert.assertFalse((boolean)forager.isQuitEarly());
        forager.addMove(c);
        Assert.assertFalse((boolean)forager.isQuitEarly());
        forager.addMove(d);
        Assert.assertTrue((boolean)forager.isQuitEarly());
        LocalSearchMoveScope pickedScope = forager.pickMove(localSearchStepScope);
        Assert.assertSame((Object)d, (Object)pickedScope);
        forager.phaseEnded(localSearchSolverPhaseScope);
    }

    @Test
    public void pickMoveFirstLastStepScoreImproving() {
        AcceptedForager forager = new AcceptedForager(PickEarlyType.FIRST_LAST_STEP_SCORE_IMPROVING, Integer.MAX_VALUE);
        forager.setDeciderScoreComparatorFactory((DeciderScoreComparatorFactory)new NaturalDeciderScoreComparatorFactory());
        LocalSearchSolverPhaseScope localSearchSolverPhaseScope = this.createLocalSearchSolverPhaseScope();
        forager.phaseStarted(localSearchSolverPhaseScope);
        LocalSearchStepScope localSearchStepScope = this.createStepScope(localSearchSolverPhaseScope);
        forager.stepStarted(localSearchStepScope);
        LocalSearchMoveScope a = this.createMoveScope(localSearchStepScope, (Score)SimpleScore.valueOf((int)-1), false);
        LocalSearchMoveScope b = this.createMoveScope(localSearchStepScope, (Score)SimpleScore.valueOf((int)-300), true);
        LocalSearchMoveScope c = this.createMoveScope(localSearchStepScope, (Score)SimpleScore.valueOf((int)-4000), true);
        LocalSearchMoveScope d = this.createMoveScope(localSearchStepScope, (Score)SimpleScore.valueOf((int)-20), true);
        forager.addMove(a);
        Assert.assertFalse((boolean)forager.isQuitEarly());
        forager.addMove(b);
        Assert.assertFalse((boolean)forager.isQuitEarly());
        forager.addMove(c);
        Assert.assertFalse((boolean)forager.isQuitEarly());
        forager.addMove(d);
        Assert.assertTrue((boolean)forager.isQuitEarly());
        LocalSearchMoveScope pickedScope = forager.pickMove(localSearchStepScope);
        Assert.assertSame((Object)d, (Object)pickedScope);
        forager.phaseEnded(localSearchSolverPhaseScope);
    }

    @Test
    public void pickMoveAcceptedRandomly() {
        AcceptedForager forager = new AcceptedForager(PickEarlyType.NEVER, 3);
        forager.setDeciderScoreComparatorFactory((DeciderScoreComparatorFactory)new NaturalDeciderScoreComparatorFactory());
        LocalSearchSolverPhaseScope localSearchSolverPhaseScope = this.createLocalSearchSolverPhaseScope();
        forager.phaseStarted(localSearchSolverPhaseScope);
        LocalSearchStepScope localSearchStepScope = this.createStepScope(localSearchSolverPhaseScope);
        forager.stepStarted(localSearchStepScope);
        LocalSearchMoveScope a = this.createMoveScope(localSearchStepScope, (Score)SimpleScore.valueOf((int)-20), false);
        LocalSearchMoveScope b = this.createMoveScope(localSearchStepScope, (Score)SimpleScore.valueOf((int)-1), true);
        LocalSearchMoveScope c = this.createMoveScope(localSearchStepScope, (Score)SimpleScore.valueOf((int)-1), true);
        LocalSearchMoveScope d = this.createMoveScope(localSearchStepScope, (Score)SimpleScore.valueOf((int)-20), true);
        forager.addMove(a);
        Assert.assertFalse((boolean)forager.isQuitEarly());
        forager.addMove(b);
        Assert.assertFalse((boolean)forager.isQuitEarly());
        forager.addMove(c);
        Assert.assertFalse((boolean)forager.isQuitEarly());
        forager.addMove(d);
        Assert.assertTrue((boolean)forager.isQuitEarly());
        LocalSearchMoveScope pickedScope = forager.pickMove(localSearchStepScope);
        Assert.assertSame((Object)b, (Object)pickedScope);
        forager.phaseEnded(localSearchSolverPhaseScope);
    }

    private LocalSearchSolverPhaseScope createLocalSearchSolverPhaseScope() {
        DefaultSolverScope solverScope = new DefaultSolverScope();
        LocalSearchSolverPhaseScope localSearchSolverPhaseScope = new LocalSearchSolverPhaseScope(solverScope);
        DroolsScoreDirectorFactory scoreDirectorFactory = new DroolsScoreDirectorFactory();
        scoreDirectorFactory.setSolutionDescriptor(TestdataSolution.buildSolutionDescriptor());
        scoreDirectorFactory.setScoreDefinition((ScoreDefinition)new SimpleScoreDefinition());
        solverScope.setScoreDirector((ScoreDirector)scoreDirectorFactory.buildScoreDirector());
        Random workingRandom = (Random)Mockito.mock(Random.class);
        Mockito.when((Object)workingRandom.nextInt(2)).thenReturn((Object)0);
        solverScope.setWorkingRandom(workingRandom);
        solverScope.setBestScore((Score)SimpleScore.valueOf((int)-10));
        LocalSearchStepScope lastLocalSearchStepScope = new LocalSearchStepScope(localSearchSolverPhaseScope);
        lastLocalSearchStepScope.setScore((Score)SimpleScore.valueOf((int)-100));
        localSearchSolverPhaseScope.setLastCompletedStepScope(lastLocalSearchStepScope);
        return localSearchSolverPhaseScope;
    }

    private LocalSearchStepScope createStepScope(LocalSearchSolverPhaseScope localSearchSolverPhaseScope) {
        LocalSearchStepScope localSearchStepScope = new LocalSearchStepScope(localSearchSolverPhaseScope);
        return localSearchStepScope;
    }

    public LocalSearchMoveScope createMoveScope(LocalSearchStepScope localSearchStepScope, Score score, boolean accepted) {
        LocalSearchMoveScope moveScope = new LocalSearchMoveScope(localSearchStepScope);
        moveScope.setMove((Move)new DummyMove());
        moveScope.setScore(score);
        moveScope.setAccepted(Boolean.valueOf(accepted));
        return moveScope;
    }
}

