/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.score.buildin;

import org.drools.planner.core.score.FeasibilityScore;
import org.drools.planner.core.score.Score;
import org.junit.Assert;

public abstract class AbstractScoreTest {
    public static void assertLesser(Score a, Score b) {
        Assert.assertTrue((String)("Score (" + a + ") must be lesser than score (" + b + ")."), (a.compareTo((Object)b) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Score (" + b + ") must be greater than score (" + a + ")."), (b.compareTo((Object)a) > 0 ? 1 : 0) != 0);
    }

    public static void assertGreater(Score a, Score b) {
        Assert.assertTrue((String)("Score (" + a + ") must be greater than score (" + b + ")."), (a.compareTo((Object)b) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Score (" + b + ") must be lesser than score (" + a + ")."), (b.compareTo((Object)a) < 0 ? 1 : 0) != 0);
    }

    public static void assertScoreCompareToOrder(Score ... scores) {
        for (int i = 0; i < scores.length; ++i) {
            for (int j = i + 1; j < scores.length; ++j) {
                AbstractScoreTest.assertLesser(scores[i], scores[j]);
            }
        }
    }

    public static void assertScoresEqualsAndHashCode(Score ... scores) {
        for (int i = 0; i < scores.length; ++i) {
            for (int j = i + 1; j < scores.length; ++j) {
                Assert.assertEquals((Object)scores[i], (Object)scores[j]);
                Assert.assertEquals((long)scores[i].hashCode(), (long)scores[j].hashCode());
                Assert.assertEquals((long)0L, (long)scores[i].compareTo((Object)scores[j]));
            }
        }
    }

    public static void assertScoreNotFeasible(FeasibilityScore ... scores) {
        for (FeasibilityScore score : scores) {
            Assert.assertEquals((Object)false, (Object)score.isFeasible());
        }
    }

    public static void assertScoreFeasible(FeasibilityScore ... scores) {
        for (FeasibilityScore score : scores) {
            Assert.assertEquals((Object)true, (Object)score.isFeasible());
        }
    }
}

